/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.debugger.engine.DefaultJSPPositionManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PositionManagerWithWebSphereSpecificJSPLineMappingCorrection
extends DefaultJSPPositionManager {
    @NonNls
    private static final String SOURCE_LOCATION_FIELD = "_jspx_debug_jspSourceLocation";
    @NonNls
    private static final String FILE_MAPPING_FIELD = "_jspx_debug_FileMapping";
    @NonNls
    private static final String LINE_MAPPING_FIELD = "_jspx_debug_LineMapping";

    public PositionManagerWithWebSphereSpecificJSPLineMappingCorrection(DebugProcess process, JavaeeFacet[] facets) {
        super(process, facets);
    }

    protected int getLineNumber(Location location) {
        int lineNumberIndex = super.getLineNumber(location);
        try {
            Value lineNumber;
            ArrayReference lines = PositionManagerWithWebSphereSpecificJSPLineMappingCorrection.getIndex2LineArray(location.declaringType(), 1);
            if (lines != null && (lineNumber = lines.getValue(lineNumberIndex)) instanceof StringReference) {
                return Integer.parseInt(((StringReference)lineNumber).value());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lineNumberIndex;
    }

    @Nullable
    private static ArrayReference getIndex2LineArray(ReferenceType type, int i) {
        Value value;
        Value lines = null;
        Field field = type.fieldByName(LINE_MAPPING_FIELD);
        if (field != null && (value = type.getValue(field)) instanceof ArrayReference) {
            lines = ((ArrayReference)value).getValue(i);
        }
        return lines instanceof ArrayReference ? (ArrayReference)lines : null;
    }

    protected List<Location> getLocationsOfLine(ReferenceType type, String fileName, String relativePath, int lineNumber) throws AbsentInformationException {
        ArrayReference lineArray = PositionManagerWithWebSphereSpecificJSPLineMappingCorrection.getIndex2LineArray(type, 1);
        if (lineArray != null) {
            String lineNumberString = String.valueOf(lineNumber);
            int length = lineArray.length();
            for (int i = 0; i < length; ++i) {
                Value value = lineArray.getValue(i);
                if (!(value instanceof StringReference) || !lineNumberString.equals(((StringReference)value).value())) continue;
                return DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (int)i);
            }
        }
        return DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (String)this.getStratumId(), (String)fileName, (int)lineNumber);
    }

    protected String getRelativeSourcePathByLocation(Location location) throws AbsentInformationException {
        ReferenceType type = location.declaringType();
        try {
            int lineNumberIndex;
            Value lineNumber;
            ArrayReference lines = PositionManagerWithWebSphereSpecificJSPLineMappingCorrection.getIndex2LineArray(type, 0);
            if (lines != null && (lineNumber = lines.getValue(lineNumberIndex = super.getLineNumber(location))) instanceof StringReference) {
                Value path;
                int filePathIndex = Integer.parseInt(((StringReference)lineNumber).value());
                ArrayReference paths = PositionManagerWithWebSphereSpecificJSPLineMappingCorrection.getFilePath2IndexArray(type, 0);
                if (paths != null && (path = paths.getValue(filePathIndex)) instanceof StringReference) {
                    return ((StringReference)path).value();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getRelativeSourcePathByLocation(location);
    }

    @Nullable
    private static ArrayReference getFilePath2IndexArray(ReferenceType type, int i) {
        Value value1;
        Value value;
        Field field = type.fieldByName(FILE_MAPPING_FIELD);
        if (field != null && (value = type.getValue(field)) instanceof ArrayReference && (value1 = ((ArrayReference)value).getValue(i)) instanceof ArrayReference) {
            return (ArrayReference)value1;
        }
        return null;
    }

    protected List<String> getRelativeSourePathsByType(ReferenceType type) throws AbsentInformationException {
        ArrayReference pathsArray = PositionManagerWithWebSphereSpecificJSPLineMappingCorrection.getFilePath2IndexArray(type, 0);
        if (pathsArray != null) {
            ArrayList<String> paths = new ArrayList<String>();
            for (int i = 0; i < pathsArray.length(); ++i) {
                Value path = pathsArray.getValue(i);
                if (!(path instanceof StringReference)) continue;
                paths.add(((StringReference)path).value());
            }
            return paths;
        }
        return super.getRelativeSourePathsByType(type);
    }

    protected void defaultOnClassPrepare(DebugProcess process, ReferenceType type, SourcePosition position, ClassPrepareRequestor requestor) {
        super.onClassPrepare(process, type, position, requestor);
    }

    protected void onClassPrepare(final DebugProcess process, final ReferenceType type, final SourcePosition position, final ClassPrepareRequestor requestor) {
        if (!type.isInitialized() && type.fieldByName(SOURCE_LOCATION_FIELD) != null) {
            final RequestManagerImpl requestManager = (RequestManagerImpl)process.getRequestsManager();
            MethodExitRequest request = type.virtualMachine().eventRequestManager().createMethodExitRequest();
            request.addClassFilter(type);
            requestManager.registerRequestInternal((Requestor)new LocatableEventRequestor(){

                public String getSuspendPolicy() {
                    return "SuspendNone";
                }

                public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
                    if (action == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PositionManagerWithWebSphereSpecificJSPLineMappingCorrection.this.defaultOnClassPrepare(process, type, position, requestor);
                    requestManager.deleteRequest((Requestor)this);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/javaee/web/debugger/engine/PositionManagerWithWebSphereSpecificJSPLineMappingCorrection$1", "processLocatableEvent"));
                }
            }, (EventRequest)request);
            requestManager.enableRequest((EventRequest)request);
        } else {
            this.defaultOnClassPrepare(process, type, position, requestor);
        }
    }
}

