/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.impl.JsTestFileInfo;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\"\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"isEligibleTestFileFast", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEligibleTestFile", "tryIsTestFile", "project", "Lcom/intellij/openapi/project/Project;", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "passedJsFile", "IS_PROBABLY_TEST_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "IS_PROBABLY_TEST_FILE_ATTRIBUTE", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "setIsProbablyTestFileCached", "", "isTestFile", "writeIsTestFileAttribute", "readIsTestFileAttribute", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "getIsProbablyTestFileCached", "intellij.javascript.backend"})
public final class JsTestFileUtilsKt {
    @NotNull
    private static final Key<Boolean> IS_PROBABLY_TEST_FILE_KEY;
    @NotNull
    private static final FileAttribute IS_PROBABLY_TEST_FILE_ATTRIBUTE;

    private static final boolean isEligibleTestFileFast(VirtualFile file) {
        return file.isValid() && !file.isDirectory() && file.isInLocalFileSystem();
    }

    public static final boolean isEligibleTestFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!JsTestFileUtilsKt.isEligibleTestFileFast(file)) {
            return false;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)0x100000L)) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!JsTestFileInfo.Companion.isTestFileName(string)) {
                return false;
            }
        }
        return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)file) && !TypeScriptUtil.isDefinitionFile((VirtualFile)file);
    }

    @ApiStatus.Internal
    public static final boolean tryIsTestFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JsTestFileUtilsKt.tryIsTestFile(file, null, project);
    }

    @ApiStatus.Internal
    public static final boolean tryIsTestFile(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        VirtualFile virtualFile = jsFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = jsFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JsTestFileUtilsKt.tryIsTestFile(virtualFile2, jsFile, project);
    }

    @ApiStatus.Internal
    private static final boolean tryIsTestFile(VirtualFile file, JSFile passedJsFile, Project project) {
        if (!JsTestFileUtilsKt.isEligibleTestFileFast(file)) {
            return false;
        }
        JSFile jSFile = passedJsFile;
        PsiFile psiFile = jSFile != null ? (PsiFile)jSFile : (PsiFile)ReadAction.compute(() -> JsTestFileUtilsKt.tryIsTestFile$lambda$0(project, file));
        JSFile jSFile2 = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        if (jSFile2 == null) {
            return false;
        }
        JSFile jsFile = jSFile2;
        if (jsFile.isNamedAsTest()) {
            return true;
        }
        JSFileBaseImpl jSFileBaseImpl = jsFile instanceof JSFileBaseImpl ? (JSFileBaseImpl)jsFile : null;
        if (jSFileBaseImpl == null) {
            return false;
        }
        JSFileBaseImpl jsFileBaseImpl = jSFileBaseImpl;
        JSFileCachedData jSFileCachedData = jsFileBaseImpl.tryGetCachedData();
        if (jSFileCachedData != null) {
            JSFileCachedData it = jSFileCachedData;
            boolean bl = false;
            return it.mayHaveTests();
        }
        Boolean bl = JsTestFileUtilsKt.getIsProbablyTestFileCached(file);
        return bl != null ? bl : false;
    }

    public static final void setIsProbablyTestFileCached(@NotNull VirtualFile file, boolean isTestFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Boolean prevValue = (Boolean)file.getUserData(IS_PROBABLY_TEST_FILE_KEY);
        if (!Intrinsics.areEqual((Object)prevValue, (Object)isTestFile)) {
            file.putUserData(IS_PROBABLY_TEST_FILE_KEY, (Object)isTestFile);
            JsTestFileUtilsKt.writeIsTestFileAttribute(file, isTestFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeIsTestFileAttribute(VirtualFile file, boolean isTestFile) {
        try {
            boolean bl = false;
            Closeable closeable = (Closeable)IS_PROBABLY_TEST_FILE_ATTRIBUTE.writeFileAttribute(file);
            Throwable throwable = null;
            try {
                AttributeOutputStream outputStream = (AttributeOutputStream)closeable;
                boolean bl2 = false;
                outputStream.writeBoolean(isTestFile);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean readIsTestFileAttribute(VirtualFile file) {
        Object object;
        try {
            Boolean bl;
            boolean bl2 = false;
            AttributeInputStream attributeInputStream = IS_PROBABLY_TEST_FILE_ATTRIBUTE.readFileAttribute(file);
            if (attributeInputStream != null) {
                Closeable closeable = (Closeable)attributeInputStream;
                Throwable throwable = null;
                try {
                    AttributeInputStream inputStream = (AttributeInputStream)closeable;
                    boolean bl3 = false;
                    Boolean bl4 = inputStream.readBoolean();
                    bl = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                bl = null;
            }
            object = Result.constructor-impl(bl);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (Boolean)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final Boolean getIsProbablyTestFileCached(VirtualFile file) {
        Boolean bl = (Boolean)file.getUserData(IS_PROBABLY_TEST_FILE_KEY);
        if (bl == null) {
            Boolean bl2 = JsTestFileUtilsKt.readIsTestFileAttribute(file);
            if (bl2 != null) {
                Boolean bl3 = bl2;
                boolean it = bl3;
                boolean bl4 = false;
                file.putUserData(IS_PROBABLY_TEST_FILE_KEY, (Object)it);
                bl = bl3;
            } else {
                bl = null;
            }
        }
        return bl;
    }

    private static final PsiFile tryIsTestFile$lambda$0(Project $project, VirtualFile $file) {
        return PsiManager.getInstance((Project)$project).findFile($file);
    }

    static {
        Key key = Key.create((String)(JsTestFileInfo.class.getName() + " isProbablyTestFile"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_PROBABLY_TEST_FILE_KEY = key;
        IS_PROBABLY_TEST_FILE_ATTRIBUTE = new FileAttribute("javascript.file.is.probably.test", 1, true);
    }
}

