/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public final class SideEffectChecker
extends JSRecursiveWalkingElementVisitor {
    private boolean result;

    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull JSExpression exp) {
        if (exp == null) {
            SideEffectChecker.$$$reportNull$$$0(0);
        }
        SideEffectChecker visitor = new SideEffectChecker();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.result;
    }

    public void visitJSElement(@NotNull JSElement element2) {
        if (element2 == null) {
            SideEffectChecker.$$$reportNull$$$0(1);
        }
        if (!this.result) {
            super.visitJSElement(element2);
        }
    }

    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression expression) {
        if (expression == null) {
            SideEffectChecker.$$$reportNull$$$0(2);
        }
        this.setPositiveResult();
    }

    public void visitJSCallExpression(@NotNull JSCallExpression expression) {
        if (expression == null) {
            SideEffectChecker.$$$reportNull$$$0(3);
        }
        this.setPositiveResult();
    }

    public void visitJSNewExpression(@NotNull JSNewExpression expression) {
        if (expression == null) {
            SideEffectChecker.$$$reportNull$$$0(4);
        }
        this.setPositiveResult();
    }

    public void visitJSPostfixExpression(@NotNull JSPostfixExpression expression) {
        if (expression == null) {
            SideEffectChecker.$$$reportNull$$$0(5);
        }
        if (this.result || this.checkPrefixOrPostSign(expression.getOperationSign())) {
            return;
        }
        super.visitJSPostfixExpression(expression);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            SideEffectChecker.$$$reportNull$$$0(6);
        }
    }

    public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
        if (expression == null) {
            SideEffectChecker.$$$reportNull$$$0(7);
        }
        if (this.result) {
            return;
        }
        IElementType sign = expression.getOperationSign();
        if (this.checkPrefixOrPostSign(sign)) {
            return;
        }
        if (sign == JSTokenTypes.AWAIT_KEYWORD) {
            this.setPositiveResult();
            return;
        }
        super.visitJSPrefixExpression(expression);
    }

    private boolean checkPrefixOrPostSign(IElementType sign) {
        if (JSTokenTypes.PLUSPLUS.equals(sign) || JSTokenTypes.MINUSMINUS.equals(sign)) {
            this.setPositiveResult();
            return true;
        }
        return false;
    }

    private void setPositiveResult() {
        this.result = true;
        this.stopWalking();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/SideEffectChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHaveSideEffects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSAssignmentExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSNewExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSPostfixExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSPrefixExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

