/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.protobuf.ide.highlighter.PbFullHighlightingLexer;
import com.intellij.protobuf.ide.highlighter.PbPartialHighlightingLexer;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PbSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"PROTO_IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"PROTO_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"PROTO_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"PROTO_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey ENUM_VALUE = TextAttributesKey.createTextAttributesKey((String)"PROTO_ENUM_VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.CONSTANT);
    public static final TextAttributesKey BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PROTO_BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
    public static final TextAttributesKey LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PROTO_LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"PROTO_OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"PROTO_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"PROTO_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"PROTO_SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"PROTO_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"PROTO_PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey BRACKETS = TextAttributesKey.createTextAttributesKey((String)"PROTO_BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROTO_VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROTO_INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    public static final TextAttributesKey BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"PROTO_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    private static final Map<IElementType, TextAttributesKey> attributesKeyMap = PbSyntaxHighlighter.buildAttributesMap();
    private final boolean highlightKeywords;

    private static Map<IElementType, TextAttributesKey> buildAttributesMap() {
        HashMap map = new HashMap();
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)IDENTIFIER, (IElementType[])new IElementType[]{ProtoTokenTypes.IDENTIFIER_LITERAL});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)NUMBER, (IElementType[])new IElementType[]{ProtoTokenTypes.INTEGER_LITERAL, ProtoTokenTypes.FLOAT_LITERAL});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)KEYWORD, (IElementType[])new IElementType[]{ProtoTokenTypes.BUILT_IN_TYPE, ProtoTokenTypes.DEFAULT, ProtoTokenTypes.EDITION, ProtoTokenTypes.ENUM, ProtoTokenTypes.EXPORT, ProtoTokenTypes.EXTEND, ProtoTokenTypes.EXTENSIONS, ProtoTokenTypes.FALSE, ProtoTokenTypes.GROUP, ProtoTokenTypes.IMPORT, ProtoTokenTypes.JSON_NAME, ProtoTokenTypes.LOCAL, ProtoTokenTypes.MAP, ProtoTokenTypes.MAX, ProtoTokenTypes.MESSAGE, ProtoTokenTypes.ONEOF, ProtoTokenTypes.OPTION, ProtoTokenTypes.OPTIONAL, ProtoTokenTypes.PACKAGE, ProtoTokenTypes.PUBLIC, ProtoTokenTypes.REPEATED, ProtoTokenTypes.REQUIRED, ProtoTokenTypes.RESERVED, ProtoTokenTypes.RETURNS, ProtoTokenTypes.RPC, ProtoTokenTypes.SERVICE, ProtoTokenTypes.STREAM, ProtoTokenTypes.SYNTAX, ProtoTokenTypes.TO, ProtoTokenTypes.TRUE, ProtoTokenTypes.WEAK});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)STRING, (IElementType[])new IElementType[]{ProtoTokenTypes.STRING_LITERAL});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)BLOCK_COMMENT, (IElementType[])new IElementType[]{ProtoTokenTypes.BLOCK_COMMENT});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)LINE_COMMENT, (IElementType[])new IElementType[]{ProtoTokenTypes.LINE_COMMENT});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)OPERATION_SIGN, (IElementType[])new IElementType[]{ProtoTokenTypes.ASSIGN, ProtoTokenTypes.COLON, ProtoTokenTypes.MINUS, ProtoTokenTypes.SLASH});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)BRACES, (IElementType[])new IElementType[]{ProtoTokenTypes.LBRACE, ProtoTokenTypes.RBRACE, ProtoTokenTypes.LT, ProtoTokenTypes.GT});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)BRACKETS, (IElementType[])new IElementType[]{ProtoTokenTypes.LBRACK, ProtoTokenTypes.RBRACK});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)PARENTHESES, (IElementType[])new IElementType[]{ProtoTokenTypes.LPAREN, ProtoTokenTypes.RPAREN});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)DOT, (IElementType[])new IElementType[]{ProtoTokenTypes.DOT});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)SEMICOLON, (IElementType[])new IElementType[]{ProtoTokenTypes.SEMI});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)COMMA, (IElementType[])new IElementType[]{ProtoTokenTypes.COMMA});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        PbSyntaxHighlighter.fillMap(map, (TextAttributesKey)BAD_CHARACTER, (IElementType[])new IElementType[]{TokenType.BAD_CHARACTER});
        return Collections.unmodifiableMap(map);
    }

    public PbSyntaxHighlighter() {
        this(false);
    }

    public PbSyntaxHighlighter(boolean highlightKeywords) {
        this.highlightKeywords = highlightKeywords;
    }

    public static TextAttributesKey getTokenKey(IElementType token) {
        return attributesKeyMap.get(token);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        if (this.highlightKeywords) {
            return new PbFullHighlightingLexer();
        }
        return new PbPartialHighlightingLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = PbSyntaxHighlighter.pack((TextAttributesKey)attributesKeyMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            PbSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/ide/highlighter/PbSyntaxHighlighter", "getTokenHighlights"));
    }
}

