/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.protobuf.lang.psi.PbTextElementType;
import com.intellij.protobuf.lang.psi.impl.PbTextDomainImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextExtensionNameImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextFieldImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextFieldNameImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextIdentifierValueImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextMessageValueImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextNumberValueImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextStringPartImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextStringValueImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextSymbolPathImpl;
import com.intellij.protobuf.lang.psi.impl.PbTextValueListImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface PbTextTypes {
    public static final IElementType DOMAIN = new PbTextElementType("DOMAIN");
    public static final IElementType EXTENSION_NAME = new PbTextElementType("EXTENSION_NAME");
    public static final IElementType FIELD = new PbTextElementType("FIELD");
    public static final IElementType FIELD_NAME = new PbTextElementType("FIELD_NAME");
    public static final IElementType IDENTIFIER_VALUE = new PbTextElementType("IDENTIFIER_VALUE");
    public static final IElementType MESSAGE_VALUE = new PbTextElementType("MESSAGE_VALUE");
    public static final IElementType NUMBER_VALUE = new PbTextElementType("NUMBER_VALUE");
    public static final IElementType STRING_PART = new PbTextElementType("STRING_PART");
    public static final IElementType STRING_VALUE = new PbTextElementType("STRING_VALUE");
    public static final IElementType SYMBOL_PATH = new PbTextElementType("SYMBOL_PATH");
    public static final IElementType VALUE_LIST = new PbTextElementType("VALUE_LIST");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == DOMAIN) {
                return new PbTextDomainImpl(node);
            }
            if (type == EXTENSION_NAME) {
                return new PbTextExtensionNameImpl(node);
            }
            if (type == FIELD) {
                return new PbTextFieldImpl(node);
            }
            if (type == FIELD_NAME) {
                return new PbTextFieldNameImpl(node);
            }
            if (type == IDENTIFIER_VALUE) {
                return new PbTextIdentifierValueImpl(node);
            }
            if (type == MESSAGE_VALUE) {
                return new PbTextMessageValueImpl(node);
            }
            if (type == NUMBER_VALUE) {
                return new PbTextNumberValueImpl(node);
            }
            if (type == STRING_PART) {
                return new PbTextStringPartImpl(node);
            }
            if (type == STRING_VALUE) {
                return new PbTextStringValueImpl(node);
            }
            if (type == SYMBOL_PATH) {
                return new PbTextSymbolPathImpl(node);
            }
            if (type == VALUE_LIST) {
                return new PbTextValueListImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

