/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.protobuf.ide.util.PbIcons;
import com.intellij.protobuf.lang.descriptor.Descriptor;
import com.intellij.protobuf.lang.descriptor.DescriptorOptionType;
import com.intellij.protobuf.lang.psi.PbExtendDefinition;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionList;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.impl.PbNamedElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PbFieldBase
extends PbNamedElementBase
implements PbField {
    PbFieldBase(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement id = this.getNameIdentifier();
        if (id != null) {
            return id.getText();
        }
        return null;
    }

    @Override
    @NotNull
    public List<PbOptionExpression> getOptions() {
        PbOptionList optionList = this.getOptionList();
        if (optionList == null) {
            List<PbOptionExpression> list = Collections.emptyList();
            if (list == null) {
                PbFieldBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<PbOptionExpression> list = optionList.getOptions();
        if (list == null) {
            PbFieldBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public PbTypeName getExtendee() {
        PsiElement extendBody = this.getParent();
        if (extendBody == null) {
            return null;
        }
        PsiElement extendDefinition = extendBody.getParent();
        if (!(extendDefinition instanceof PbExtendDefinition)) {
            return null;
        }
        return ((PbExtendDefinition)extendDefinition).getTypeName();
    }

    @Override
    @Nullable
    public PbOneofDefinition getOneof() {
        PsiElement oneofBody = this.getParent();
        if (oneofBody == null) {
            return null;
        }
        PsiElement oneofDefinition = oneofBody.getParent();
        if (!(oneofDefinition instanceof PbOneofDefinition)) {
            return null;
        }
        return (PbOneofDefinition)oneofDefinition;
    }

    @Override
    @NotNull
    public QualifiedName getDescriptorOptionsTypeName(Descriptor descriptor) {
        QualifiedName qualifiedName = DescriptorOptionType.FIELD_OPTIONS.forDescriptor(descriptor);
        if (qualifiedName == null) {
            PbFieldBase.$$$reportNull$$$0(2);
        }
        return qualifiedName;
    }

    @Override
    @Nullable
    public QualifiedName getExtensionOptionScope() {
        QualifiedName name = this.getQualifiedName();
        return name != null ? name.removeLastComponent() : null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return PbIcons.FIELD;
    }

    @Override
    public PbField.CanonicalFieldLabel getCanonicalLabel() {
        PbFieldLabel declaredLabel = this.getDeclaredLabel();
        if (declaredLabel != null && "repeated".equals(declaredLabel.getText())) {
            return PbField.CanonicalFieldLabel.REPEATED;
        }
        if (declaredLabel != null && "required".equals(declaredLabel.getText())) {
            return PbField.CanonicalFieldLabel.REQUIRED;
        }
        return PbField.CanonicalFieldLabel.OPTIONAL;
    }

    @Nullable
    abstract PbOptionList getOptionList();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/lang/psi/impl/PbFieldBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorOptionsTypeName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

