/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.util;

import com.google.common.base.Ascii;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.ProtoBooleanValue;
import com.intellij.protobuf.lang.psi.ProtoIdentifierValue;
import com.intellij.protobuf.lang.psi.ProtoNumberValue;
import com.intellij.protobuf.lang.psi.ProtoStringValue;
import com.intellij.protobuf.lang.util.ValueTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BuiltInType {
    STRING(new StringTester()),
    BYTES(new StringTester()),
    BOOL(new BooleanTester()),
    DOUBLE(new FloatTester()),
    FLOAT(new FloatTester()),
    UINT32(new IntegerTester(ProtoNumberValue::isValidUint32, true)),
    UINT64(new IntegerTester(ProtoNumberValue::isValidUint64, true)),
    FIXED32(new IntegerTester(ProtoNumberValue::isValidUint32, true)),
    FIXED64(new IntegerTester(ProtoNumberValue::isValidUint64, true)),
    INT32(new IntegerTester(ProtoNumberValue::isValidInt32, false)),
    INT64(new IntegerTester(ProtoNumberValue::isValidInt64, false)),
    SINT32(new IntegerTester(ProtoNumberValue::isValidInt32, false)),
    SINT64(new IntegerTester(ProtoNumberValue::isValidInt64, false)),
    SFIXED32(new IntegerTester(ProtoNumberValue::isValidInt32, false)),
    SFIXED64(new IntegerTester(ProtoNumberValue::isValidInt64, false));

    private static final Map<String, BuiltInType> TYPES_BY_NAME;
    private final ValueTesterFactory factory;

    private BuiltInType(ValueTesterFactory factory) {
        this.factory = factory;
    }

    public static boolean isBuiltInType(String name) {
        return BuiltInType.getType(name) != null;
    }

    public static Collection<BuiltInType> getTypes() {
        return Arrays.asList(BuiltInType.values());
    }

    @Nullable
    public static BuiltInType getType(String name) {
        if (name == null) {
            return null;
        }
        return TYPES_BY_NAME.get(name);
    }

    @NotNull
    public String getName() {
        String string = Ascii.toLowerCase((String)this.name());
        if (string == null) {
            BuiltInType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public ValueTester getValueTester(ValueTester.ValueTesterType type) {
        ValueTester valueTester = this.factory.getValueTester(type);
        if (valueTester == null) {
            BuiltInType.$$$reportNull$$$0(1);
        }
        return valueTester;
    }

    static {
        TYPES_BY_NAME = Collections.unmodifiableMap(Stream.of(BuiltInType.values()).collect(Collectors.toMap(BuiltInType::getName, Function.identity())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/lang/util/BuiltInType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTester";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static interface ValueTesterFactory {
        public ValueTester getValueTester(ValueTester.ValueTesterType var1);
    }

    private static class StringTester
    implements ValueTesterFactory {
        private StringTester() {
        }

        @Override
        @Nls
        @NotNull
        public ValueTester getValueTester(ValueTester.ValueTesterType type) {
            ValueTester valueTester = value -> {
                if (!(value instanceof ProtoStringValue)) {
                    return PbLangBundle.message("string.value.expected", new Object[0]);
                }
                return null;
            };
            if (valueTester == null) {
                StringTester.$$$reportNull$$$0(0);
            }
            return valueTester;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/util/BuiltInType$StringTester", "getValueTester"));
        }
    }

    private static class BooleanTester
    implements ValueTesterFactory {
        private BooleanTester() {
        }

        @Override
        @Nls
        @NotNull
        public ValueTester getValueTester(ValueTester.ValueTesterType type) {
            ValueTester valueTester = value -> {
                if (!(value instanceof ProtoBooleanValue)) {
                    return PbLangBundle.message("boolean.value.expected", new Object[0]);
                }
                Boolean booleanValue = ((ProtoBooleanValue)((Object)value)).getBooleanValue();
                if (booleanValue == null) {
                    return PbLangBundle.message("boolean.value.expected", new Object[0]);
                }
                return null;
            };
            if (valueTester == null) {
                BooleanTester.$$$reportNull$$$0(0);
            }
            return valueTester;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/util/BuiltInType$BooleanTester", "getValueTester"));
        }
    }

    private static class FloatTester
    implements ValueTesterFactory {
        private FloatTester() {
        }

        @Override
        @Nls
        @NotNull
        public ValueTester getValueTester(ValueTester.ValueTesterType type) {
            ValueTester valueTester = value -> {
                if (value instanceof ProtoIdentifierValue) {
                    ProtoIdentifierValue identifierValue = (ProtoIdentifierValue)((Object)value);
                    value = identifierValue.getAsNumber();
                }
                if (!(value instanceof ProtoNumberValue)) {
                    return PbLangBundle.message("floating.point.value.expected", new Object[0]);
                }
                ProtoNumberValue number = (ProtoNumberValue)value;
                ProtoNumberValue.SourceType sourceType = number.getSourceType();
                if (sourceType == null) {
                    return PbLangBundle.message("floating.point.value.expected", new Object[0]);
                }
                return switch (number.getSourceType()) {
                    default -> throw new MatchException(null, null);
                    case ProtoNumberValue.SourceType.INTEGER -> {
                        if (type == ValueTester.ValueTesterType.TEXT && number.getIntegerFormat() != ProtoNumberValue.IntegerFormat.DEC) {
                            yield PbLangBundle.message("integer.value.must.be.decimal", new Object[0]);
                        }
                        boolean valid = number.isNegative() ? (type == ValueTester.ValueTesterType.DEFAULT ? number.isValidInt65() : number.isValidInt64()) : number.isValidUint64();
                        if (valid) {
                            yield null;
                        }
                        yield PbLangBundle.message("integer.value.out.of.range", new Object[0]);
                    }
                    case ProtoNumberValue.SourceType.FLOAT -> {
                        if (number.isValidDouble()) {
                            yield null;
                        }
                        yield PbLangBundle.message("invalid.floating.point.value", new Object[0]);
                    }
                    case ProtoNumberValue.SourceType.INF -> {
                        if (type == ValueTester.ValueTesterType.OPTION) {
                            yield PbLangBundle.message("not.allowed.as.option.value", "inf");
                        }
                        yield null;
                    }
                    case ProtoNumberValue.SourceType.NAN -> type == ValueTester.ValueTesterType.OPTION ? PbLangBundle.message("not.allowed.as.option.value", "nan") : null;
                };
            };
            if (valueTester == null) {
                FloatTester.$$$reportNull$$$0(0);
            }
            return valueTester;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/util/BuiltInType$FloatTester", "getValueTester"));
        }
    }

    private static class IntegerTester
    implements ValueTesterFactory {
        private final boolean unsigned;
        private final Predicate<ProtoNumberValue> validityCheck;

        private IntegerTester(Predicate<ProtoNumberValue> validityCheck, boolean unsigned) {
            this.validityCheck = validityCheck;
            this.unsigned = unsigned;
        }

        @Override
        @Nls
        @NotNull
        public ValueTester getValueTester(ValueTester.ValueTesterType type) {
            ValueTester valueTester = value -> {
                if (!(value instanceof ProtoNumberValue)) {
                    return PbLangBundle.message("integer.value.expected", new Object[0]);
                }
                ProtoNumberValue number = (ProtoNumberValue)value;
                if (number.getSourceType() != ProtoNumberValue.SourceType.INTEGER) {
                    return PbLangBundle.message("integer.value.expected", new Object[0]);
                }
                if (this.unsigned && number.isNegative()) {
                    return PbLangBundle.message("unsigned.value.cannot.be.negative", new Object[0]);
                }
                if (!this.validityCheck.test(number)) {
                    return PbLangBundle.message("integer.value.out.of.range", new Object[0]);
                }
                return null;
            };
            if (valueTester == null) {
                IntegerTester.$$$reportNull$$$0(0);
            }
            return valueTester;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/lang/util/BuiltInType$IntegerTester", "getValueTester"));
        }
    }
}

