/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.lang.javascript.linter.JSDumbAwareLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.stylelint.StylelintBundle;
import com.intellij.stylelint.StylelintConfigurable;
import com.intellij.stylelint.StylelintConfiguration;
import com.intellij.stylelint.StylelintExternalRunner;
import com.intellij.stylelint.StylelintFixAction;
import com.intellij.stylelint.StylelintInspection;
import com.intellij.stylelint.StylelintState;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintExternalAnnotator
extends JSDumbAwareLinterExternalAnnotator<StylelintState> {
    public static final StylelintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new StylelintExternalAnnotator(false);

    public StylelintExternalAnnotator() {
        super(true);
    }

    public StylelintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @NotNull
    protected String getSettingsConfigurableID() {
        return "configurable.stylesheets.stylelint";
    }

    protected Class<? extends JSLinterConfiguration<StylelintState>> getConfigurationClass() {
        return StylelintConfiguration.class;
    }

    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return StylelintInspection.class;
    }

    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            StylelintExternalAnnotator.$$$reportNull$$$0(0);
        }
        VirtualFile vFile = file.getVirtualFile();
        String pattern = ((StylelintState)StylelintConfiguration.getInstance(file.getProject()).getExtendedState().getState()).getFilesPattern();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)file.getProject());
        return vFile != null && fileIndex.isInContent(vFile) && GlobPatternUtil.isFileMatchingGlobPattern((Project)file.getProject(), (String)pattern, (VirtualFile)vFile);
    }

    @Nullable
    public JSLinterAnnotationResult annotate(@NotNull JSLinterInput<StylelintState> input) {
        if (input == null) {
            StylelintExternalAnnotator.$$$reportNull$$$0(1);
        }
        return new StylelintExternalRunner(this.isOnTheFly(), false).execute(input);
    }

    public void apply(@NotNull PsiFile psiFile, @Nullable JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (psiFile == null) {
            StylelintExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            StylelintExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (annotationResult == null) {
            return;
        }
        String prefix = StylelintBundle.message("stylelint.error.prefix", new Object[0]) + " ";
        StylelintConfigurable configurable = new StylelintConfigurable(psiFile.getProject(), true);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setOtherFixes(Collections.singletonList(new StylelintFixAction().asIntentionAction())).setEditSettingsAction((IntentionAction)new JSLinterEditSettingsAction((UntypedJSLinterConfigurable)configurable, JavaScriptLanguageIcons.FileTypes.Stylelint)).setShowEditSettings(false).setEditConfig(false);
        new JSLinterAnnotationsBuilder(psiFile, annotationResult, holder, (UntypedJSLinterConfigurable)configurable, prefix, this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).setDefaultFileLevelErrorIcon(JavaScriptLanguageIcons.FileTypes.Stylelint).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/stylelint/StylelintExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptPsiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

