/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ultimate.FlameChartColorTypeGroup;
import com.intellij.profiler.ultimate.JavaFlameChartColorScheme;
import com.intellij.profiler.ultimate.NewUiDarkPalette;
import com.intellij.profiler.ultimate.NewUiLightPalette;
import com.intellij.profiler.ultimate.OldUiDarkPalette;
import com.intellij.profiler.ultimate.OldUiLightPalette;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0004\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/JavaFlameChartPalette;", "", "<init>", "()V", "getColor", "Ljava/awt/Color;", "type", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "scheme", "Lcom/intellij/profiler/ultimate/JavaFlameChartColorScheme;", "getProjectColor", "group", "Lcom/intellij/profiler/ultimate/FlameChartColorTypeGroup;", "getLibraryColor", "getNativeColor", "getRootColor", "Lcom/intellij/profiler/ultimate/NewUiDarkPalette;", "Lcom/intellij/profiler/ultimate/NewUiLightPalette;", "Lcom/intellij/profiler/ultimate/OldUiDarkPalette;", "Lcom/intellij/profiler/ultimate/OldUiLightPalette;", "intellij.profiler.ultimate"})
public abstract sealed class JavaFlameChartPalette
permits NewUiDarkPalette, NewUiLightPalette, OldUiDarkPalette, OldUiLightPalette {
    private JavaFlameChartPalette() {
    }

    @NotNull
    public final Color getColor(@NotNull ColorType type, @NotNull JavaFlameChartColorScheme scheme) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)scheme), (String)"scheme");
        FlameChartColorTypeGroup group = FlameChartColorTypeGroup.Companion.of(type);
        JavaFlameChartColorScheme javaFlameChartColorScheme = scheme;
        if (Intrinsics.areEqual((Object)((Object)javaFlameChartColorScheme), (Object)((Object)JavaFlameChartColorScheme.PROJECT.INSTANCE))) {
            color = this.getProjectColor(group, type);
        } else if (Intrinsics.areEqual((Object)((Object)javaFlameChartColorScheme), (Object)((Object)JavaFlameChartColorScheme.LIBRARY.INSTANCE))) {
            color = this.getLibraryColor(group, type);
        } else if (Intrinsics.areEqual((Object)((Object)javaFlameChartColorScheme), (Object)((Object)JavaFlameChartColorScheme.NATIVE.INSTANCE))) {
            color = this.getNativeColor(group, type);
        } else if (Intrinsics.areEqual((Object)((Object)javaFlameChartColorScheme), (Object)((Object)JavaFlameChartColorScheme.ROOT.INSTANCE))) {
            color = this.getRootColor(group, type);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return color;
    }

    @NotNull
    public abstract Color getProjectColor(@NotNull FlameChartColorTypeGroup var1, @NotNull ColorType var2);

    @NotNull
    public abstract Color getLibraryColor(@NotNull FlameChartColorTypeGroup var1, @NotNull ColorType var2);

    @NotNull
    public abstract Color getNativeColor(@NotNull FlameChartColorTypeGroup var1, @NotNull ColorType var2);

    @NotNull
    public abstract Color getRootColor(@NotNull FlameChartColorTypeGroup var1, @NotNull ColorType var2);

    public /* synthetic */ JavaFlameChartPalette(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

