/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;

public class DisjointBuilder<T> {
    private static final IMemberAccessor<IQuantity, DisjointArray<?>> DA_START = new IMemberAccessor<IQuantity, DisjointArray<?>>(){

        @Override
        public IQuantity getMember(DisjointArray<?> inObject) {
            return inObject.start;
        }
    };
    private static final IMemberAccessor<IQuantity, DisjointArray<?>> DA_END = new IMemberAccessor<IQuantity, DisjointArray<?>>(){

        @Override
        public IQuantity getMember(DisjointArray<?> inObject) {
            return inObject.end;
        }
    };
    private int noLanes = 0;
    private DisjointArray<T>[] lanes = new DisjointArray[1];
    private final IMemberAccessor<IQuantity, ? super T> startAccessor;
    private final IMemberAccessor<IQuantity, ? super T> endAccessor;

    public DisjointBuilder(IMemberAccessor<IQuantity, ? super T> startAccessor, IMemberAccessor<IQuantity, ? super T> endAccessor) {
        this.startAccessor = startAccessor;
        this.endAccessor = endAccessor;
    }

    public void add(T e) {
        IQuantity start2 = this.startAccessor.getMember(e);
        IQuantity end = this.endAccessor.getMember(e).in(start2.getUnit());
        if (this.noLanes == 0) {
            this.addToNewLane(e, start2, end);
        } else if (!this.lanes[0].accept(e, start2, end)) {
            int changedLane = this.addToOtherLane(e, start2, end);
            this.sortLanes(changedLane);
        }
    }

    private void sortLanes(int fromIndex) {
        for (int i = fromIndex; i > 0; --i) {
            if (this.lanes[i].end.compareTo(this.lanes[i - 1].end) <= 0) continue;
            DisjointArray<T> tmp = this.lanes[i - 1];
            this.lanes[i - 1] = this.lanes[i];
            this.lanes[i] = tmp;
        }
    }

    private int addToOtherLane(T e, IQuantity start2, IQuantity end) {
        for (int i = 1; i < this.noLanes; ++i) {
            if (!this.lanes[i].accept(e, start2, end)) continue;
            return i;
        }
        return this.addToNewLane(e, start2, end);
    }

    private int addToNewLane(T e, IQuantity start2, IQuantity end) {
        if (this.noLanes >= this.lanes.length) {
            this.lanes = Arrays.copyOf(this.lanes, this.lanes.length * 3 / 2 + 2);
        }
        this.lanes[this.noLanes] = new DisjointArray<T>(e, start2, end);
        return this.noLanes++;
    }

    /*
     * WARNING - void declaration
     */
    public static <U> Collection<U[]> toArrays(Iterable<? extends DisjointBuilder<U>> collections, ArrayFactory<U> arrayFactory) {
        void var5_11;
        ArrayList allLanes = new ArrayList();
        for (DisjointBuilder<U> disjointBuilder : collections) {
            for (int i = 0; i < disjointBuilder.noLanes; ++i) {
                allLanes.add(disjointBuilder.lanes[i]);
            }
        }
        if (allLanes.size() == 0) {
            return Collections.emptyList();
        }
        Collections.sort(allLanes, new Comparator<DisjointArray<?>>(){

            @Override
            public int compare(DisjointArray<?> o1, DisjointArray<?> o2) {
                return o1.end.compareTo(o2.end);
            }
        });
        DisjointBuilder lanesCombiner = new DisjointBuilder(DA_START, DA_END);
        for (DisjointArray disjointArray : allLanes) {
            lanesCombiner.add(disjointArray);
        }
        ArrayList<U[]> arrayList = new ArrayList<U[]>(lanesCombiner.noLanes);
        boolean bl = false;
        while (var5_11 < lanesCombiner.noLanes) {
            DisjointArray laneOfLanes = lanesCombiner.lanes[var5_11];
            int totalSize = 0;
            for (int j = 0; j < laneOfLanes.size; ++j) {
                DisjointArray lane = (DisjointArray)laneOfLanes.getElement(j);
                totalSize += lane.size;
            }
            U[] resultArray = arrayFactory.createArray(totalSize);
            int offset = 0;
            for (int j = 0; j < laneOfLanes.size; ++j) {
                DisjointArray lane = (DisjointArray)laneOfLanes.getElement(j);
                System.arraycopy(lane.array, 0, resultArray, offset, lane.size);
                offset += lane.size;
            }
            arrayList.add(resultArray);
            ++var5_11;
        }
        return arrayList;
    }

    private static class DisjointArray<T> {
        private Object[] array = new Object[3];
        final IQuantity start;
        IQuantity end;
        int size = 0;

        DisjointArray(T e, IQuantity start2, IQuantity end) {
            this.start = start2;
            this.end = end;
            this.array[this.size++] = e;
        }

        boolean accept(T e, IQuantity start2, IQuantity end) {
            if (this.size >= this.array.length) {
                int newCapacity = this.array.length < 100 ? this.array.length * 4 : this.array.length * 3 / 2 + 1;
                this.array = Arrays.copyOf(this.array, newCapacity);
            }
            if (start2.compareTo(this.end) >= 0) {
                this.array[this.size++] = e;
                this.end = end;
                return true;
            }
            return false;
        }

        private T getElement(int index) {
            Object t = this.array[index];
            return (T)t;
        }
    }

    public static interface ArrayFactory<U> {
        public U[] createArray(int var1);
    }
}

