/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jdbc.orm;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.orm.ep.AbstractOrmSearcher;
import com.intellij.jpa.jpb.model.orm.ep.OrmMappingProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.data.jdbc.SpringDataJdbcUtilsKt;
import com.intellij.spring.data.jdbc.jam.SpringDataJdbcTable;
import com.intellij.spring.data.jdbc.orm.AbstractSpringDataJdbcOrmProvider;
import com.intellij.spring.data.jdbc.orm.model.SpringDataJdbcOrmEntity;
import com.intellij.spring.data.jdbc.orm.model.SpringDataJdbcOrmUnit;
import com.intellij.spring.data.utils.SpringDataOrmUtil;
import com.intellij.util.Query;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\nH\u0016J$\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/spring/data/jdbc/orm/SpringDataJdbcOrmSearcher;", "Lcom/intellij/jpa/jpb/model/orm/ep/AbstractOrmSearcher;", "Lcom/intellij/spring/data/jdbc/orm/AbstractSpringDataJdbcOrmProvider;", "<init>", "()V", "isEntity", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "findEntityForClass", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "findOrCreateEmbeddedEntity", "findEmbeddedEntityOwner", "", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntityAttribute;", "ormEntity", "findEntityForFqn", "fqn", "Lcom/intellij/jpa/jpb/model/core/util/Fqn;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "findEntityByTableName", "tableName", "", "hasAnyEntity", "findEntityClasses", "Lkotlin/sequences/Sequence;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findAssociatedDataSourceId", "ormUnit", "Lcom/intellij/jpa/jpb/model/orm/model/OrmUnit;", "isExplicitEntity", "getCachedEntity", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataJdbcOrmSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataJdbcOrmSearcher.kt\ncom/intellij/spring/data/jdbc/orm/SpringDataJdbcOrmSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class SpringDataJdbcOrmSearcher
extends AbstractOrmSearcher
implements AbstractSpringDataJdbcOrmProvider {
    public boolean isEntity(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return this.isExplicitEntity(psiClass) || this.isInSettings(psiClass);
    }

    @Nullable
    public OrmEntity findEntityForClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (this.isInSettings(psiClass)) {
            return new SpringDataJdbcOrmEntity(psiClass);
        }
        if (!this.isExplicitEntity(psiClass)) {
            return null;
        }
        return this.getCachedEntity(psiClass);
    }

    @Nullable
    public OrmEntity findOrCreateEmbeddedEntity(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return this.getCachedEntity(psiClass);
    }

    @NotNull
    public Map<OrmEntity, OrmEntityAttribute> findEmbeddedEntityOwner(@NotNull OrmEntity ormEntity) {
        SmartPsiElementPointer smartPsiElementPointer;
        Map result;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
                result = new LinkedHashMap();
                smartPsiElementPointer = ormEntity.getClassPsiPointer();
                if (smartPsiElementPointer == null || (smartPsiElementPointer = (PsiClass)smartPsiElementPointer.getElement()) == null) break block7;
                SmartPsiElementPointer it = smartPsiElementPointer;
                boolean bl = false;
                Fqn fqn = Fqn.Companion.ofClass((PsiClass)it);
                smartPsiElementPointer = fqn;
                if (fqn != null) break block8;
            }
            return MapsKt.emptyMap();
        }
        SmartPsiElementPointer entityFqn = smartPsiElementPointer;
        SmartPsiElementPointer smartPsiElementPointer2 = ormEntity.getClassPsiPointer();
        if (smartPsiElementPointer2 == null || (smartPsiElementPointer2 = smartPsiElementPointer2.getProject()) == null) {
            return MapsKt.emptyMap();
        }
        SmartPsiElementPointer project = smartPsiElementPointer2;
        for (OrmUnit unit : OrmUnitsProvider.Companion.getForFramework(this.getFramework()).getUnits((Project)project)) {
            for (OrmEntity entity : unit.getEntities()) {
                for (OrmEntityAttribute attribute : entity.getAttributes()) {
                    if (!attribute.isEmbedded() || !Intrinsics.areEqual((Object)attribute.getTypeFqn(), (Object)entityFqn)) continue;
                    result.put(entity, attribute);
                }
            }
        }
        return result;
    }

    @Nullable
    public OrmEntity findEntityForFqn(@NotNull Fqn fqn, @NotNull Project project, @Nullable Module module) {
        Module module2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                module2 = module;
                if (module2 == null) break block4;
                Module it = module2;
                boolean bl = false;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)it);
                module2 = globalSearchScope;
                if (globalSearchScope != null) break block5;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            module2 = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        }
        Module scope = module2;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn.getExternalFullName(), (GlobalSearchScope)scope);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        return this.findEntityForClass(psiClass2);
    }

    @Nullable
    public OrmEntity findEntityByTableName(@NotNull Project project, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        OrmMappingProvider ormMappingProvider = OrmMappingProvider.Companion.getForFramework(this.getFramework());
        for (OrmUnit unit : OrmUnitsProvider.Companion.getForFramework(this.getFramework()).getUnits(project)) {
            for (OrmEntity entity : unit.getEntities()) {
                if (!StringsKt.equals((String)tableName, (String)ormMappingProvider.getTableName(entity), (boolean)true)) continue;
                return entity;
            }
        }
        return null;
    }

    public boolean hasAnyEntity(@NotNull Project project, @Nullable Module module) {
        Module module2;
        PsiClass tableClass;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.data.relational.core.mapping.Table", GlobalSearchScope.allScope((Project)project));
                if (psiClass == null) {
                    return false;
                }
                tableClass = psiClass;
                module2 = module;
                if (module2 == null) break block5;
                Module it = module2;
                boolean bl = false;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)it);
                module2 = globalSearchScope;
                if (globalSearchScope != null) break block6;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            module2 = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        }
        Module scope = module2;
        Query query = AnnotatedElementsSearch.searchPsiClasses((PsiClass)tableClass, (SearchScope)((SearchScope)scope));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"searchPsiClasses(...)");
        if (CollectionsKt.any((Iterable)((Iterable)query))) {
            return true;
        }
        return super.hasAnyEntity(project, module);
    }

    @NotNull
    public Sequence<PsiClass> findEntityClasses(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        List list = JamService.getJamService((Project)project).getJamClassElements((JamMemberMeta)SpringDataJdbcTable.Companion.getMETA(), "org.springframework.data.relational.core.mapping.Table", scope);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJamClassElements(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), SpringDataJdbcOrmSearcher::findEntityClasses$lambda$0);
    }

    @Nullable
    public String findAssociatedDataSourceId(@NotNull OrmUnit ormUnit) {
        Intrinsics.checkNotNullParameter((Object)ormUnit, (String)"ormUnit");
        return SpringDataOrmUtil.INSTANCE.getAssociatedDataSourceIds(ormUnit);
    }

    @Nullable
    public String findAssociatedDataSourceId(@NotNull OrmEntity ormEntity) {
        Intrinsics.checkNotNullParameter((Object)ormEntity, (String)"ormEntity");
        SmartPsiElementPointer smartPsiElementPointer = ormEntity.getClassPsiPointer();
        if (smartPsiElementPointer == null || (smartPsiElementPointer = (PsiClass)smartPsiElementPointer.getElement()) == null || (smartPsiElementPointer = PsiUtilsKt.module((PsiElement)((PsiElement)smartPsiElementPointer))) == null) {
            return super.findAssociatedDataSourceId(ormEntity);
        }
        SmartPsiElementPointer module = smartPsiElementPointer;
        return this.findAssociatedDataSourceId((OrmUnit)new SpringDataJdbcOrmUnit((Module)module));
    }

    private final boolean isExplicitEntity(PsiClass psiClass) {
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (SpringDataJdbcTable.Companion.getMETA().getJamElement((PsiModifierListOwner)psiClass) != null) {
            return true;
        }
        OrmSearcher ormSearcher = OrmSearcher.Companion.findForFramework((OrmFramework)JpaOrmFramework.INSTANCE);
        boolean bl = ormSearcher != null ? ormSearcher.isEntity(psiClass) : false;
        if (bl) {
            return false;
        }
        return CollectionsKt.contains((Iterable)SpringDataJdbcUtilsKt.getSpringDataJbcRepositoriesDomainClassFqns(project2), (Object)psiClass.getQualifiedName());
    }

    private final OrmEntity getCachedEntity(PsiClass psiClass) {
        return (OrmEntity)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiClass), () -> SpringDataJdbcOrmSearcher.getCachedEntity$lambda$0(psiClass));
    }

    private static final PsiClass findEntityClasses$lambda$0(SpringDataJdbcTable it) {
        return (PsiClass)it.getPsiElement();
    }

    private static final CachedValueProvider.Result getCachedEntity$lambda$0(PsiClass $psiClass) {
        Object[] objectArray = new Object[]{$psiClass};
        return CachedValueProvider.Result.create((Object)new SpringDataJdbcOrmEntity($psiClass), (Object[])objectArray);
    }
}

