/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.beans;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.documentation.ide.DocumentationUtil;
import com.intellij.lang.documentation.ide.ui.DocumentationComponent;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.jvm.MicroservicesJvmBundle;
import com.intellij.microservices.jvm.beans.BeanStereotype;
import com.intellij.microservices.jvm.beans.BeansCursor;
import com.intellij.microservices.jvm.beans.BeansList;
import com.intellij.microservices.jvm.beans.BeansListItem;
import com.intellij.microservices.jvm.beans.BeansListModelsKt;
import com.intellij.microservices.jvm.beans.BeansListRenderer;
import com.intellij.microservices.jvm.beans.BeansProvider;
import com.intellij.microservices.jvm.beans.BeansSearchPopupController;
import com.intellij.microservices.jvm.beans.BeansSearchQueryParser;
import com.intellij.microservices.jvm.beans.BeansSidePanel;
import com.intellij.microservices.jvm.beans.BeansSidePanelProvider;
import com.intellij.microservices.jvm.beans.BeansView;
import com.intellij.microservices.jvm.beans.BeansViewListener;
import com.intellij.microservices.jvm.beans.BeansViewManagerKt;
import com.intellij.microservices.jvm.beans.BeansViewService;
import com.intellij.microservices.jvm.beans.BeansViewSettings;
import com.intellij.microservices.jvm.beans.FlatBeanItem;
import com.intellij.microservices.jvm.beans.LoadContext;
import com.intellij.microservices.jvm.beans.ModuleItem;
import com.intellij.microservices.jvm.beans.actions.BeansFrameworkFilterFieldAction;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.filterField.FilterApplier;
import com.intellij.ui.filterField.FilterField;
import com.intellij.ui.filterField.FilterFieldAction;
import com.intellij.ui.filterField.FilterItem;
import com.intellij.ui.filterField.FilterSearchTextField;
import com.intellij.ui.filterField.FilterSideTabs;
import com.intellij.ui.filterField.FiltersKt;
import com.intellij.ui.filterField.SearchQueryParserBase;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0000\u0018\u0000 u2\u00020\u00012\u00020\u0002:\u0001uB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u000208H\u0002J\b\u0010:\u001a\u000208H\u0002J\b\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020<H\u0002J\b\u0010>\u001a\u00020<H\u0002J\b\u0010?\u001a\u000208H\u0002J\b\u0010@\u001a\u000208H\u0002J\u0006\u0010A\u001a\u000208J\u0006\u0010B\u001a\u000208J\u0010\u0010C\u001a\u0002082\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010D\u001a\u000208H\u0002J\b\u0010E\u001a\u000208H\u0002J\b\u0010F\u001a\u000208H\u0002J\b\u0010G\u001a\u000208H\u0002J\b\u0010H\u001a\u000208H\u0002J\u000e\u0010I\u001a\u000208H\u0082@\u00a2\u0006\u0002\u0010JJ\b\u0010K\u001a\u000208H\u0002J\u0012\u0010L\u001a\u0002082\b\b\u0002\u0010M\u001a\u00020\u0017H\u0002J\b\u0010N\u001a\u000208H\u0002J\b\u0010O\u001a\u000208H\u0016J&\u0010P\u001a\u0002082\u0006\u0010Q\u001a\u0002012\u0014\u0010R\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030S0,H\u0003J\u0012\u0010T\u001a\u0002082\b\b\u0002\u0010M\u001a\u00020\u0017H\u0002J\u0018\u0010U\u001a\u0002082\u0006\u0010Q\u001a\u0002012\u0006\u0010M\u001a\u00020\u0017H\u0002J\b\u0010V\u001a\u00020WH\u0002J\u0010\u0010X\u001a\u0002082\u0006\u0010Y\u001a\u00020ZH\u0003J\u001a\u0010[\u001a\u0002082\u0006\u0010\\\u001a\u00020]2\b\u0010^\u001a\u0004\u0018\u00010-H\u0002J\u0010\u0010_\u001a\u00020]2\u0006\u0010\\\u001a\u00020]H\u0002J\b\u0010`\u001a\u00020\u0017H\u0002J\u0014\u0010a\u001a\u0002082\n\u0010b\u001a\u0006\u0012\u0002\b\u00030cH\u0002J\u0010\u0010d\u001a\u0002082\u0006\u0010e\u001a\u00020fH\u0016J\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00110,H\u0002J\u0012\u0010h\u001a\u0004\u0018\u00010\u00112\u0006\u0010i\u001a\u00020\u0011H\u0002J\b\u0010j\u001a\u000208H\u0002J\u001e\u0010k\u001a\u0002082\u0006\u0010l\u001a\u00020m2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020m0oH\u0002J$\u0010p\u001a\u0002082\b\u0010q\u001a\u0004\u0018\u00010m2\b\u0010r\u001a\u0004\u0018\u00010m2\b\u0010s\u001a\u0004\u0018\u00010mJ\u0010\u0010p\u001a\u0002082\b\b\u0001\u0010t\u001a\u00020mR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020-0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/intellij/microservices/jvm/beans/BeansView;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/wm/ToolWindow;)V", "beansList", "Lcom/intellij/microservices/jvm/beans/BeansList;", "listRenderer", "Lcom/intellij/microservices/jvm/beans/BeansListRenderer;", "beansModel", "Ljavax/swing/DefaultListModel;", "Lcom/intellij/microservices/jvm/beans/BeansListItem;", "searchUpdateAlarm", "Lcom/intellij/util/Alarm;", "psiChangeUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "value", "", "isDisposed", "isDisposed$intellij_microservices_jvm", "()Z", "searchTextField", "Lcom/intellij/ui/filterField/FilterSearchTextField;", "searchPopupController", "Lcom/intellij/microservices/jvm/beans/BeansSearchPopupController;", "splitter", "Lcom/intellij/ui/JBSplitter;", "tabbedPaneWrapper", "Lcom/intellij/ui/tabs/impl/SingleHeightTabs;", "docSidePanel", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "docComponent", "Lcom/intellij/lang/documentation/ide/ui/DocumentationComponent;", "filtersToolbar", "Ljavax/swing/JComponent;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "sidePanels", "", "Lcom/intellij/microservices/jvm/beans/BeansSidePanel;", "sidePanelsActivatedState", "", "beansCursor", "Lcom/intellij/microservices/jvm/beans/BeansCursor;", "beansModificationCount", "", "updateOnShow", "cursorScope", "docScope", "initContent", "", "initSidePanelTabs", "initFilters", "createFrameworkFilter", "Lcom/intellij/ui/filterField/FilterField;", "createTypeFilter", "createModuleFilter", "updateSidePanel", "updateContributedSidePanels", "setup", "start", "installListActions", "initGlobalListeners", "forgetData", "forgetSelection", "forgetDocumentation", "setSidePanelVisibility", "updateListRenderer", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setSplitOrientation", "requestInitialLoad", "onChanges", "updateItemsOnChange", "dispose", "appendToList", "cursor", "listItems", "Lcom/intellij/microservices/jvm/beans/FlatBeanItem;", "loadInitial", "loadNext", "getCurrentItemsCount", "", "load", "context", "Lcom/intellij/microservices/jvm/beans/LoadContext;", "restoreSelection", "oldSelectedIndices", "", "oldSelectedSidePanel", "getIndicesToSelect", "performEditAction", "installEditOnDoubleClick", "list", "Lcom/intellij/ui/components/JBList;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getSelectedBeansItems", "getTarget", "it", "showSearchPopup", "applyFilter", "attribute", "", "values", "", "showBeans", "module", "framework", "filter", "searchedValue", "Companion", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nBeansView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeansView.kt\ncom/intellij/microservices/jvm/beans/BeansView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1114:1\n1617#2,9:1115\n1869#2:1124\n1870#2:1126\n1626#2:1127\n1788#2,4:1129\n808#2,11:1138\n1617#2,9:1149\n1869#2:1158\n1870#2:1160\n1626#2:1161\n1563#2:1162\n1634#2,3:1163\n1#3:1125\n1#3:1128\n1#3:1159\n3946#4:1133\n4464#4,2:1134\n37#5,2:1136\n37#5,2:1166\n13#6:1168\n*S KotlinDebug\n*F\n+ 1 BeansView.kt\ncom/intellij/microservices/jvm/beans/BeansView\n*L\n362#1:1115,9\n362#1:1124\n362#1:1126\n362#1:1127\n773#1:1129,4\n943#1:1138,11\n954#1:1149,9\n954#1:1158\n954#1:1160\n954#1:1161\n948#1:1162\n948#1:1163,3\n362#1:1125\n954#1:1159\n883#1:1133\n883#1:1134,2\n941#1:1136,2\n949#1:1166,2\n1040#1:1168\n*E\n"})
public final class BeansView
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final BeansList beansList;
    @NotNull
    private final BeansListRenderer listRenderer;
    @NotNull
    private final DefaultListModel<BeansListItem> beansModel;
    @NotNull
    private final Alarm searchUpdateAlarm;
    @NotNull
    private final MergingUpdateQueue psiChangeUpdateQueue;
    private volatile boolean isDisposed;
    @NotNull
    private final FilterSearchTextField searchTextField;
    @NotNull
    private final BeansSearchPopupController searchPopupController;
    @NotNull
    private final JBSplitter splitter;
    @NotNull
    private final SingleHeightTabs tabbedPaneWrapper;
    @NotNull
    private final JBPanelWithEmptyText docSidePanel;
    @Nullable
    private DocumentationComponent docComponent;
    private JComponent filtersToolbar;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private List<? extends BeansSidePanel> sidePanels;
    @NotNull
    private final Set<BeansSidePanel> sidePanelsActivatedState;
    @Nullable
    private volatile BeansCursor beansCursor;
    private volatile long beansModificationCount;
    private volatile boolean updateOnShow;
    @NotNull
    private final CoroutineScope cursorScope;
    @NotNull
    private final CoroutineScope docScope;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String TOOL_WINDOW_ID = "Beans";
    private static final int FETCH_PAGE_SIZE = 30;
    private static final int MAX_FILTER_VALUE_LENGTH = 30;
    @NotNull
    private static final String BEANS_CONTEXT_MENU_PLACE = "popup@BeansContextMenu";
    @NotNull
    private static final String BEANS_FILTER_TOOLBAR_PLACE = "BeansFilterToolbar";
    @NotNull
    private static final ExtensionPointName<BeansSidePanelProvider> SIDE_PANEL_EP_NAME;

    public BeansView(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull ToolWindow toolWindow) {
        ShortcutSet findShortcuts;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(false, true);
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.toolWindow = toolWindow;
        this.beansList = new BeansList();
        this.listRenderer = new BeansListRenderer(true);
        this.beansModel = new DefaultListModel();
        this.searchUpdateAlarm = new Alarm(this.coroutineScope, Alarm.ThreadToUse.SWING_THREAD);
        CoroutineScope coroutineScope2 = this.coroutineScope;
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        this.psiChangeUpdateQueue = new MergingUpdateQueue("BeansRefresh", 500, true, (JComponent)((Object)this), null, null, threadToUse, coroutineScope2);
        this.searchTextField = new FilterSearchTextField(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                this.setHistoryPropertyName("BeansSearchHistory");
                this.setHistorySize(10);
            }

            protected boolean toClearTextOnEscape() {
                searchTextField.1 textField = this;
                new AnAction(this.this$0, textField){
                    final /* synthetic */ BeansView this$0;
                    final /* synthetic */ searchTextField.1 $textField;
                    {
                        this.this$0 = $receiver;
                        this.$textField = $textField;
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (BeansView.access$getSearchPopupController$p(this.this$0).isPopupShow()) {
                            BeansView.access$getSearchPopupController$p(this.this$0).hidePopup();
                        } else {
                            this.$textField.setText("");
                            BeansView.loadInitial$default(this.this$0, false, 1, null);
                        }
                    }
                }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)this));
                return false;
            }

            protected boolean preprocessEventForTextField(KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int keyCode = event.getKeyCode();
                int id = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    if (id == 401 && !BeansView.access$getSearchPopupController$p(this.this$0).handleEnter(event)) {
                        BeansView.access$getSearchPopupController$p(this.this$0).hidePopup();
                        BeansView.access$forgetSelection(this.this$0);
                        this.addCurrentTextToHistory();
                        BeansView.loadInitial$default(this.this$0, false, 1, null);
                    }
                    return true;
                }
                return (keyCode == 40 || keyCode == 38) && id == 401 && BeansView.access$getSearchPopupController$p(this.this$0).handleUpDown(event) ? true : super.preprocessEventForTextField(event);
            }

            protected void historyItemChosen(String item) {
                BeansView.loadInitial$default(this.this$0, false, 1, null);
            }

            protected void onFieldCleared() {
                BeansView.loadInitial$default(this.this$0, false, 1, null);
            }

            protected void showCompletionPopup() {
                if (!BeansView.access$getSearchPopupController$p(this.this$0).isPopupShow()) {
                    BeansView.access$showSearchPopup(this.this$0);
                }
            }
        };
        this.searchPopupController = new BeansSearchPopupController(this.project, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"BeansViewCompletion", null, (boolean)false, (int)6, null), this.searchTextField, (JList)((Object)this.beansList));
        this.splitter = (JBSplitter)new OnePixelSplitter(0.5f);
        this.tabbedPaneWrapper = (SingleHeightTabs)new FilterSideTabs(this.project, (Disposable)this);
        this.docSidePanel = new JBPanelWithEmptyText();
        this.scrollPane = new JBScrollPane((Component)((Object)this.beansList));
        this.sidePanels = CollectionsKt.emptyList();
        this.sidePanelsActivatedState = new HashSet();
        this.cursorScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"BeansViewCursor", null, (boolean)false, (int)6, null);
        this.docScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"BeansViewDocumentation", null, (boolean)false, (int)6, null);
        this.beansList.setModel(this.beansModel);
        this.beansList.setCellRenderer(this.listRenderer);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.updateListRenderer((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BeansViewService.Companion.getInstance(this.project).addChangeListener((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.updateListRenderer((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.installListActions(this.beansList);
        this.installEditOnDoubleClick(this.beansList);
        ScrollingUtil.installActions((JList)((JList)((Object)this.beansList)), null, (boolean)false);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
            private int previousScrollValue;

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                block3: {
                    double scrollPercent;
                    int rowsFromEnd;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int extent = scrollPane.getVerticalScrollBar().getModel().getExtent();
                    int scrollMax = scrollPane.getVerticalScrollBar().getMaximum();
                    if (scrollMax <= 0 || beansList.isBusyLoading() || e.getValueIsAdjusting()) break block3;
                    int oldValue = this.previousScrollValue;
                    this.previousScrollValue = e.getValue();
                    if (oldValue > e.getValue()) {
                        return;
                    }
                    int totalRows = beansModel.getSize();
                    if (totalRows > 0 && (rowsFromEnd = MathKt.roundToInt((double)((double)totalRows * (1.0 - (scrollPercent = (double)(e.getValue() + extent) / (double)scrollMax))))) < 15) {
                        LOG.debug("Rows remaining " + rowsFromEnd + ", will load next batch");
                        BeansCursor beansCursor = beansCursor;
                        if (beansCursor != null) {
                            BeansCursor beansCursor2 = beansCursor;
                            BeansView beansView = this;
                            BeansCursor it = beansCursor2;
                            boolean bl = false;
                            beansView.loadNext(it, false);
                        }
                    }
                }
            }
        });
        this.beansList.addListSelectionListener(arg_0 -> BeansView._init_$lambda$0(this, arg_0));
        this.initSidePanelTabs();
        this.tabbedPaneWrapper.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (newSelection != null) {
                    Object v0;
                    block4: {
                        Iterable iterable = sidePanels;
                        for (Object t : iterable) {
                            BeansSidePanel it = (BeansSidePanel)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getComponent(), (Object)newSelection.getComponent())) continue;
                            v0 = t;
                            break block4;
                        }
                        v0 = null;
                    }
                    BeansSidePanel beansSidePanel = v0;
                    if (beansSidePanel == null) {
                        return;
                    }
                    BeansSidePanel newSidePanel = beansSidePanel;
                    List selectedItems = this.getSelectedBeansItems();
                    if (!sidePanelsActivatedState.contains(newSidePanel)) {
                        sidePanelsActivatedState.add(newSidePanel);
                        newSidePanel.update(selectedItems, true);
                    }
                }
            }
        });
        this.searchTextField.getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!searchTextField.isSkipDocumentEvents()) {
                    searchUpdateAlarm.cancelAllRequests();
                    searchUpdateAlarm.addRequest(() -> 6.textChanged$lambda$0(this), 250, ModalityState.stateForComponent((Component)((Component)searchTextField)));
                }
            }

            private static final void textChanged$lambda$0(BeansView this$0) {
                CharSequence charSequence = this$0.searchTextField.getText();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    this$0.searchPopupController.handleShowPopup();
                }
            }
        });
        CoroutineScope $this$_init__u24lambda_u241 = coroutineScope2 = this.searchTextField;
        boolean bl = false;
        $this$_init__u24lambda_u241.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        $this$_init__u24lambda_u241.getTextEditor().setBorder(JBUI.Borders.empty((int)1));
        $this$_init__u24lambda_u241.getTextEditor().setOpaque(true);
        $this$_init__u24lambda_u241.getTextEditor().putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUIScale.scale((int)2));
        $this$_init__u24lambda_u241.getTextEditor().putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUIScale.scale((int)-1));
        this.initFilters();
        this.initContent();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ComponentsListFocusTraversalPolicy(){

            protected List<Component> getOrderedComponents() {
                Object object = tabbedPaneWrapper.getSelectedInfo();
                if (object == null || (object = object.getComponent()) == null) {
                    object = (JComponent)tabbedPaneWrapper;
                }
                Object sidePanel = object;
                SpreadBuilder spreadBuilder = new SpreadBuilder(4);
                spreadBuilder.add((Object)searchTextField.getTextEditor());
                spreadBuilder.add((Object)beansList);
                spreadBuilder.add(sidePanel);
                JComponent jComponent = filtersToolbar;
                if (jComponent == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"filtersToolbar");
                    jComponent = null;
                }
                spreadBuilder.addSpread((Object)jComponent.getComponents());
                return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Component[spreadBuilder.size()]));
            }
        });
        AnAction anAction = ActionManager.getInstance().getAction("Find");
        Object object = findShortcuts = anAction != null ? anAction.getShortcutSet() : null;
        if (findShortcuts != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(findShortcuts, (JComponent)((Object)this), (Disposable)this);
        }
    }

    public final boolean isDisposed$intellij_microservices_jvm() {
        return this.isDisposed;
    }

    private final void initContent() {
        BorderLayoutPanel borderLayoutPanel;
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("BeansActions.Title");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        DefaultActionGroup titleActionsGroup = (DefaultActionGroup)anAction;
        AnAction[] anActionArray = titleActionsGroup.getChildren(actionManager);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        this.toolWindow.setTitleActions(ArraysKt.toList((Object[])anActionArray));
        AnAction anAction2 = actionManager.getAction("BeansActions.FilterToolbar");
        Intrinsics.checkNotNull((Object)anAction2, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionToolbar actionToolbar = actionManager.createActionToolbar(BEANS_FILTER_TOOLBAR_PLACE, (ActionGroup)anAction2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar filterToolbar = actionToolbar;
        filterToolbar.setTargetComponent((JComponent)((Object)this));
        filterToolbar.setReservePlaceAutoPopupIcon(false);
        BorderLayoutPanel borderLayoutPanel2 = new BorderLayoutPanel();
        Object $this$initContent_u24lambda_u240 = borderLayoutPanel2;
        boolean bl = false;
        $this$initContent_u24lambda_u240.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        JComponent jComponent = this.filtersToolbar;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filtersToolbar");
            jComponent = null;
        }
        $this$initContent_u24lambda_u240.addToCenter((Component)jComponent);
        $this$initContent_u24lambda_u240.addToRight((Component)filterToolbar.getComponent());
        BorderLayoutPanel filtersWrapper = borderLayoutPanel2;
        Object $this$initContent_u24lambda_u241 = $this$initContent_u24lambda_u240 = new JPanel((LayoutManager)new VerticalLayout(0));
        boolean bl2 = false;
        ((Container)$this$initContent_u24lambda_u241).add((Component)filtersWrapper);
        ((Container)$this$initContent_u24lambda_u241).add((Component)this.searchTextField);
        Object topPanel = $this$initContent_u24lambda_u240;
        BorderLayoutPanel $this$initContent_u24lambda_u242 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl3 = false;
        $this$initContent_u24lambda_u242.addToTop((Component)topPanel);
        $this$initContent_u24lambda_u242.addToCenter((Component)this.scrollPane);
        BorderLayoutPanel listWrapper = borderLayoutPanel;
        this.splitter.setFirstComponent((JComponent)listWrapper);
        this.splitter.setSecondComponent(this.tabbedPaneWrapper.getComponent());
        this.splitter.setProportion(0.65f);
        this.splitter.setAndLoadSplitterProportionKey("Beans.split");
        this.setSidePanelVisibility();
        this.docSidePanel.setLayout((LayoutManager)new BorderLayout());
        this.docSidePanel.getEmptyText().setText(MicroservicesJvmBundle.message("beans.tab.documentation.empty.text", new Object[0]));
        this.setContent((JComponent)this.splitter);
    }

    /*
     * WARNING - void declaration
     */
    private final void initSidePanelTabs() {
        TabInfo tabInfo = this.tabbedPaneWrapper.findInfo((Component)this.docSidePanel);
        if (tabInfo != null) {
            TabInfo it = tabInfo;
            boolean bl = false;
            this.tabbedPaneWrapper.select(it, false);
        }
        this.forgetDocumentation();
        for (BeansSidePanel beansSidePanel : this.sidePanels) {
            if (this.tabbedPaneWrapper.findInfo((Component)beansSidePanel.getComponent()) != null) {
                TabInfo it;
                boolean bl = false;
                this.tabbedPaneWrapper.removeTab(it);
            }
            if (!(beansSidePanel instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)beansSidePanel));
        }
        this.tabbedPaneWrapper.removeAllTabs();
        this.sidePanels = CollectionsKt.emptyList();
        this.sidePanelsActivatedState.clear();
        if (BeansViewSettings.Companion.getInstance(this.project).isShowSidePanel()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = new TabInfo((JComponent)this.docSidePanel);
            TabInfo tabInfo2 = object;
            Object object2 = this.tabbedPaneWrapper;
            boolean $i$a$-apply-BeansView$initSidePanelTabs$432 = false;
            tabInfo2.setText(MicroservicesJvmBundle.message("beans.tab.documentation", new Object[0]));
            object2.addTab((TabInfo)object);
            object = SIDE_PANEL_EP_NAME.getExtensionList();
            object2 = this;
            boolean bl = false;
            void $i$a$-apply-BeansView$initSidePanelTabs$432 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BeansSidePanel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                BeansSidePanelProvider it = (BeansSidePanelProvider)element$iv$iv;
                boolean bl22 = false;
                if (it.create(this.project) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object2.sidePanels = (List)destination$iv$iv;
            for (BeansSidePanel beansSidePanel : this.sidePanels) {
                void $this$initSidePanelTabs_u24lambda_u244;
                TabInfo tabInfo22 = new TabInfo(beansSidePanel.getComponent());
                destination$iv$iv = tabInfo22;
                object2 = this.tabbedPaneWrapper;
                boolean bl3 = false;
                $this$initSidePanelTabs_u24lambda_u244.setText(beansSidePanel.getTitle());
                object2.addTab(tabInfo22);
                if (!(beansSidePanel instanceof Disposable)) continue;
                Disposer.register((Disposable)this, (Disposable)((Disposable)beansSidePanel));
            }
            this.updateContributedSidePanels();
        }
    }

    private final void initFilters() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterFieldAction((Function0)new Function0<FilterField>((Object)this){

            public final FilterField invoke() {
                return BeansView.access$createModuleFilter((BeansView)((Object)this.receiver));
            }
        }));
        actionGroup.add((AnAction)new FilterFieldAction((Function0)new Function0<FilterField>((Object)this){

            public final FilterField invoke() {
                return BeansView.access$createTypeFilter((BeansView)((Object)this.receiver));
            }
        }));
        actionGroup.add((AnAction)new BeansFrameworkFilterFieldAction((Function0<? extends FilterField>)((Function0)new Function0<FilterField>((Object)this){

            public final FilterField invoke() {
                return BeansView.access$createFrameworkFilter((BeansView)((Object)this.receiver));
            }
        })));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(TOOL_WINDOW_ID, (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)((Object)this));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.filtersToolbar = jComponent;
    }

    private final FilterField createFrameworkFilter() {
        String string = MicroservicesBundle.message((String)"frameworks.filters.framework", (Object[])new Object[0]);
        return new FilterField(this, string){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            protected Collection<AnAction> buildActions() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = BeansViewService.Companion.getInstance(BeansView.access$getProject$p(this.this$0)).getAvailableProviders();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BeansProvider beansProvider = (BeansProvider)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new FilterItem(it.getPresentation().getFramework(), it.getPresentation().getQueryTag()));
                }
                Iterable $this$sortedBy$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                List providers = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        FilterItem it = (FilterItem)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getTitle());
                        it = (FilterItem)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTitle())));
                    }
                }));
                Object object = BeansView.access$getBeansCursor$p(this.this$0);
                if (object == null || (object = ((BeansCursor)object).getQueryParser()) == null || (object = ((BeansSearchQueryParser)((Object)object)).getFrameworks()) == null) {
                    object = SetsKt.emptySet();
                }
                Object selectedFrameworks = object;
                FilterApplier applier = (arg_0, arg_1) -> createFrameworkFilter.1.buildActions$lambda$2(this.this$0, arg_0, arg_1);
                return FiltersKt.createFilterActions((Component)((Component)((Object)this)), (String)"framework:", (String)MicroservicesBundle.message((String)"frameworks.filters.framework.title", (Object[])new Object[0]), (List)providers, (Collection)((Collection)selectedFrameworks), (FilterApplier)applier);
            }

            public String getCurrentText() {
                Object frameworks;
                Object object = BeansView.access$getBeansCursor$p(this.this$0);
                if (object == null || (object = ((BeansCursor)object).getQueryParser()) == null || (object = ((BeansSearchQueryParser)((Object)object)).getFrameworks()) == null) {
                    object = SetsKt.emptySet();
                }
                if ((frameworks = object).isEmpty()) {
                    return null;
                }
                return com.intellij.microservices.jvm.beans.BeansView$Companion.access$displayableFilterText(BeansView.Companion, (Collection)frameworks);
            }

            private static final void buildActions$lambda$2(BeansView this$0, String attribute, Collection values) {
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                BeansView.access$applyFilter(this$0, attribute, values);
            }
        };
    }

    private final FilterField createTypeFilter() {
        String string = MicroservicesBundle.message((String)"frameworks.filters.type", (Object[])new Object[0]);
        return new FilterField(this, string){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected Collection<AnAction> buildActions() {
                Object object = BeansView.access$getBeansCursor$p(this.this$0);
                if (object == null || (object = ((BeansCursor)object).getQueryParser()) == null || (object = ((BeansSearchQueryParser)((Object)object)).getFrameworks()) == null) {
                    object = SetsKt.emptySet();
                }
                Object chosenFrameworks = object;
                Sequence<BeanStereotype> $this$sortedBy$iv = BeansViewManagerKt.getAvailableBeanStereotypes(BeansView.access$getProject$p(this.this$0), CollectionsKt.toList((Iterable)((Iterable)chosenFrameworks)));
                boolean $i$f$sortedBy = false;
                List types = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        BeanStereotype it = (BeanStereotype)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getQueryTag());
                        it = (BeanStereotype)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getQueryTag())));
                    }
                }), createTypeFilter.1::buildActions$lambda$1));
                Object object2 = BeansView.access$getBeansCursor$p(this.this$0);
                if (object2 == null || (object2 = ((BeansCursor)object2).getQueryParser()) == null || (object2 = ((BeansSearchQueryParser)((Object)object2)).getTypes()) == null) {
                    object2 = SetsKt.emptySet();
                }
                Object selectedTypes = object2;
                FilterApplier applier = (arg_0, arg_1) -> createTypeFilter.1.buildActions$lambda$2(this.this$0, arg_0, arg_1);
                return FiltersKt.createFilterActions((Component)((Component)((Object)this)), (String)"type:", (String)MicroservicesBundle.message((String)"frameworks.filters.type.title", (Object[])new Object[0]), (List)types, (Collection)((Collection)selectedTypes), (FilterApplier)applier);
            }

            public String getCurrentText() {
                Object types;
                Object object = BeansView.access$getBeansCursor$p(this.this$0);
                if (object == null || (object = ((BeansCursor)object).getQueryParser()) == null || (object = ((BeansSearchQueryParser)((Object)object)).getTypes()) == null) {
                    object = SetsKt.emptySet();
                }
                if ((types = object).isEmpty()) {
                    return null;
                }
                return com.intellij.microservices.jvm.beans.BeansView$Companion.access$displayableFilterText(BeansView.Companion, (Collection)types);
            }

            private static final FilterItem buildActions$lambda$1(BeanStereotype it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new FilterItem(it.getLocalizedMessage(), it.getQueryTag());
            }

            private static final void buildActions$lambda$2(BeansView this$0, String attribute, Collection values) {
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                BeansView.access$applyFilter(this$0, attribute, values);
            }
        };
    }

    private final FilterField createModuleFilter() {
        String string = MicroservicesBundle.message((String)"frameworks.filters.module", (Object[])new Object[0]);
        return new FilterField(this, string){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            protected Collection<AnAction> buildActions() {
                void $this$mapTo$iv$iv;
                Module[] $this$map$iv = ModuleManager.Companion.getInstance(BeansView.access$getProject$p(this.this$0)).getModules();
                boolean $i$f$map = false;
                Module[] moduleArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    collection.add(new FilterItem(string, string2));
                }
                List modules = (List)destination$iv$iv;
                Object object = BeansView.access$getBeansCursor$p(this.this$0);
                if (object == null || (object = ((BeansCursor)object).getQueryParser()) == null || (object = ((BeansSearchQueryParser)((Object)object)).getModules()) == null) {
                    object = SetsKt.emptySet();
                }
                Object selectedModules = object;
                FilterApplier applier = (arg_0, arg_1) -> createModuleFilter.1.buildActions$lambda$1(this.this$0, arg_0, arg_1);
                return FiltersKt.createFilterActions((Component)((Component)((Object)this)), (String)"module:", (String)MicroservicesBundle.message((String)"frameworks.filters.module.title", (Object[])new Object[0]), (List)modules, (Collection)((Collection)selectedModules), (FilterApplier)applier);
            }

            public String getCurrentText() {
                Object modules;
                Object object = BeansView.access$getBeansCursor$p(this.this$0);
                if (object == null || (object = ((BeansCursor)object).getQueryParser()) == null || (object = ((BeansSearchQueryParser)((Object)object)).getModules()) == null) {
                    object = SetsKt.emptySet();
                }
                if ((modules = object).isEmpty()) {
                    return null;
                }
                return com.intellij.microservices.jvm.beans.BeansView$Companion.access$displayableFilterText(BeansView.Companion, (Collection)modules);
            }

            private static final void buildActions$lambda$1(BeansView this$0, String attribute, Collection values) {
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                BeansView.access$applyFilter(this$0, attribute, values);
            }
        };
    }

    private final void updateSidePanel() {
        this.forgetDocumentation();
        List list = this.beansList.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
        BeansListItem item = (BeansListItem)CollectionsKt.firstOrNull((List)list);
        if (item instanceof FlatBeanItem) {
            BuildersKt.launch$default((CoroutineScope)this.docScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, item, null){
                Object L$0;
                int label;
                final /* synthetic */ BeansView this$0;
                final /* synthetic */ BeansListItem $item;
                {
                    this.this$0 = $receiver;
                    this.$item = $item;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = CoroutinesKt.smartReadAction((Project)BeansView.access$getProject$p(this.this$0), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.microservices.jvm.beans.BeansListItem ), ()Lcom/intellij/openapi/util/Pair;)((BeansListItem)this.$item), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = (Pair)v0;
                            if (v1 == null) {
                                return Unit.INSTANCE;
                            }
                            pair = v1;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)pair);
                            this.label = 2;
                            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (Pair<Pointer<? extends DocumentationTarget>, TargetPresentation>)pair, null){
                                int label;
                                final /* synthetic */ BeansView this$0;
                                final /* synthetic */ Pair<Pointer<? extends DocumentationTarget>, TargetPresentation> $pair;
                                {
                                    this.this$0 = $receiver;
                                    this.$pair = $pair;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            if (BeansView.access$getDocComponent$p(this.this$0) != null) {
                                                DocumentationComponent documentationComponent = BeansView.access$getDocComponent$p(this.this$0);
                                                Intrinsics.checkNotNull((Object)documentationComponent);
                                                Object object = this.$pair.first;
                                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                                                Pointer pointer = (Pointer)object;
                                                Object object2 = this.$pair.second;
                                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
                                                documentationComponent.resetBrowser(pointer, (TargetPresentation)object2);
                                            } else {
                                                Project project = BeansView.access$getProject$p(this.this$0);
                                                Object object = this.$pair.first;
                                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                                                Pointer pointer = (Pointer)object;
                                                Object object3 = this.$pair.second;
                                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
                                                BeansView.access$setDocComponent$p(this.this$0, DocumentationUtil.documentationComponent((Project)project, (Pointer)pointer, (TargetPresentation)((TargetPresentation)object3), (Disposable)this.this$0));
                                                JBPanelWithEmptyText jBPanelWithEmptyText = BeansView.access$getDocSidePanel$p(this.this$0);
                                                DocumentationComponent documentationComponent = BeansView.access$getDocComponent$p(this.this$0);
                                                Intrinsics.checkNotNull((Object)documentationComponent);
                                                jBPanelWithEmptyText.add((Component)documentationComponent.getComponent(), (Object)"Center");
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl27
                        }
                        case 2: {
                            pair = (Pair)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl27:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Pair invokeSuspend$lambda$0(BeansListItem $item) {
                    PsiElement psiElement = ((FlatBeanItem)$item).getDocumentationElement();
                    if (psiElement == null) {
                        return null;
                    }
                    PsiElement psiElement2 = psiElement;
                    DocumentationTarget target = (DocumentationTarget)CollectionsKt.first((List)UtilKt.psiDocumentationTargets((PsiElement)psiElement2, null));
                    return Pair.create((Object)target.createPointer(), (Object)target.computePresentation());
                }
            }), (int)3, null);
            DocumentationComponent documentationComponent = this.docComponent;
            if (documentationComponent != null) {
                DocumentationComponent documentationComponent2;
                DocumentationComponent $this$updateSidePanel_u24lambda_u240 = documentationComponent2 = documentationComponent;
                boolean bl = false;
                this.docSidePanel.add((Component)$this$updateSidePanel_u24lambda_u240.getComponent(), (Object)"Center");
            }
        } else if (item instanceof ModuleItem) {
            SimpleColoredComponent details = new SimpleColoredComponent();
            details.setIcon(AllIcons.Nodes.Module);
            details.append(((ModuleItem)item).getModule().getName());
            BorderLayoutPanel wrapper = new BorderLayoutPanel();
            wrapper.addToLeft((Component)details);
            wrapper.setBorder(JBUI.Borders.empty((int)7));
            this.docSidePanel.add((Component)wrapper, (Object)"North");
        }
        this.docSidePanel.revalidate();
        this.docSidePanel.repaint();
        this.updateContributedSidePanels();
    }

    private final void updateContributedSidePanels() {
        this.sidePanelsActivatedState.clear();
        TabInfo tabInfo = this.tabbedPaneWrapper.getSelectedInfo();
        JComponent selectedSidePanelComponent = tabInfo != null ? tabInfo.getComponent() : null;
        List<BeansListItem> selectedItems = this.getSelectedBeansItems();
        for (BeansSidePanel beansSidePanel : this.sidePanels) {
            TabInfo info;
            boolean isActive = Intrinsics.areEqual((Object)selectedSidePanelComponent, (Object)beansSidePanel.getComponent());
            beansSidePanel.update(selectedItems, isActive);
            boolean visible = beansSidePanel.isVisible(selectedItems);
            if (isActive && visible) {
                this.sidePanelsActivatedState.add(beansSidePanel);
            }
            if (this.tabbedPaneWrapper.findInfo((Component)beansSidePanel.getComponent()) == null) continue;
            info.setHidden(!visible);
            if (isActive) continue;
            info.setEnabled(beansSidePanel.isAvailable(selectedItems));
        }
        this.tabbedPaneWrapper.revalidateAndRepaint();
    }

    public final void setup() {
        this.setSplitOrientation();
        this.initGlobalListeners();
    }

    public final void start() {
        BeansView.loadInitial$default(this, false, 1, null);
    }

    private final void installListActions(BeansList beansList) {
        Object[] customActions;
        Supplier supplier = ActionsBundle.messagePointer((String)"action.EditSource.text", (Object[])new Object[0]);
        Icon icon = AllIcons.Actions.Edit;
        AnAction editAction2 = new AnAction(this, supplier, icon){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BeansView.access$performEditAction(this.this$0);
            }
        };
        editAction2.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)beansList));
        List actions = new ArrayList();
        AnAction editSourceAction = ActionManager.getInstance().getAction("EditSource");
        if (editSourceAction != null) {
            actions.add(editSourceAction);
        }
        if (!((customActions = BeansView.Companion.getCustomContextMenuActions()).length == 0)) {
            Separator separator = Separator.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"getInstance(...)");
            actions.add(separator);
            CollectionsKt.addAll((Collection)actions, (Object[])customActions);
        }
        ActionGroup contextActionGroup = (ActionGroup)new DefaultActionGroup(actions);
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)beansList)), (ActionGroup)contextActionGroup, (String)BEANS_CONTEXT_MENU_PLACE);
    }

    private final void initGlobalListeners() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = PsiModificationTracker.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> BeansView.initGlobalListeners$lambda$0(this));
        messageBusConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
            }

            public void exitDumbMode() {
                BeansView.access$requestInitialLoad(this.this$0, true);
            }
        });
        Topic topic2 = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)new ModuleRootListener(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
            }

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BeansView.access$requestInitialLoad(this.this$0, true);
            }
        });
        Topic topic3 = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        messageBusConnection.subscribe(topic3, (Object)new ModuleListener(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
            }

            public void modulesAdded(Project project, List<? extends Module> modules) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                BeansView.access$requestInitialLoad(this.this$0, true);
            }

            public void modulesRenamed(Project project, List<? extends Module> modules, Function<? super Module, String> oldNameProvider) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                BeansView.access$requestInitialLoad(this.this$0, true);
            }

            public void moduleRemoved(Project project, Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    BeansView.access$forgetData(this.this$0);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> initGlobalListeners.4.moduleRemoved$lambda$0(this.this$0), ModalityState.nonModal(), project.getDisposed());
                }
                BeansView.requestInitialLoad$default(this.this$0, false, 1, null);
            }

            private static final void moduleRemoved$lambda$0(BeansView this$0) {
                BeansView.access$forgetData(this$0);
            }
        });
        messageBusConnection.subscribe(BeansViewListener.Companion.getTOPIC(), (Object)new BeansViewListener(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
            }

            public void beansChanged(BeansViewListener.ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (initGlobalListeners.WhenMappings.$EnumSwitchMapping$0[e.getType().ordinal()]) {
                    case 1: {
                        BeansView.access$forgetData(this.this$0);
                        break;
                    }
                    case 2: {
                        BuildersKt.launch$default((CoroutineScope)BeansView.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ BeansView this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BeansView.access$updateListRenderer(this.this$0, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        BeansView.access$setSidePanelVisibility(this.this$0);
                        BeansView.access$initSidePanelTabs(this.this$0);
                        BeansView.requestInitialLoad$default(this.this$0, false, 1, null);
                        break;
                    }
                    default: {
                        BeansView.access$requestInitialLoad(this.this$0, true);
                    }
                }
            }
        });
        Topic topic4 = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic4, (String)"TOPIC");
        messageBusConnection.subscribe(topic4, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                BeansView.access$setSplitOrientation(this.this$0);
                BuildersKt.launch$default((CoroutineScope)BeansView.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ BeansView this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = BeansView.access$updateListRenderer(this.this$0, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
        SIDE_PANEL_EP_NAME.addChangeListener(() -> BeansView.initGlobalListeners$lambda$1(this), (Disposable)this);
    }

    private final void forgetData() {
        this.psiChangeUpdateQueue.cancelAllUpdates();
        this.beansModel.removeAllElements();
        this.beansCursor = null;
        this.forgetDocumentation();
        this.updateContributedSidePanels();
    }

    private final void forgetSelection() {
        this.beansList.getSelectionModel().clearSelection();
    }

    private final void forgetDocumentation() {
        JobKt.cancelChildren$default((CoroutineContext)this.docScope.getCoroutineContext(), null, (int)1, null);
        DocumentationComponent documentationComponent = this.docComponent;
        if (documentationComponent != null) {
            documentationComponent.resetBrowser();
        }
        this.docSidePanel.removeAll();
    }

    private final void setSidePanelVisibility() {
        this.tabbedPaneWrapper.setVisible(BeansViewSettings.Companion.getInstance(this.project).isShowSidePanel());
    }

    private final Object updateListRenderer(Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean compact;
                        ResultKt.throwOnFailure((Object)$result);
                        boolean bl = compact = BeansViewService.Companion.getInstance(BeansView.access$getProject$p(this.this$0)).isExclusive() || BeansViewSettings.Companion.getInstance(BeansView.access$getProject$p(this.this$0)).isCompactMode();
                        if (compact != BeansView.access$getListRenderer$p(this.this$0).isCompact()) {
                            BeansView.access$getListRenderer$p(this.this$0).setCompact(compact);
                            BeansView.access$getBeansList$p(this.this$0).repaint();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void setSplitOrientation() {
        this.splitter.setOrientation(!this.toolWindow.getAnchor().isHorizontal());
    }

    private final void requestInitialLoad(boolean onChanges) {
        if (this.toolWindow.isDisposed() || DumbService.Companion.isDumb(this.project)) {
            return;
        }
        if (!this.toolWindow.isVisible()) {
            if (!this.updateOnShow) {
                this.toolWindow.getReady((Object)this).doWhenDone(() -> BeansView.requestInitialLoad$lambda$0(this));
                this.updateOnShow = true;
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> BeansView.requestInitialLoad$lambda$1(this, onChanges), ModalityState.nonModal(), this.project.getDisposed());
    }

    static /* synthetic */ void requestInitialLoad$default(BeansView beansView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        beansView.requestInitialLoad(bl);
    }

    private final void updateItemsOnChange() {
        ApplicationManager.getApplication().invokeLater(() -> BeansView.updateItemsOnChange$lambda$0(this), ModalityState.nonModal(), this.project.getDisposed());
    }

    public void dispose() {
        this.isDisposed = true;
    }

    @RequiresEdt
    private final void appendToList(BeansCursor cursor, List<? extends FlatBeanItem<?, ?>> listItems) {
        boolean wasBusy = this.beansList.isBusyLoading();
        if (wasBusy) {
            this.beansList.setPaintBusy(false);
        }
        this.beansModificationCount = cursor.getModificationCount();
        for (FlatBeanItem<?, ?> item : listItems) {
            if (cursor.getShowModules()) {
                int listSize = this.beansModel.size();
                if (listSize > 0) {
                    FlatBeanItem previousItem;
                    BeansListItem beansListItem = this.beansModel.getElementAt(listSize - 1);
                    FlatBeanItem flatBeanItem = previousItem = beansListItem instanceof FlatBeanItem ? (FlatBeanItem)beansListItem : null;
                    if (!Intrinsics.areEqual((Object)(flatBeanItem != null ? flatBeanItem.getModule() : null), (Object)item.getModule())) {
                        this.beansModel.addElement(new ModuleItem(item.getModule()));
                    }
                } else if (this.beansModel.size() == 0) {
                    this.beansModel.addElement(new ModuleItem(item.getModule()));
                }
            }
            this.beansList.setPaintBusy(false);
            this.beansModel.addElement(item);
        }
        if (wasBusy) {
            this.beansList.setPaintBusy(true);
        }
    }

    private final void loadInitial(boolean onChanges) {
        if (this.isDisposed || DumbService.Companion.isDumb(this.project)) {
            return;
        }
        BeansSearchQueryParser queryParser = new BeansSearchQueryParser();
        String string = this.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        queryParser.parse(string);
        BeansViewSettings settings = BeansViewSettings.Companion.getInstance(this.project);
        BeansCursor cursor = new BeansCursor(this.project, queryParser, settings.isShowModules(), settings.isShowFromLibraries(), settings.isShowFromTests());
        ArrayList<String> filters = new ArrayList<String>(3);
        if (!((Collection)queryParser.getFrameworks()).isEmpty()) {
            filters.add("framework");
        }
        if (!((Collection)queryParser.getModules()).isEmpty()) {
            filters.add("module");
        }
        if (!((Collection)queryParser.getTypes()).isEmpty()) {
            filters.add("type");
        }
        this.beansCursor = cursor;
        this.beansModificationCount = 0L;
        JComponent jComponent = this.filtersToolbar;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filtersToolbar");
            jComponent = null;
        }
        Component[] componentArray = jComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component filter : componentArray) {
            filter.revalidate();
        }
        JComponent jComponent2 = this.filtersToolbar;
        if (jComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filtersToolbar");
            jComponent2 = null;
        }
        jComponent2.repaint();
        this.load(new LoadContext(cursor, 0, onChanges));
    }

    static /* synthetic */ void loadInitial$default(BeansView beansView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        beansView.loadInitial(bl);
    }

    private final void loadNext(BeansCursor cursor, boolean onChanges) {
        if (!this.beansList.isBusyLoading() && cursor.hasMoreItems()) {
            LOG.debug("Load more beans");
            this.load(new LoadContext(cursor, this.getCurrentItemsCount(), onChanges));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getCurrentItemsCount() {
        int n;
        Enumeration<BeansListItem> enumeration = this.beansModel.elements();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
        ArrayList<BeansListItem> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$count$iv = arrayList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                BeansListItem it = (BeansListItem)element$iv;
                boolean bl = false;
                if (!(it instanceof FlatBeanItem) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @RequiresEdt
    private final void load(LoadContext context) {
        Object v1;
        int[] oldSelectedIndices;
        block2: {
            JobKt.cancelChildren$default((CoroutineContext)this.cursorScope.getCoroutineContext(), null, (int)1, null);
            oldSelectedIndices = this.beansList.getSelectedIndices();
            TabInfo tabInfo = this.tabbedPaneWrapper.getSelectedInfo();
            JComponent selectedSidePanelComponent = tabInfo != null ? tabInfo.getComponent() : null;
            Iterable iterable = this.sidePanels;
            for (Object t : iterable) {
                BeansSidePanel it = (BeansSidePanel)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getComponent(), (Object)selectedSidePanelComponent)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        BeansSidePanel oldSelectedSidePanel = v1;
        if (context.offset == 0 && !context.onChanges) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
            this.beansModel.setSize(0);
        }
        this.beansList.setPaintBusy(true);
        BuildersKt.launch$default((CoroutineScope)this.cursorScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, this, oldSelectedIndices, oldSelectedSidePanel, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            final /* synthetic */ LoadContext $context;
            final /* synthetic */ BeansView this$0;
            final /* synthetic */ int[] $oldSelectedIndices;
            final /* synthetic */ BeansSidePanel $oldSelectedSidePanel;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                this.$oldSelectedIndices = $oldSelectedIndices;
                this.$oldSelectedSidePanel = $oldSelectedSidePanel;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        itemsSequence = SequencesKt.take((Sequence)SequencesKt.drop(this.$context.cursor.request(), (int)this.$context.offset), (int)30);
                        generatedItems = new ArrayList<E>();
                        if (!this.$context.onChanges) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)itemsSequence);
                        this.L$1 = generatedItems;
                        this.label = 1;
                        v0 = CoroutinesKt.smartReadAction((Project)BeansView.access$getProject$p(this.this$0), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(kotlin.sequences.Sequence ), ()Ljava/util/List;)((Sequence)itemsSequence), (Continuation)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        generatedItems = (List)this.L$1;
                        itemsSequence = (Sequence)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        itemsPage = (List)v0;
                        Boxing.boxBoolean((boolean)generatedItems.addAll(itemsPage));
                        break;
                    }
                }
                iteratorCounter = new Ref.IntRef();
                hasNext = new Ref.BooleanRef();
                hasNext.element = true;
lbl27:
                // 4 sources

                while (hasNext.element) {
                    item = new Ref.ObjectRef();
                    this.L$0 = itemsSequence;
                    this.L$1 = generatedItems;
                    this.L$2 = iteratorCounter;
                    this.L$3 = hasNext;
                    this.L$4 = item;
                    this.L$5 = null;
                    this.label = 2;
                    v1 = CoroutinesKt.smartReadAction((Project)BeansView.access$getProject$p(this.this$0), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(kotlin.jvm.internal.Ref$ObjectRef kotlin.sequences.Sequence kotlin.jvm.internal.Ref$IntRef kotlin.jvm.internal.Ref$BooleanRef ), ()Lkotlin/Unit;)((Ref.ObjectRef)item, (Sequence)itemsSequence, (Ref.IntRef)iteratorCounter, (Ref.BooleanRef)hasNext), (Continuation)((Continuation)this));
                    if (v1 == var8_2) {
                        return var8_2;
                    }
                    ** GOTO lbl49
                }
                {
                    break;
                    case 2: {
                        item = (Ref.ObjectRef)this.L$4;
                        hasNext = (Ref.BooleanRef)this.L$3;
                        iteratorCounter = (Ref.IntRef)this.L$2;
                        generatedItems = (List)this.L$1;
                        itemsSequence = (Sequence)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl49:
                        // 2 sources

                        if ((listItem = (FlatBeanItem)item.element) == null) ** GOTO lbl27
                        generatedItems.add(listItem);
                        this.L$0 = itemsSequence;
                        this.L$1 = generatedItems;
                        this.L$2 = iteratorCounter;
                        this.L$3 = hasNext;
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)item);
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)listItem);
                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$context, listItem, null){
                            int label;
                            final /* synthetic */ BeansView this$0;
                            final /* synthetic */ LoadContext $context;
                            final /* synthetic */ FlatBeanItem<?, ?> $listItem;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                                this.$listItem = $listItem;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        BeansView.access$appendToList(this.this$0, this.$context.cursor, CollectionsKt.listOf(this.$listItem));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 != var8_2) ** GOTO lbl27
                        return var8_2;
                    }
                    case 3: {
                        listItem = (FlatBeanItem)this.L$5;
                        item = (Ref.ObjectRef)this.L$4;
                        hasNext = (Ref.BooleanRef)this.L$3;
                        iteratorCounter = (Ref.IntRef)this.L$2;
                        generatedItems = (List)this.L$1;
                        itemsSequence = (Sequence)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl27
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)itemsSequence);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)generatedItems);
                this.L$2 = null;
                this.L$3 = null;
                this.L$4 = null;
                this.L$5 = null;
                this.label = 4;
                v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$context, generatedItems, this.$oldSelectedIndices, this.$oldSelectedSidePanel, null){
                    int label;
                    final /* synthetic */ BeansView this$0;
                    final /* synthetic */ LoadContext $context;
                    final /* synthetic */ List<FlatBeanItem<?, ?>> $generatedItems;
                    final /* synthetic */ int[] $oldSelectedIndices;
                    final /* synthetic */ BeansSidePanel $oldSelectedSidePanel;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$generatedItems = $generatedItems;
                        this.$oldSelectedIndices = $oldSelectedIndices;
                        this.$oldSelectedSidePanel = $oldSelectedSidePanel;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                BeansView.access$getBeansList$p(this.this$0).setPaintBusy(false);
                                int oldScrollValue = BeansView.access$getScrollPane$p(this.this$0).getVerticalScrollBar().getValue();
                                if (this.$context.offset == 0 && (this.$generatedItems.isEmpty() || this.$context.onChanges)) {
                                    BeansView.access$getScrollPane$p(this.this$0).getVerticalScrollBar().setValue(0);
                                    BeansView.access$getBeansModel$p(this.this$0).setSize(0);
                                }
                                if (this.$context.onChanges) {
                                    BeansView.access$appendToList(this.this$0, this.$context.cursor, this.$generatedItems);
                                    if (this.$context.offset == 0) {
                                        int[] nArray = this.$oldSelectedIndices;
                                        Intrinsics.checkNotNull((Object)nArray);
                                        BeansView.access$restoreSelection(this.this$0, nArray, this.$oldSelectedSidePanel);
                                        BeansView.access$getScrollPane$p(this.this$0).getVerticalScrollBar().setValue(RangesKt.coerceAtMost((int)oldScrollValue, (int)BeansView.access$getScrollPane$p(this.this$0).getVerticalScrollBar().getMaximum()));
                                    }
                                } else if (this.$context.offset == 0) {
                                    int[] nArray = this.$oldSelectedIndices;
                                    Intrinsics.checkNotNull((Object)nArray);
                                    BeansView.access$restoreSelection(this.this$0, nArray, this.$oldSelectedSidePanel);
                                }
                                if (this.$context.offset == 0 && !((Collection)this.$generatedItems).isEmpty()) {
                                    BeansView.access$loadNext(this.this$0, this.$context.cursor, this.$context.onChanges);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                if (v3 == var8_2) {
                    return var8_2;
                }
                ** GOTO lbl88
                {
                    case 4: {
                        generatedItems = (List)this.L$1;
                        itemsSequence = (Sequence)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl88:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$0(Sequence $itemsSequence) {
                return SequencesKt.toList((Sequence)$itemsSequence);
            }

            private static final Unit invokeSuspend$lambda$1(Ref.ObjectRef $item, Sequence $itemsSequence, Ref.IntRef $iteratorCounter, Ref.BooleanRef $hasNext) {
                $item.element = SequencesKt.firstOrNull((Sequence)SequencesKt.drop((Sequence)$itemsSequence, (int)$iteratorCounter.element));
                ++$iteratorCounter.element;
                $hasNext.element = $item.element != null && $iteratorCounter.element < 30;
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    private final void restoreSelection(int[] oldSelectedIndices, BeansSidePanel oldSelectedSidePanel) {
        int[] indicesToSelect = this.getIndicesToSelect(oldSelectedIndices);
        if (!(indicesToSelect.length == 0)) {
            TabInfo info;
            this.beansList.setSelectedIndices(indicesToSelect);
            List<BeansListItem> selectedItems = this.getSelectedBeansItems();
            if (oldSelectedSidePanel != null && oldSelectedSidePanel.isVisible(selectedItems) && (info = this.tabbedPaneWrapper.findInfo((Component)oldSelectedSidePanel.getComponent())) != null) {
                this.tabbedPaneWrapper.select(info, false);
            }
        } else {
            ScrollingUtil.ensureSelectionExists((JList)((JList)((Object)this.beansList)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getIndicesToSelect(int[] oldSelectedIndices) {
        void $this$filterTo$iv$iv;
        int[] $this$filter$iv = oldSelectedIndices;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(it < this.beansModel.size())) continue;
            destination$iv$iv.add((int)element$iv$iv);
        }
        int[] indicesToSelect = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        if (!(indicesToSelect.length == 0)) {
            return indicesToSelect;
        }
        Enumeration<BeansListItem> elements = this.beansModel.elements();
        int index = 0;
        Intrinsics.checkNotNull(elements);
        object = CollectionsKt.iterator(elements);
        while (object.hasNext()) {
            BeansListItem element = (BeansListItem)object.next();
            if (element instanceof FlatBeanItem) {
                int[] nArray = new int[]{index};
                return nArray;
            }
            ++index;
        }
        return new int[0];
    }

    private final boolean performEditAction() {
        PsiElement psiElement;
        block6: {
            block5: {
                List list = this.beansList.getSelectedValuesList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
                BeansListItem beansListItem = (BeansListItem)CollectionsKt.firstOrNull((List)list);
                if (beansListItem == null) break block5;
                BeansListItem it = beansListItem;
                boolean bl = false;
                BeansListItem beansListItem2 = this.getTarget(it);
                FlatBeanItem flatBeanItem = beansListItem2 instanceof FlatBeanItem ? (FlatBeanItem)beansListItem2 : null;
                if (flatBeanItem != null && (psiElement = flatBeanItem.getNavigationElement()) != null) break block6;
            }
            return false;
        }
        PsiElement target = psiElement;
        Navigatable data = BeansView.Companion.toNavigatable(target);
        if (data != null && data.canNavigate()) {
            data.navigate(true);
            return true;
        }
        BeansListItem selectedItem = (BeansListItem)this.beansList.getSelectedValue();
        if (selectedItem instanceof ModuleItem) {
            this.applyFilter("module:", CollectionsKt.listOf((Object)((ModuleItem)selectedItem).getModule().getName()));
            this.searchTextField.requestFocus();
            return true;
        }
        return false;
    }

    private final void installEditOnDoubleClick(JBList<?> list) {
        new DoubleClickListener(this){
            final /* synthetic */ BeansView this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean onDoubleClick(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return BeansView.access$performEditAction(this.this$0);
            }
        }.installOn((Component)list);
    }

    /*
     * WARNING - void declaration
     */
    public void uiDataSnapshot(@NotNull DataSink sink) {
        void $this$filterIsInstanceTo$iv$iv;
        BeansListItem beansListItem;
        BeansListItem beansListItem2;
        BeansListItem beansListItem3;
        Object p02;
        DataSink dataSink;
        DataKey dataKey;
        List<BeansListItem> selection;
        block4: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            super.uiDataSnapshot(sink);
            selection = this.getSelectedBeansItems();
            DataKey dataKey2 = SearchTextField.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"KEY");
            sink.set(dataKey2, (Object)this.searchTextField);
            DataKey dataKey3 = CommonDataKeys.PROJECT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"PROJECT");
            sink.set(dataKey3, (Object)this.project);
            DataKey dataKey4 = PlatformCoreDataKeys.MODULE;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"MODULE");
            Iterable iterable = selection;
            dataKey = dataKey4;
            dataSink = sink;
            for (Object p02 : iterable) {
                boolean bl = false;
                if ((p02 = BeansListModelsKt.getModule((BeansListItem)p02)) == null) continue;
                beansListItem3 = p02;
                break block4;
            }
            beansListItem3 = null;
        }
        if ((beansListItem2 = (beansListItem = beansListItem3)) == null) {
            Object object = this.beansCursor;
            beansListItem2 = object != null && (object = ((BeansCursor)object).getSelectedModules()) != null ? (Module)CollectionsKt.firstOrNull((List)object) : null;
        }
        dataSink.set(dataKey, beansListItem2);
        DataKey dataKey5 = PlatformCoreDataKeys.SELECTED_ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"SELECTED_ITEM");
        sink.set(dataKey5, CollectionsKt.firstOrNull(selection));
        DataKey dataKey6 = PlatformCoreDataKeys.SELECTED_ITEMS;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey6, (String)"SELECTED_ITEMS");
        Collection $this$toTypedArray$iv = selection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        sink.set(dataKey6, (Object)thisCollection$iv.toArray(new BeansListItem[0]));
        Iterable $this$filterIsInstance$iv = selection;
        boolean $i$f$filterIsInstance = false;
        p02 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FlatBeanItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selectedItems = (List)destination$iv$iv;
        FlatBeanItem flatBeanItem = (FlatBeanItem)CollectionsKt.firstOrNull((List)selectedItems);
        if (flatBeanItem == null) {
            return;
        }
        FlatBeanItem single = flatBeanItem;
        single.uiDataSnapshot(sink);
        DataKey dataKey7 = CommonDataKeys.NAVIGATABLE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey7, (String)"NAVIGATABLE_ARRAY");
        sink.lazy(dataKey7, () -> BeansView.uiDataSnapshot$lambda$0(selectedItems));
    }

    /*
     * WARNING - void declaration
     */
    private final List<BeansListItem> getSelectedBeansItems() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.beansList.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BeansListItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BeansListItem p0 = (BeansListItem)element$iv$iv;
            boolean bl2 = false;
            if (this.getTarget(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final BeansListItem getTarget(BeansListItem it) {
        BeansListItem beansListItem = it;
        return beansListItem instanceof FlatBeanItem ? it : (beansListItem instanceof ModuleItem ? it : null);
    }

    private final void showSearchPopup() {
        CharSequence charSequence = this.searchTextField.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.searchPopupController.showAttributesPopup(null, 0);
        } else {
            this.searchPopupController.handleShowPopup();
        }
    }

    private final void applyFilter(String attribute, Collection<String> values) {
        block18: {
            BeansSearchQueryParser queryParser;
            block17: {
                this.forgetSelection();
                BeansCursor beansCursor = this.beansCursor;
                BeansSearchQueryParser beansSearchQueryParser = queryParser = beansCursor != null ? beansCursor.getQueryParser() : null;
                if (queryParser != null) break block17;
                this.searchTextField.setText(attribute + " " + BeansView.Companion.composeFilterValue(values));
                break block18;
            }
            Collection frameworks = queryParser.getFrameworks();
            Collection modules = queryParser.getModules();
            Collection types = queryParser.getTypes();
            switch (attribute) {
                case "module:": {
                    modules = values;
                    break;
                }
                case "type:": {
                    types = values;
                    break;
                }
                case "framework:": {
                    frameworks = values;
                    if (!(!frameworks.isEmpty())) break;
                    Object object = this.beansCursor;
                    Set chosenTypes = object != null && (object = ((BeansCursor)object).getQueryParser()) != null ? ((BeansSearchQueryParser)((Object)object)).getTypes() : null;
                    Sequence availableStereotypes = SequencesKt.map(BeansViewManagerKt.getAvailableBeanStereotypes(this.project, CollectionsKt.toList((Iterable)frameworks)), BeansView::applyFilter$lambda$0);
                    Set set = chosenTypes;
                    types = set != null && (set = CollectionsKt.intersect((Iterable)set, (Iterable)SequencesKt.toSet((Sequence)availableStereotypes))) != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
                }
            }
            StringBuilder queryBuilder = new StringBuilder();
            if (!modules.isEmpty()) {
                queryBuilder.append("module:").append(" ").append(BeansView.Companion.composeFilterValue(modules)).append(" ");
            }
            if (!types.isEmpty()) {
                queryBuilder.append("type:").append(" ").append(BeansView.Companion.composeFilterValue(types)).append(" ");
            }
            if (!frameworks.isEmpty()) {
                queryBuilder.append("framework:").append(" ").append(BeansView.Companion.composeFilterValue(frameworks)).append(" ");
            }
            for (String word : queryParser.getWords()) {
                queryBuilder.append(word).append(" ");
            }
            String string = queryBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.searchTextField.setText(((Object)StringsKt.trim((CharSequence)string)).toString());
            this.searchTextField.addCurrentTextToHistory();
        }
        BeansView.loadInitial$default(this, false, 1, null);
    }

    public final void showBeans(@Nullable String module, @Nullable String framework, @Nullable String filter) {
        StringBuilder stringBuilder;
        StringBuilder $this$showBeans_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = (String[])module;
        if (!(stringArray == null || StringsKt.isBlank((CharSequence)stringArray))) {
            stringArray = new String[]{"module:", " ", module, " "};
            StringsKt.append((StringBuilder)$this$showBeans_u24lambda_u240, (String[])stringArray);
        }
        if (!((stringArray = (CharSequence)framework) == null || StringsKt.isBlank((CharSequence)stringArray)) && !BeansViewService.Companion.getInstance(this.project).isExclusive()) {
            stringArray = new String[]{"framework:", " ", framework, " "};
            StringsKt.append((StringBuilder)$this$showBeans_u24lambda_u240, (String[])stringArray);
        }
        if (!((stringArray = (CharSequence)filter) == null || StringsKt.isBlank((CharSequence)stringArray))) {
            $this$showBeans_u24lambda_u240.append(filter);
        }
        String searchedValue = stringBuilder.toString();
        this.showBeans(searchedValue);
    }

    public final void showBeans(@NlsSafe @NotNull String searchedValue) {
        Intrinsics.checkNotNullParameter((Object)searchedValue, (String)"searchedValue");
        this.searchTextField.setText(searchedValue);
        BeansView.loadInitial$default(this, false, 1, null);
        this.searchTextField.requestFocus();
    }

    private static final void _init_$lambda$0(BeansView this$0, ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this$0.updateSidePanel();
    }

    private static final void initGlobalListeners$lambda$0(BeansView this$0) {
        long newModificationCount;
        BeansCursor cursor = this$0.beansCursor;
        if (cursor != null && this$0.beansModificationCount == (newModificationCount = cursor.getModificationCount())) {
            LOG.debug("No related PSI changes, will not reload beans");
            return;
        }
        this$0.psiChangeUpdateQueue.queue(Update.Companion.create((Object)this$0, () -> BeansView.initGlobalListeners$lambda$0$0(this$0)));
    }

    private static final void initGlobalListeners$lambda$0$0(BeansView this$0) {
        this$0.requestInitialLoad(true);
    }

    private static final void initGlobalListeners$lambda$1(BeansView this$0) {
        this$0.initSidePanelTabs();
    }

    private static final void requestInitialLoad$lambda$0(BeansView this$0) {
        this$0.updateOnShow = false;
        this$0.updateItemsOnChange();
    }

    private static final void requestInitialLoad$lambda$1(BeansView this$0, boolean $onChanges) {
        this$0.loadInitial($onChanges);
    }

    private static final void updateItemsOnChange$lambda$0(BeansView this$0) {
        BeansView.requestInitialLoad$default(this$0, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Navigatable[] uiDataSnapshot$lambda$0(List $selectedItems) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = BeansView.Companion.getValidItems($selectedItems);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FlatBeanItem flatBeanItem = (FlatBeanItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BeansView.Companion.toNavigatable(it.getNavigationElement()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Navigatable[0]);
    }

    private static final String applyFilter$lambda$0(BeanStereotype it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQueryTag();
    }

    public static final /* synthetic */ FilterField access$createModuleFilter(BeansView $this) {
        return $this.createModuleFilter();
    }

    public static final /* synthetic */ FilterField access$createTypeFilter(BeansView $this) {
        return $this.createTypeFilter();
    }

    public static final /* synthetic */ FilterField access$createFrameworkFilter(BeansView $this) {
        return $this.createFrameworkFilter();
    }

    public static final /* synthetic */ Project access$getProject$p(BeansView $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$applyFilter(BeansView $this, String attribute, Collection values) {
        $this.applyFilter(attribute, values);
    }

    public static final /* synthetic */ DocumentationComponent access$getDocComponent$p(BeansView $this) {
        return $this.docComponent;
    }

    public static final /* synthetic */ void access$setDocComponent$p(BeansView $this, DocumentationComponent documentationComponent) {
        $this.docComponent = documentationComponent;
    }

    public static final /* synthetic */ JBPanelWithEmptyText access$getDocSidePanel$p(BeansView $this) {
        return $this.docSidePanel;
    }

    public static final /* synthetic */ boolean access$performEditAction(BeansView $this) {
        return $this.performEditAction();
    }

    public static final /* synthetic */ void access$requestInitialLoad(BeansView $this, boolean onChanges) {
        $this.requestInitialLoad(onChanges);
    }

    public static final /* synthetic */ void access$forgetData(BeansView $this) {
        $this.forgetData();
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(BeansView $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ void access$setSidePanelVisibility(BeansView $this) {
        $this.setSidePanelVisibility();
    }

    public static final /* synthetic */ void access$initSidePanelTabs(BeansView $this) {
        $this.initSidePanelTabs();
    }

    public static final /* synthetic */ void access$setSplitOrientation(BeansView $this) {
        $this.setSplitOrientation();
    }

    public static final /* synthetic */ BeansListRenderer access$getListRenderer$p(BeansView $this) {
        return $this.listRenderer;
    }

    public static final /* synthetic */ void access$appendToList(BeansView $this, BeansCursor cursor, List listItems) {
        $this.appendToList(cursor, listItems);
    }

    public static final /* synthetic */ void access$restoreSelection(BeansView $this, int[] oldSelectedIndices, BeansSidePanel oldSelectedSidePanel) {
        $this.restoreSelection(oldSelectedIndices, oldSelectedSidePanel);
    }

    public static final /* synthetic */ void access$forgetSelection(BeansView $this) {
        $this.forgetSelection();
    }

    public static final /* synthetic */ void access$showSearchPopup(BeansView $this) {
        $this.showSearchPopup();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BeansView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        SIDE_PANEL_EP_NAME = ExtensionPointName.Companion.create("com.intellij.microservices.jvm.beansSidePanelProvider");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0018J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0003J\u0016\u0010 \u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0002J,\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"0\u001f2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"0\u001fH\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/microservices/jvm/beans/BeansView$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TOOL_WINDOW_ID", "", "FETCH_PAGE_SIZE", "", "MAX_FILTER_VALUE_LENGTH", "BEANS_CONTEXT_MENU_PLACE", "BEANS_FILTER_TOOLBAR_PLACE", "SIDE_PANEL_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/microservices/jvm/beans/BeansSidePanelProvider;", "getSelectedView", "Lcom/intellij/microservices/jvm/beans/BeansView;", "actionContextComponent", "Ljava/awt/Component;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isViewOnScreen", "", "isViewOnScreen$intellij_microservices_jvm", "getCustomContextMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "displayableFilterText", "values", "", "composeFilterValue", "getValidItems", "Lcom/intellij/microservices/jvm/beans/FlatBeanItem;", "selectedItems", "toNavigatable", "Lcom/intellij/pom/Navigatable;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.microservices.jvm"})
    @SourceDebugExtension(value={"SMAP\nBeansView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeansView.kt\ncom/intellij/microservices/jvm/beans/BeansView$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1114:1\n774#2:1115\n865#2,2:1116\n*S KotlinDebug\n*F\n+ 1 BeansView.kt\ncom/intellij/microservices/jvm/beans/BeansView$Companion\n*L\n1086#1:1115\n1086#1:1116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BeansView getSelectedView(Component actionContextComponent) {
            Component contextComponent;
            for (contextComponent = actionContextComponent; contextComponent != null && !(contextComponent instanceof BeansView); contextComponent = (Component)contextComponent.getParent()) {
            }
            return (BeansView)((Object)contextComponent);
        }

        private final BeansView getSelectedView(AnActionEvent e) {
            return this.getSelectedView((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
        }

        public final boolean isViewOnScreen$intellij_microservices_jvm(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.getSelectedView(e) != null;
        }

        private final AnAction[] getCustomContextMenuActions() {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("BeansActions.ContextMenu");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            DefaultActionGroup group = (DefaultActionGroup)anAction;
            AnAction[] anActionArray = group.getChildren(actionManager);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
            return anActionArray;
        }

        @NlsSafe
        private final String displayableFilterText(Collection<String> values) {
            String text = values.size() == 1 ? (String)CollectionsKt.first((Iterable)values) : CollectionsKt.joinToString$default((Iterable)values, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
            String string = StringUtil.shortenTextWithEllipsis((String)text, (int)30, (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }

        private final String composeFilterValue(Collection<String> values) {
            return CollectionsKt.joinToString$default((Iterable)values, (CharSequence)",", null, null, (int)0, null, Companion::composeFilterValue$lambda$0, (int)30, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<FlatBeanItem<?, ?>> getValidItems(Collection<? extends FlatBeanItem<?, ?>> selectedItems) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = selectedItems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FlatBeanItem p0 = (FlatBeanItem)element$iv$iv;
                boolean bl = false;
                if (!p0.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final Navigatable toNavigatable(PsiElement psiElement) {
            if (psiElement == null) {
                return null;
            }
            PsiElement navigationElement = psiElement.getNavigationElement();
            if (navigationElement instanceof Navigatable) {
                return (Navigatable)navigationElement;
            }
            return new Navigatable(psiElement){
                final /* synthetic */ PsiElement $psiElement;
                {
                    this.$psiElement = $psiElement;
                }

                public void navigate(boolean requestFocus) {
                    PsiNavigateUtil.navigate((PsiElement)this.$psiElement, (boolean)requestFocus);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }

        private static final CharSequence composeFilterValue$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return SearchQueryParserBase.Companion.wrapAttribute(it);
        }

        public static final /* synthetic */ String access$displayableFilterText(Companion $this, Collection values) {
            return $this.displayableFilterText(values);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

