/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.hints;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.hints.defaultHint.DefaultHintUtilsKt;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HintReferenceBase
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @Nullable
    String defaultValue;

    protected HintReferenceBase(@NotNull PsiElement element, TextRange rangeInElement) {
        if (element == null) {
            HintReferenceBase.$$$reportNull$$$0(0);
        }
        super(element, rangeInElement);
        this.defaultValue = null;
    }

    @Nullable
    protected abstract PsiElement doResolve();

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return null;
    }

    @Nullable
    public final PsiElement resolve() {
        String value = this.getValue();
        if (StringUtil.contains((CharSequence)value, (CharSequence)"${")) {
            return this.getElement();
        }
        return this.doResolve();
    }

    public final Object @NotNull [] getVariants() {
        Object[] hintVariants = this.getHintVariants();
        Object[] objectArray = this.defaultValue != null ? DefaultHintUtilsKt.getPatchedVarianceWithDefault(hintVariants, this.defaultValue) : hintVariants;
        if (objectArray == null) {
            HintReferenceBase.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public Object @NotNull [] getHintVariants() {
        if (EMPTY_ARRAY == null) {
            HintReferenceBase.$$$reportNull$$$0(2);
        }
        return EMPTY_ARRAY;
    }

    public void setDefaultValue(@NotNull String defaultValue) {
        if (defaultValue == null) {
            HintReferenceBase.$$$reportNull$$$0(3);
        }
        this.defaultValue = defaultValue;
    }

    @NotNull
    @NonNls
    public String getUnresolvedMessagePattern() {
        String string = MicroservicesConfigBundle.message("config.unresolved.value", new Object[0]);
        if (string == null) {
            HintReferenceBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/hints/HintReferenceBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/hints/HintReferenceBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

