/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.oas.v3;

import com.intellij.jam.JamBaseElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamBooleanAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SwOperation
extends JamBaseElement<PsiMethod> {
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = JamService.ANNO_META_KEY.subKey("SwOperation", new SemKey[0]);
    private static final SemKey<SwOperation> JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SwOperation", new SemKey[0]);
    public static final JamMethodMeta<SwOperation> META = new JamMethodMeta(null, SwOperation::new, JAM_KEY);
    private static final JamStringAttributeMeta.Single<String> SUMMARY_ATTR_META = JamAttributeMeta.singleString((String)"summary");
    private static final JamStringAttributeMeta.Single<String> DESCRIPTION_ATTR_META = JamAttributeMeta.singleString((String)"description");
    private static final JamStringAttributeMeta.Single<String> OPERATION_ID_ATTR_META = JamAttributeMeta.singleString((String)"operationId");
    private static final JamBooleanAttributeMeta DEPRECATED_ATTR_META = JamAttributeMeta.singleBoolean((String)"deprecated", (boolean)false);
    private static final JamBooleanAttributeMeta HIDDEN_ATTR_META = JamAttributeMeta.singleBoolean((String)"hidden", (boolean)false);
    private static final JamStringAttributeMeta.Collection<String> TAGS_ATTR_META = JamAttributeMeta.collectionString((String)"tags");
    private static final JamAnnotationArchetype ANNO_ARCHETYPE = new JamAnnotationArchetype().addAttribute(SUMMARY_ATTR_META).addAttribute(DESCRIPTION_ATTR_META);
    private static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("io.swagger.v3.oas.annotations.Operation", ANNO_ARCHETYPE);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    protected SwOperation(PsiElementRef<?> ref) {
        super(ref);
        PsiMethod psiMethod = (PsiMethod)Objects.requireNonNull(ref.getPsiElement());
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiMethod);
    }

    @NotNull
    public String getSummary() {
        String summary = SUMMARY_ATTR_META.getJam(this.myPsiAnnotation).getStringValue();
        String string = StringUtil.defaultIfEmpty((String)summary, (String)"");
        if (string == null) {
            SwOperation.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String description = DESCRIPTION_ATTR_META.getJam(this.myPsiAnnotation).getStringValue();
        String string = StringUtil.defaultIfEmpty((String)description, (String)"");
        if (string == null) {
            SwOperation.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getOperationId() {
        String operationId = OPERATION_ID_ATTR_META.getJam(this.myPsiAnnotation).getStringValue();
        String string = StringUtil.defaultIfEmpty((String)operationId, (String)"");
        if (string == null) {
            SwOperation.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<String> getTags() {
        List<String> list = TAGS_ATTR_META.getJam(this.myPsiAnnotation).stream().map(attribute -> attribute.getStringValue()).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        if (list == null) {
            SwOperation.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean getDeprecated() {
        return DEPRECATED_ATTR_META.getJam(this.myPsiAnnotation).getValue();
    }

    public boolean getHidden() {
        return HIDDEN_ATTR_META.getJam(this.myPsiAnnotation).getValue();
    }

    static {
        META.addAnnotation(ANNO_META);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/microservices/jvm/oas/v3/SwOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

