/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssImportImpl
extends CssStubElement<CssImportStub>
implements CssImport {
    public CssImportImpl(@NotNull CssImportStub stub, @NotNull IElementType nodeType) {
        if (stub == null) {
            CssImportImpl.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssImportImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssImportImpl(@NotNull ASTNode node) {
        if (node == null) {
            CssImportImpl.$$$reportNull$$$0(2);
        }
        super(node);
    }

    public PsiElement @NotNull [] getUriElements() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssString.class));
        List uris = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssUriImpl.class);
        for (CssUriImpl uri : uris) {
            PsiElement valueElement = uri.getValueElement();
            if (valueElement == null || valueElement instanceof PsiErrorElement) continue;
            result.add(valueElement);
        }
        PsiElement[] psiElementArray = result.isEmpty() ? PsiElement.EMPTY_ARRAY : result.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            CssImportImpl.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Nullable
    public CssMediumList getMediumList() {
        return (CssMediumList)PsiTreeUtil.getChildOfType((PsiElement)this, CssMediumList.class);
    }

    public boolean isScreen() {
        return this.getMediaTypes().contains(CssMediaType.SCREEN);
    }

    @NotNull
    public Set<CssMediaType> getMediaTypes() {
        CssImportStub stub = (CssImportStub)this.getStub();
        if (stub != null) {
            Set<CssMediaType> set = stub.getMediaTypes();
            if (set == null) {
                CssImportImpl.$$$reportNull$$$0(4);
            }
            return set;
        }
        CssMediumList mediumList = this.getMediumList();
        Set<CssMediaType> set = mediumList != null ? mediumList.getTypes() : Collections.singleton(CssMediaType.SCREEN);
        if (set == null) {
            CssImportImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public CssAtRule getSupports() {
        return (CssAtRule)ObjectUtils.tryCast((Object)this.findChildByType(CssElementTypes.CSS_SUPPORTS), CssAtRule.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssImportImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssImport(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssImportImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssImportImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUriElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

