/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sourceToSink;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.sourceToSink.MarkAsSafeFix;
import com.intellij.codeInspection.sourceToSink.TaintNode;
import com.intellij.codeInspection.sourceToSink.TaintValue;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public final class PropagateAnnotationPanel
extends JPanel
implements Disposable {
    private final Tree myTree;
    @NotNull
    private final Project myProject;
    private final List<TaintNode> myRoots;
    private final PropagateTreeListener myTreeSelectionListener;
    @NotNull
    private final @NotNull Consumer<? super Collection<@NotNull TaintNode>> myCallback;
    private Content myContent;
    private final boolean mySupportRefactoring;

    PropagateAnnotationPanel(@NotNull Project project, @NotNull List<TaintNode> roots, @NotNull @NotNull Consumer<? super Collection<@NotNull TaintNode>> callback, boolean supportRefactoring) {
        if (project == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myTree = PropagateTree.create(this, roots);
        this.myRoots = roots;
        this.myProject = project;
        this.myCallback = callback;
        this.mySupportRefactoring = supportRefactoring;
        Editor usageEditor = this.createEditor();
        Editor memberEditor = this.createEditor();
        this.myTreeSelectionListener = new PropagateTreeListener(usageEditor, memberEditor);
        this.myTree.getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        Splitter splitter = new Splitter(false, 0.6f);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        splitter.setFirstComponent((JComponent)scrollPane);
        JPanel panel = new JPanel(new BorderLayout());
        JComponent callSitesViewer = PropagateAnnotationPanel.createCallSitesViewer(usageEditor, memberEditor);
        panel.add(callSitesViewer);
        this.myTreeSelectionListener.updateEditorTexts(roots.getFirst());
        JPanel toolbar = this.createToolbar();
        panel.add((Component)toolbar, "North");
        splitter.setSecondComponent((JComponent)panel);
        this.add((Component)splitter, "Center");
        this.addTreeActions(this.myTree, roots);
    }

    public void setContent(@NotNull Content content) {
        if (content == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(3);
        }
        this.myContent = content;
        Disposer.register((Disposable)content, (Disposable)this);
    }

    @NotNull
    private JPanel createToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        if (this.mySupportRefactoring) {
            String annotateText = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.propagate.safe.toolwindow.annotate", new Object[0]);
            JButton annotateButton = new JButton(annotateText);
            annotateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolWindow toolWindow = ProblemsView.getToolWindow((Project)PropagateAnnotationPanel.this.myProject);
                    if (toolWindow == null) {
                        return;
                    }
                    ContentManager contentManager = toolWindow.getContentManager();
                    contentManager.removeContent(PropagateAnnotationPanel.this.myContent, true);
                    PropagateAnnotationPanel.this.myContent.release();
                    for (TaintNode root : PropagateAnnotationPanel.this.myRoots) {
                        Set<TaintNode> toAnnotate = PropagateAnnotationPanel.getSelectedElements(root, new HashSet<TaintNode>());
                        if (toAnnotate == null) continue;
                        PropagateAnnotationPanel.this.myCallback.accept(toAnnotate);
                    }
                }
            });
            panel.add((Component)annotateButton, "West");
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor editor = editorFactory.createViewer(document, this.myProject);
        if (editor == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(5);
        }
        return editor;
    }

    public void dispose() {
        if (this.myTree != null) {
            Disposer.dispose((Disposable)this.myTreeSelectionListener);
            this.myTree.removeTreeSelectionListener((TreeSelectionListener)this.myTreeSelectionListener);
        }
    }

    @Nullable
    static Set<TaintNode> getSelectedElements(@NotNull TaintNode taintNode, @NotNull Set<TaintNode> nodes) {
        if (taintNode == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(6);
        }
        if (nodes == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(7);
        }
        if (taintNode.getPsiElement() == null) {
            return null;
        }
        if (taintNode.isExcluded()) {
            return nodes;
        }
        nodes.add(taintNode);
        List<TaintNode> children = taintNode.calcChildren();
        if (children == null) {
            return nodes;
        }
        for (TaintNode child : children) {
            if (PropagateAnnotationPanel.getSelectedElements(child, nodes) != null) continue;
            return null;
        }
        return nodes;
    }

    @NotNull
    private static JComponent createCallSitesViewer(@NotNull Editor usageEditor, @NotNull Editor memberEditor) {
        if (usageEditor == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(8);
        }
        if (memberEditor == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(9);
        }
        Splitter splitter = new Splitter(true);
        JComponent usageComponent = PropagateAnnotationPanel.getEditorComponent(usageEditor, JvmAnalysisBundle.message("propagated.from", new Object[0]));
        splitter.setFirstComponent(usageComponent);
        JComponent memberComponent = PropagateAnnotationPanel.getEditorComponent(memberEditor, JvmAnalysisBundle.message("propagated.to", new Object[0]));
        splitter.setSecondComponent(memberComponent);
        splitter.setBorder((Border)IdeBorderFactory.createRoundedBorder());
        Splitter splitter2 = splitter;
        if (splitter2 == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(10);
        }
        return splitter2;
    }

    @NotNull
    private static JComponent getEditorComponent(@NotNull Editor editor, @NlsContexts.BorderTitle String title) {
        if (editor == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(11);
        }
        EditorSettings memberEditorSettings = editor.getSettings();
        memberEditorSettings.setGutterIconsShown(false);
        memberEditorSettings.setLineNumbersShown(false);
        JComponent memberComponent = editor.getComponent();
        IdeaTitledBorder memberTitleBorder = IdeBorderFactory.createTitledBorder((String)title, (boolean)false);
        memberTitleBorder.setShowLine(false);
        memberComponent.setBorder((Border)memberTitleBorder);
        JComponent jComponent = memberComponent;
        if (jComponent == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    private void addTreeActions(@NotNull Tree tree, @NotNull List<TaintNode> roots) {
        if (tree == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(13);
        }
        if (roots == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(14);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (TaintNode root : roots) {
            if (root.myTaintValue == TaintValue.TAINTED || !this.mySupportRefactoring) continue;
            actionGroup.addAll(PropagateAnnotationPanel.createIncludeExcludeActions(tree));
        }
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        PopupHandler.installPopupMenu((JComponent)tree, (ActionGroup)actionGroup, (String)"PropagateAnnotationPanelPopup");
    }

    @Contract(value="_ -> new")
    private static AnAction @NotNull [] createIncludeExcludeActions(final @NotNull Tree tree) {
        if (tree == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(15);
        }
        class IncludeExcludeAction
        extends AnAction {
            private final boolean myExclude;

            private IncludeExcludeAction(@NlsActions.ActionText String name, boolean exclude) {
                super(name);
                this.myExclude = exclude;
            }

            public void update(@NotNull AnActionEvent e) {
                TreePath[] selectionPaths;
                if (e == null) {
                    IncludeExcludeAction.$$$reportNull$$$0(0);
                }
                if ((selectionPaths = tree.getSelectionPaths()) == null || selectionPaths.length == 0) {
                    return;
                }
                TaintNode[] roots = (TaintNode[])tree.getSelectedNodes(TaintNode.class, null);
                ArrayDeque<TaintNode> nodes = new ArrayDeque<TaintNode>(Arrays.asList(roots));
                boolean enable = false;
                while (!nodes.isEmpty()) {
                    TaintNode node = (TaintNode)((Object)nodes.poll());
                    if (node.myTaintValue == TaintValue.TAINTED) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                    enable |= node.isExcluded() != this.myExclude;
                    List<TaintNode> children = node.myCachedChildren;
                    if (children == null) continue;
                    nodes.addAll(children);
                }
                e.getPresentation().setEnabled(enable);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    IncludeExcludeAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            private static Stream<TaintNode> nodes(TaintNode[] roots) {
                return StreamEx.of((Object[])roots).flatMap(root -> StreamEx.ofTree((Object)root, n -> n.myCachedChildren == null ? null : StreamEx.of(n.myCachedChildren)));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    IncludeExcludeAction.$$$reportNull$$$0(2);
                }
                TaintNode[] roots = (TaintNode[])tree.getSelectedNodes(TaintNode.class, null);
                IncludeExcludeAction.nodes(roots).forEach(n -> {
                    n.setExcluded(this.myExclude);
                    n.update();
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$1IncludeExcludeAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$1IncludeExcludeAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        AnAction[] anActionArray = new AnAction[]{new IncludeExcludeAction(JavaRefactoringBundle.message((String)"type.migration.include.action.text", (Object[])new Object[0]), false), new IncludeExcludeAction(JavaRefactoringBundle.message((String)"type.migration.exclude.action.text", (Object[])new Object[0]), true)};
        if (anActionArray == null) {
            PropagateAnnotationPanel.$$$reportNull$$$0(16);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taintNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberEditor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallSitesViewer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createIncludeExcludeActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCallSitesViewer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTreeActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createIncludeExcludeActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 12, 16 -> new IllegalStateException(string);
        };
    }

    private static final class PropagateTree
    extends Tree
    implements UiDataProvider {
        private PropagateTree(TreeModel treeModel) {
            super(treeModel);
            this.getSelectionModel().setSelectionMode(1);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                PropagateTree.$$$reportNull$$$0(0);
            }
            TaintNode[] selectedNodes = (TaintNode[])this.getSelectedNodes(TaintNode.class, null);
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> selectedNodes.length == 1 ? selectedNodes[0].getRef() : null);
        }

        @Contract(value="_, _ -> new")
        @NotNull
        private static PropagateTree create(@NotNull Disposable parent, final @NotNull List<TaintNode> roots) {
            if (parent == null) {
                PropagateTree.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                PropagateTree.$$$reportNull$$$0(2);
            }
            TaintNode rootWrapper = new TaintNode(null, null, null, null, true){

                @Override
                public List<TaintNode> calcChildren() {
                    return roots;
                }
            };
            PropagateTreeModel propagateTreeModel = new PropagateTreeModel(rootWrapper);
            AsyncTreeModel treeModel = new AsyncTreeModel((TreeModel)((Object)propagateTreeModel), parent);
            PropagateTree tree = new PropagateTree((TreeModel)treeModel);
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            TreeUtil.installActions((JTree)((Object)tree));
            EditSourceOnDoubleClickHandler.install((JTree)((Object)tree));
            PropagateTree propagateTree = tree;
            if (propagateTree == null) {
                PropagateTree.$$$reportNull$$$0(3);
            }
            return propagateTree;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTree";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private static class PropagateTreeModel
        extends BaseTreeModel<TaintNode>
        implements InvokerSupplier {
            private final TaintNode myRootWrapper;

            private PropagateTreeModel(TaintNode wrapper) {
                this.myRootWrapper = wrapper;
            }

            public List<? extends TaintNode> getChildren(Object object) {
                TaintNode node = (TaintNode)((Object)ObjectUtils.tryCast((Object)object, TaintNode.class));
                if (node == null) {
                    return Collections.emptyList();
                }
                return node.calcChildren();
            }

            public TaintNode getRoot() {
                return this.myRootWrapper;
            }

            @NotNull
            public Invoker getInvoker() {
                Invoker invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
                if (invoker == null) {
                    PropagateTreeModel.$$$reportNull$$$0(0);
                }
                return invoker;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTree$PropagateTreeModel", "getInvoker"));
            }
        }
    }

    private static final class PropagateTreeListener
    implements TreeSelectionListener,
    Disposable {
        private final ElementEditor myUsageEditor;
        private final ElementEditor myMemberEditor;
        private final SingleEdtTaskScheduler alarm;

        private PropagateTreeListener(@NotNull Editor usageEditor, @NotNull Editor memberEditor) {
            if (usageEditor == null) {
                PropagateTreeListener.$$$reportNull$$$0(0);
            }
            if (memberEditor == null) {
                PropagateTreeListener.$$$reportNull$$$0(1);
            }
            this.alarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
            this.myUsageEditor = new ElementEditor(usageEditor);
            this.myMemberEditor = new ElementEditor(memberEditor);
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            TreePath path;
            if (e == null) {
                PropagateTreeListener.$$$reportNull$$$0(2);
            }
            if ((path = e.getPath()) == null) {
                return;
            }
            TaintNode taintNode = (TaintNode)((Object)path.getLastPathComponent());
            this.alarm.cancelAndRequest(300L, () -> this.updateEditorTexts(taintNode));
        }

        void updateEditorTexts(@NotNull TaintNode taintNode) {
            PsiElement usageHighlight;
            if (taintNode == null) {
                PropagateTreeListener.$$$reportNull$$$0(3);
            }
            this.myUsageEditor.show(null, null);
            this.myMemberEditor.show(null, null);
            PsiElement usage = taintNode.getRef();
            if (usage == null) {
                return;
            }
            if ((usage = MarkAsSafeFix.getSourcePsi(usage)) == null) {
                return;
            }
            PsiElement parentPsi = PropagateTreeListener.getParentPsi(usage);
            if (parentPsi == null) {
                return;
            }
            PsiElement psiElement = usageHighlight = PsiTreeUtil.isAncestor((PsiElement)parentPsi, (PsiElement)usage, (boolean)true) ? usage : PropagateTreeListener.getIdentifier(parentPsi);
            if (usageHighlight == null) {
                return;
            }
            this.myUsageEditor.show(parentPsi, usageHighlight);
            PsiElement element = taintNode.getPsiElement();
            if (element == null) {
                return;
            }
            if ((element = MarkAsSafeFix.getSourcePsi(element)) == null) {
                return;
            }
            PsiElement elementHighlight = PropagateTreeListener.getIdentifier(element);
            if (elementHighlight == null) {
                return;
            }
            this.myMemberEditor.show(element, elementHighlight);
        }

        public void dispose() {
            this.alarm.dispose();
            Disposer.dispose((Disposable)this.myUsageEditor);
            Disposer.dispose((Disposable)this.myMemberEditor);
        }

        @Nullable
        private static PsiElement getIdentifier(@Nullable PsiElement element) {
            PsiNameIdentifierOwner namedElement = (PsiNameIdentifierOwner)ObjectUtils.tryCast((Object)element, PsiNameIdentifierOwner.class);
            if (namedElement == null) {
                return null;
            }
            return namedElement.getNameIdentifier();
        }

        @Nullable
        private static PsiElement getParentPsi(@NotNull PsiElement usage) {
            Class[] types;
            UElement uElement;
            if (usage == null) {
                PropagateTreeListener.$$$reportNull$$$0(4);
            }
            if ((uElement = UastContextKt.getUastParentOfTypes((PsiElement)usage, (Class[])(types = new Class[]{UMethod.class, UField.class}))) == null) {
                return null;
            }
            return uElement.getSourcePsi();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taintNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTreeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateEditorTexts";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParentPsi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class ElementEditor
        implements Disposable {
            private final Editor myEditor;
            private final Collection<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();

            private ElementEditor(Editor editor) {
                this.myEditor = editor;
            }

            public void show(@Nullable PsiElement element, @Nullable PsiElement toHighlight) {
                if (element == null || toHighlight == null) {
                    ApplicationManager.getApplication().runWriteAction(() -> this.myEditor.getDocument().setText((CharSequence)""));
                    return;
                }
                ElementModel model = ElementModel.create(element, toHighlight);
                if (model == null) {
                    return;
                }
                String text = model.myText;
                ApplicationManager.getApplication().runWriteAction(() -> this.myEditor.getDocument().setText((CharSequence)text));
                EditorHighlighter highlighter = ElementEditor.createHighlighter(element);
                ((EditorEx)this.myEditor).setHighlighter(highlighter);
                this.myEditor.getCaretModel().moveToOffset(model.myHighlightRange.getStartOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                this.highlightRange(element.getProject(), model.myHighlightRange);
            }

            private void highlightRange(@NotNull Project project, @NotNull TextRange range) {
                if (project == null) {
                    ElementEditor.$$$reportNull$$$0(0);
                }
                if (range == null) {
                    ElementEditor.$$$reportNull$$$0(1);
                }
                HighlightManager highlighter = HighlightManager.getInstance((Project)project);
                this.myHighlighters.forEach(h -> highlighter.removeSegmentHighlighter(this.myEditor, h));
                this.myHighlighters.clear();
                highlighter.addRangeHighlight(this.myEditor, range.getStartOffset(), range.getEndOffset(), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, false, this.myHighlighters);
            }

            public void dispose() {
                EditorFactory.getInstance().releaseEditor(this.myEditor);
            }

            @NotNull
            private static EditorHighlighter createHighlighter(@NotNull PsiElement element) {
                if (element == null) {
                    ElementEditor.$$$reportNull$$$0(2);
                }
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                Project project = element.getProject();
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((VirtualFile)virtualFile, (EditorColorsScheme)scheme, (Project)project);
                if (editorHighlighter == null) {
                    ElementEditor.$$$reportNull$$$0(3);
                }
                return editorHighlighter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTreeListener$ElementEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTreeListener$ElementEditor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createHighlighter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "highlightRange";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createHighlighter";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }

            private static class ElementModel {
                private final String myText;
                private final TextRange myHighlightRange;

                private ElementModel(@NotNull String text, @NotNull TextRange highlightRange) {
                    if (text == null) {
                        ElementModel.$$$reportNull$$$0(0);
                    }
                    if (highlightRange == null) {
                        ElementModel.$$$reportNull$$$0(1);
                    }
                    this.myText = text;
                    this.myHighlightRange = highlightRange;
                }

                @Nullable
                static ElementModel create(@NotNull PsiElement element, @NotNull PsiElement toHighlight) {
                    PsiFile file;
                    if (element == null) {
                        ElementModel.$$$reportNull$$$0(2);
                    }
                    if (toHighlight == null) {
                        ElementModel.$$$reportNull$$$0(3);
                    }
                    if ((file = element.getContainingFile()) == null) {
                        return null;
                    }
                    Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(file);
                    if (document == null) {
                        return null;
                    }
                    TextRange textRange = element.getTextRange();
                    if (textRange == null) {
                        return null;
                    }
                    int startLineNumber = document.getLineNumber(textRange.getStartOffset());
                    int start = document.getLineStartOffset(startLineNumber);
                    int end = document.getLineEndOffset(document.getLineNumber(textRange.getEndOffset()));
                    String[] lines = document.getText(TextRange.create((int)start, (int)end)).split("\n");
                    int indent = ElementModel.getIndent(lines);
                    TextRange highlightRange = toHighlight.getTextRange();
                    int highlightLine = document.getLineNumber(highlightRange.getStartOffset()) - startLineNumber;
                    int highlightIndent = 0;
                    for (int i = 0; i < lines.length; ++i) {
                        String line = lines[i];
                        if (line.isBlank()) continue;
                        if (i <= highlightLine) {
                            highlightIndent += indent;
                        }
                        lines[i] = line.substring(indent);
                    }
                    highlightRange = highlightRange.shiftLeft(start).shiftLeft(highlightIndent);
                    return new ElementModel(StringUtil.join((String[])lines, (String)"\n"), highlightRange);
                }

                private static int getIndent(String @NotNull [] lines) {
                    if (lines == null) {
                        ElementModel.$$$reportNull$$$0(4);
                    }
                    int prefix = Integer.MAX_VALUE;
                    for (int i = 0; i < lines.length && prefix != 0; ++i) {
                        int indent;
                        String line = lines[i];
                        for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
                        }
                        if (indent == line.length() || indent >= prefix) continue;
                        prefix = indent;
                    }
                    return prefix;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "highlightRange";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "toHighlight";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "lines";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateAnnotationPanel$PropagateTreeListener$ElementEditor$ElementModel";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "<init>";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "create";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getIndent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        }
    }
}

