/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.util;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSession;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.core.debug.util.CommonKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinKernelVersionsKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunModeKt;
import com.intellij.kotlin.jupyter.core.util.ActionsKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0002H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0000\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0018\u0010\u000b\u001a\u00020\u0006*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u0006*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\"\u0018\u0010\u0011\u001a\u00020\u0006*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\"\u0018\u0010\u0013\u001a\u00020\u0006*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\"\u0018\u0010\u0015\u001a\u00020\u0006*\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"debugSessionForFile", "Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSession;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getDebugSessionForFile", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSession;", "isSilentSessionAvailable", "", "(Lcom/intellij/openapi/actionSystem/DataContext;)Z", "isEvaluationPossible", "getNotebookXSessionOrNull", "Lcom/intellij/xdebugger/XDebugSession;", "notebookDebugFeaturesSupported", "Lcom/intellij/openapi/project/Project;", "getNotebookDebugFeaturesSupported", "(Lcom/intellij/openapi/project/Project;)Z", "shouldShowNotebookVariables", "getShouldShowNotebookVariables", "shouldFocusOnVariablesToolWindow", "getShouldFocusOnVariablesToolWindow", "hasNotebookDebugSession", "getHasNotebookDebugSession", "debugFeaturesSupported", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;", "getDebugFeaturesSupported", "(Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;)Z", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "intellij.kotlin.jupyter.core"})
public final class DebugSupportUtilsKt {
    @Nullable
    public static final KotlinNotebookDebugSession getDebugSessionForFile(@NotNull DataContext $this$debugSessionForFile) {
        Intrinsics.checkNotNullParameter((Object)$this$debugSessionForFile, (String)"<this>");
        BackedNotebookVirtualFile notebookFile = ActionsKt.getKotlinNotebookVirtualFile($this$debugSessionForFile);
        if (notebookFile == null) {
            return null;
        }
        Object object = CommonDataKeys.PROJECT.getData($this$debugSessionForFile);
        Intrinsics.checkNotNull((Object)object);
        Project project = (Project)object;
        return KotlinNotebookDebugSessionManager.Companion.getForFile(project, notebookFile);
    }

    public static final boolean isSilentSessionAvailable(@NotNull DataContext $this$isSilentSessionAvailable) {
        Intrinsics.checkNotNullParameter((Object)$this$isSilentSessionAvailable, (String)"<this>");
        KotlinNotebookDebugSession kotlinNotebookDebugSession = DebugSupportUtilsKt.getDebugSessionForFile($this$isSilentSessionAvailable);
        return kotlinNotebookDebugSession != null ? kotlinNotebookDebugSession.isLiveSession() : false;
    }

    public static final boolean isEvaluationPossible(@NotNull DataContext $this$isEvaluationPossible) {
        Intrinsics.checkNotNullParameter((Object)$this$isEvaluationPossible, (String)"<this>");
        KotlinNotebookDebugSession kotlinNotebookDebugSession = DebugSupportUtilsKt.getDebugSessionForFile($this$isEvaluationPossible);
        return (kotlinNotebookDebugSession != null ? kotlinNotebookDebugSession.getEvaluationContext() : null) != null;
    }

    @Nullable
    public static final XDebugSession getNotebookXSessionOrNull(@NotNull DataContext $this$getNotebookXSessionOrNull) {
        KotlinNotebookDebugSession debugSession;
        Intrinsics.checkNotNullParameter((Object)$this$getNotebookXSessionOrNull, (String)"<this>");
        KotlinNotebookDebugSession kotlinNotebookDebugSession = debugSession = DebugSupportUtilsKt.getDebugSessionForFile($this$getNotebookXSessionOrNull);
        return kotlinNotebookDebugSession != null ? kotlinNotebookDebugSession.getCurrentXSession() : null;
    }

    public static final boolean getNotebookDebugFeaturesSupported(@NotNull Project $this$notebookDebugFeaturesSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookDebugFeaturesSupported, (String)"<this>");
        return CommonKt.getDebugFeaturesEnabled() && KotlinKernelVersionsKt.isKernelVersionEnoughForInstrumentation($this$notebookDebugFeaturesSupported);
    }

    public static final boolean getShouldShowNotebookVariables(@NotNull Project $this$shouldShowNotebookVariables) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldShowNotebookVariables, (String)"<this>");
        return KotlinNotebookProjectOptionsProvider.Companion.getInstance($this$shouldShowNotebookVariables).getShouldShowNotebookVariables() && CommonKt.getDebugFeaturesEnabled();
    }

    public static final boolean getShouldFocusOnVariablesToolWindow(@NotNull Project $this$shouldFocusOnVariablesToolWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldFocusOnVariablesToolWindow, (String)"<this>");
        return DebugSupportUtilsKt.getShouldShowNotebookVariables($this$shouldFocusOnVariablesToolWindow) && KotlinNotebookProjectOptionsProvider.Companion.getInstance($this$shouldFocusOnVariablesToolWindow).getShouldFocusOnVariables();
    }

    public static final boolean getHasNotebookDebugSession(@NotNull Project $this$hasNotebookDebugSession) {
        Intrinsics.checkNotNullParameter((Object)$this$hasNotebookDebugSession, (String)"<this>");
        return CommonKt.getDebugFeaturesEnabled() && KotlinNotebookDebugSessionManager.Companion.getInstance($this$hasNotebookDebugSession).getHasAnyAttachedProcess();
    }

    public static final boolean getDebugFeaturesSupported(@NotNull KotlinNotebookSessionRunMode $this$debugFeaturesSupported) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$debugFeaturesSupported), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$debugFeaturesSupported.ordinal()]) {
            case 1 -> true;
            case 2, 3 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final boolean debugFeaturesSupported(@NotNull BackedNotebookVirtualFile $this$debugFeaturesSupported, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$debugFeaturesSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!DebugSupportUtilsKt.getNotebookDebugFeaturesSupported(project)) {
            return false;
        }
        return DebugSupportUtilsKt.getDebugFeaturesSupported(KotlinNotebookSessionRunModeKt.getSessionRunMode($this$debugFeaturesSupported, project));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinNotebookSessionRunMode.values().length];
            try {
                nArray[KotlinNotebookSessionRunMode.SEPARATE_PROCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinNotebookSessionRunMode.IDE_PROCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinNotebookSessionRunMode.ATTACHED_PROCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

