/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterConnectionActionExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.kotlin.jupyter.core.jupyter.actions.KotlinNotebookRestartNotification;
import com.intellij.kotlin.jupyter.core.jupyter.actions.KotlinNotebookRestartStatus;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Paint;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookRestartKernelActionUpdater;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "badgeDotProvider", "Lcom/intellij/ui/BadgeDotProvider;", "checkKernelAvailable", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookRestartKernelActionUpdater {
    @NotNull
    public static final KotlinNotebookRestartKernelActionUpdater INSTANCE = new KotlinNotebookRestartKernelActionUpdater();
    @NotNull
    private static final Logger LOG;

    private KotlinNotebookRestartKernelActionUpdater() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull AnActionEvent e) {
        void $this$update_u24lambda_u240;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (!(backedNotebookVirtualFile != null ? IsKotlinNotebookKt.isKotlinNotebook(backedNotebookVirtualFile) : false)) {
            return;
        }
        this.checkKernelAvailable(e);
        e.getPresentation().setIcon(JupyterCoreIcons.RestartKernel);
        if (!e.getPresentation().isEnabled()) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        FileEditor fileEditor2 = fileEditor;
        KotlinNotebookRestartStatus dependenciesStatus = KotlinNotebookRestartNotification.INSTANCE.getStatus(fileEditor2);
        if (Intrinsics.areEqual((Object)dependenciesStatus, (Object)KotlinNotebookRestartStatus.NotNeeded.INSTANCE)) {
            return;
        }
        if (!(dependenciesStatus instanceof KotlinNotebookRestartStatus.Needed)) {
            throw new NoWhenBranchMatchedException();
        }
        Presentation presentation = e.getPresentation();
        Icon icon = JupyterCoreIcons.RestartKernel;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RestartKernel");
        Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
        presentation.setIcon((Icon)new BadgeIcon(icon, (Paint)color, (BadgeShapeProvider)this.badgeDotProvider()));
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Presentation presentation2 = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u240.append(JupyterBundle.message((String)"action.JupyterRestartKernelAction.text", (Object[])new Object[0]));
        $this$update_u24lambda_u240.append("<br><br>");
        $this$update_u24lambda_u240.append(((KotlinNotebookRestartStatus.Needed)dependenciesStatus).getMessage());
        presentation2.setText(stringBuilder.toString());
    }

    private final BadgeDotProvider badgeDotProvider() {
        double defaultX = new BadgeDotProvider(0.0, 0.0, 0.0, 0.0, 15, null).getX();
        return new BadgeDotProvider(1.0 - defaultX, 0.0, 0.0, 0.0, 14, null);
    }

    private final void checkKernelAvailable(AnActionEvent e) {
        JupyterNotebookSession notebookSession = JupyterConnectionActionExtensionsKt.getNotebookSession((AnActionEvent)e);
        if (notebookSession == null) {
            e.getPresentation().setEnabledAndVisible(false);
        }
        e.getPresentation().setEnabled(true);
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
            e.getPresentation().setVisible(true);
        }
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

