/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.settings.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.projectModel.ExternalBuildSystemUtilsKt;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependencies;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependenciesPropertyKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettingsKt;
import com.intellij.kotlin.jupyter.core.settings.actions.KotlinNotebookDependenciesComboBoxActionKt;
import com.intellij.kotlin.jupyter.core.settings.actions.SessionShutdownPromptKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u0019\u001a\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createCustomComponentForResultViewToolbar", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "SelectDependenciesAction", "NoDependenciesAction", "AllProjectLibrariesAction", "SelectModuleAction", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookDependenciesComboBoxAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1563#2:175\n1634#2,3:176\n1#3:179\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction\n*L\n70#1:175\n70#1:176,3\n*E\n"})
public final class KotlinNotebookDependenciesComboBoxAction
extends DumbAwareAction
implements CustomComponentAction {
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return this.createCustomComponentForResultViewToolbar((AnAction)this, presentation, place);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        Component component = jComponent;
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ListPopup listPopup = jBPopupFactory.createActionGroupPopup(null, (ActionGroup)this.createPopupActionGroup(dataContext), e.getDataContext(), null, true, null, -1, arg_0 -> KotlinNotebookDependenciesComboBoxAction.actionPerformed$lambda$1(arg_0 -> KotlinNotebookDependenciesComboBoxAction.actionPerformed$lambda$0(e, arg_0), arg_0), null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        JBPopup popup = (JBPopup)listPopup;
        popup.showUnderneathOf(component);
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultActionGroup createPopupActionGroup(DataContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new NoDependenciesAction(KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.NoDependenciesAction.text", new Object[0])));
        actionGroup.add((AnAction)new AllProjectLibrariesAction(KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.AllProjectLibrariesAction.text", new Object[0])));
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return actionGroup;
        }
        Iterable<Module> modules = KotlinNotebookDependenciesPropertyKt.getSuitableModules(project);
        actionGroup.addSeparator();
        Iterable<Module> iterable = modules;
        DefaultActionGroup defaultActionGroup = actionGroup;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SelectModuleAction((Module)it));
        }
        defaultActionGroup.addAll((Collection)((List)destination$iv$iv));
        return actionGroup;
    }

    private final JComponent createCustomComponentForResultViewToolbar(AnAction action, Presentation presentation, String place) {
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(action, presentation, place, dimension){

            protected boolean shallPaintDownArrow() {
                return true;
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        return (JComponent)button2;
    }

    public void update(@NotNull AnActionEvent e) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        KotlinNotebookDependencies kotlinNotebookDependencies = KotlinNotebookDependenciesComboBoxActionKt.access$getCurrentDependencies(e);
        if (kotlinNotebookDependencies == null) {
            return;
        }
        KotlinNotebookDependencies currentDependencies = kotlinNotebookDependencies;
        KotlinNotebookDependencies kotlinNotebookDependencies2 = currentDependencies;
        if (Intrinsics.areEqual((Object)kotlinNotebookDependencies2, (Object)KotlinNotebookDependencies.AllLibraries.INSTANCE)) {
            pair2 = TuplesKt.to(null, (Object)KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.AllProjectLibrariesAction.text", new Object[0]));
        } else if (Intrinsics.areEqual((Object)kotlinNotebookDependencies2, (Object)KotlinNotebookDependencies.None.INSTANCE)) {
            pair2 = TuplesKt.to(null, (Object)KotlinNotebookBundle.message("action.KotlinNotebookDependenciesComboBoxAction.NoDependenciesAction.text", new Object[0]));
        } else if (kotlinNotebookDependencies2 instanceof KotlinNotebookDependencies.SingleModule) {
            Icon icon;
            Module module;
            Module module2;
            Project project = e.getProject();
            if (project != null) {
                Project it = project;
                boolean bl = false;
                module2 = KotlinNotebookDependenciesPropertyKt.findModule(currentDependencies, it);
            } else {
                module2 = null;
            }
            Module module3 = module = module2;
            if (module3 != null) {
                Module it = module3;
                boolean bl = false;
                icon = ModuleType.get((Module)it).getIcon();
            } else {
                icon = null;
            }
            pair2 = TuplesKt.to((Object)icon, (Object)((KotlinNotebookDependencies.SingleModule)currentDependencies).getModuleName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair3 = pair2;
        Icon icon = (Icon)pair3.component1();
        String text2 = (String)pair3.component2();
        e.getPresentation().setIcon(icon);
        e.getPresentation().setText(text2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final boolean actionPerformed$lambda$0(AnActionEvent $e, AnAction actionGroupItem) {
        Intrinsics.checkNotNullParameter((Object)actionGroupItem, (String)"actionGroupItem");
        SelectDependenciesAction selectDependenciesAction = actionGroupItem instanceof SelectDependenciesAction ? (SelectDependenciesAction)actionGroupItem : null;
        return Intrinsics.areEqual((Object)(selectDependenciesAction != null ? selectDependenciesAction.getDependencies() : null), (Object)KotlinNotebookDependenciesComboBoxActionKt.access$getCurrentDependencies($e));
    }

    private static final boolean actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$AllProjectLibrariesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "placeholder", "", "<init>", "(Ljava/lang/String;)V", "intellij.kotlin.jupyter.core"})
    private static final class AllProjectLibrariesAction
    extends SelectDependenciesAction {
        public AllProjectLibrariesAction(@NlsActions.ActionText @NotNull String placeholder) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            super(placeholder, KotlinNotebookDependencies.AllLibraries.INSTANCE, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$NoDependenciesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "placeholder", "", "<init>", "(Ljava/lang/String;)V", "intellij.kotlin.jupyter.core"})
    private static final class NoDependenciesAction
    extends SelectDependenciesAction {
        public NoDependenciesAction(@NlsActions.ActionText @NotNull String placeholder) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            super(placeholder, KotlinNotebookDependencies.None.INSTANCE, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u001b\b\u0004\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "placeholder", "", "dependencies", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;", "<init>", "(Ljava/lang/String;Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;)V", "getDependencies", "()Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$AllProjectLibrariesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$NoDependenciesAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectModuleAction;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookDependenciesComboBoxAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction\n+ 2 SessionShutdownPrompt.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/SessionShutdownPromptKt\n*L\n1#1,174:1\n27#2,10:175\n49#2,2:185\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDependenciesComboBoxAction.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction\n*L\n123#1:175,10\n123#1:185,2\n*E\n"})
    private static abstract sealed class SelectDependenciesAction
    extends DumbAwareAction
    permits AllProjectLibrariesAction, NoDependenciesAction, SelectModuleAction {
        @NotNull
        private final KotlinNotebookDependencies dependencies;

        private SelectDependenciesAction(@NlsActions.ActionText String placeholder, KotlinNotebookDependencies dependencies) {
            super(placeholder);
            this.dependencies = dependencies;
        }

        @NotNull
        public final KotlinNotebookDependencies getDependencies() {
            return this.dependencies;
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)e);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            if (Intrinsics.areEqual((Object)KotlinNotebookDependenciesComboBoxActionKt.access$getCurrentDependencies(e), (Object)this.dependencies)) {
                return;
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor2);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
            Project project2 = editor2.getProject();
            if (project2 == null && (project2 = e.getProject()) == null) {
                return;
            }
            Project project3 = project = project2;
            BackedNotebookVirtualFile notebookFile$iv = notebookFile;
            boolean $i$f$promptSessionShutdownIfNeeded = false;
            if (IsKotlinNotebookKt.isKotlinNotebook(notebookFile$iv)) {
                void project$iv;
                if (!JupyterExecutionManager.Companion.getInstance((Project)project$iv, notebookFile$iv).hasSession()) {
                    JupyterNotebook notebook;
                    boolean hasActiveSession = false;
                    boolean bl = false;
                    JupyterNotebook jupyterNotebook = notebook = notebookFile.getNotebookOrNull();
                    if (jupyterNotebook != null) {
                        KotlinNotebookSettingsKt.setNotebookDependencies(jupyterNotebook, this.getDependencies());
                    }
                    if (!hasActiveSession) {
                        JupyterCompilerService.Companion.getInstance(project).recreateService(notebookFile);
                    }
                    JupyterNotebook jupyterNotebook2 = notebook;
                    if (jupyterNotebook2 != null) {
                        ExternalBuildSystemUtilsKt.showKernelAndModuleJdkAreMatchingWarningIfNeeded(jupyterNotebook2, project);
                    }
                } else {
                    ComponentsKt.dialog$default((String)KotlinNotebookBundle.message("dialog.title.session.shutdown.prompt", new Object[0]), (JComponent)((JComponent)BuilderKt.panel((Function1)SessionShutdownPromptKt.promptSessionShutdownIfNeeded.1.INSTANCE)), (boolean)false, null, (boolean)false, null, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>((Project)project$iv, notebookFile$iv, notebookFile, this, project){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ BackedNotebookVirtualFile $notebookFile;
                        final /* synthetic */ BackedNotebookVirtualFile $notebookFile$inlined;
                        final /* synthetic */ SelectDependenciesAction this$0;
                        final /* synthetic */ Project $project$inlined;
                        {
                            this.$project = $project;
                            this.$notebookFile = $notebookFile;
                            this.$notebookFile$inlined = backedNotebookVirtualFile;
                            this.this$0 = selectDependenciesAction;
                            this.$project$inlined = project;
                        }

                        public final List<ValidationInfo> invoke() {
                            JupyterNotebook notebook;
                            boolean hasActiveSession = true;
                            boolean bl = false;
                            JupyterNotebook jupyterNotebook = notebook = this.$notebookFile$inlined.getNotebookOrNull();
                            if (jupyterNotebook != null) {
                                KotlinNotebookSettingsKt.setNotebookDependencies(jupyterNotebook, this.this$0.getDependencies());
                            }
                            if (!hasActiveSession) {
                                JupyterCompilerService.Companion.getInstance(this.$project$inlined).recreateService(this.$notebookFile$inlined);
                            }
                            JupyterNotebook jupyterNotebook2 = notebook;
                            if (jupyterNotebook2 != null) {
                                ExternalBuildSystemUtilsKt.showKernelAndModuleJdkAreMatchingWarningIfNeeded(jupyterNotebook2, this.$project$inlined);
                            }
                            JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$notebookFile, null){
                                int label;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ BackedNotebookVirtualFile $notebookFile;
                                {
                                    this.$project = $project;
                                    this.$notebookFile = $notebookFile;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = JupyterExecutionManager.Companion.getInstance(this.$project, this.$notebookFile).killExecution((Continuation)this);
                                            Object object3 = object2;
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }));
                            return null;
                        }
                    }), (int)1020, null).show();
                }
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Intrinsics.areEqual((Object)KotlinNotebookDependenciesComboBoxActionKt.access$getCurrentDependencies(e), (Object)this.dependencies)) {
                e.getPresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        public /* synthetic */ SelectDependenciesAction(String placeholder, KotlinNotebookDependencies dependencies, DefaultConstructorMarker $constructor_marker) {
            this(placeholder, dependencies);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectModuleAction;", "Lcom/intellij/kotlin/jupyter/core/settings/actions/KotlinNotebookDependenciesComboBoxAction$SelectDependenciesAction;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.kotlin.jupyter.core"})
    private static final class SelectModuleAction
    extends SelectDependenciesAction {
        @NotNull
        private final Module module;

        public SelectModuleAction(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            super(string, new KotlinNotebookDependencies.SingleModule(string2), null);
            this.module = module;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setIcon(ModuleType.get((Module)this.module).getIcon());
            super.update(e);
        }
    }
}

