/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010#\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020$H\u0016J\u0006\u0010(\u001a\u00020$J\b\u0010)\u001a\u00020$H$J\b\u0010*\u001a\u00020$H$J\b\u0010+\u001a\u00020\u000fH\u0016J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001706J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020\u001aH\u0016J\b\u0010?\u001a\u00020\u001aH\u0016J\b\u0010@\u001a\u00020\u001aH\u0016R$\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u001a@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u001a@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001c\u0010,\u001a\n .*\u0004\u0018\u00010-0-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0016\u00107\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\bR\u0016\u00109\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\b\u00a8\u0006A"}, d2={"Lcom/intellij/sql/formatter/model/SqlInjectionHostBlock;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlSingleNodeBlock;", "<init>", "()V", "value", "parent", "getParent", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "Lcom/intellij/lang/ASTNode;", "blockNode", "getBlockNode", "()Lcom/intellij/lang/ASTNode;", "setBlockNode", "(Lcom/intellij/lang/ASTNode;)V", "injectedBlocks", "", "Lcom/intellij/formatting/Block;", "getInjectedBlocks", "()Ljava/util/List;", "", "analyzed", "getAnalyzed", "()Z", "setAnalyzed", "(Z)V", "grown", "getGrown", "setGrown", "setup", "", "node", "setup$intellij_database_sql_core_impl", "grow", "analyze", "makeInjectionBlocks", "analyzeInjectedContent", "getNode", "range", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "minLength", "", "getMinLength", "()I", "getSubBlocks", "", "firstNestedSqlBlock", "getFirstNestedSqlBlock", "lastNestedSqlBlock", "getLastNestedSqlBlock", "contains", "char", "", "isLeaf", "tailFormed", "tailCompleted", "intellij.database.sql.core.impl"})
public abstract non-sealed class SqlInjectionHostBlock
extends SqlBlock
implements SqlSingleNodeBlock {
    protected SqlBlock parent;
    protected ASTNode blockNode;
    @NotNull
    private final List<Block> injectedBlocks = new ArrayList();
    private boolean analyzed;
    private boolean grown;

    public SqlInjectionHostBlock() {
        super(null);
    }

    @Override
    @NotNull
    public SqlBlock getParent() {
        SqlBlock sqlBlock = this.parent;
        if (sqlBlock != null) {
            return sqlBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        return null;
    }

    protected void setParent(@NotNull SqlBlock sqlBlock) {
        Intrinsics.checkNotNullParameter((Object)sqlBlock, (String)"<set-?>");
        this.parent = sqlBlock;
    }

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public ASTNode getBlockNode() {
        ASTNode aSTNode = this.blockNode;
        if (aSTNode != null) {
            return aSTNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockNode");
        return null;
    }

    protected void setBlockNode(@NotNull ASTNode aSTNode) {
        Intrinsics.checkNotNullParameter((Object)aSTNode, (String)"<set-?>");
        this.blockNode = aSTNode;
    }

    @NotNull
    protected final List<Block> getInjectedBlocks() {
        return this.injectedBlocks;
    }

    public final boolean getAnalyzed() {
        return this.analyzed;
    }

    protected final void setAnalyzed(boolean bl) {
        this.analyzed = bl;
    }

    public final boolean getGrown() {
        return this.grown;
    }

    protected final void setGrown(boolean bl) {
        this.grown = bl;
    }

    public final void setup$intellij_database_sql_core_impl(@NotNull SqlBlock parent, @NotNull ASTNode node) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)parent, (Object)this);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setParent(parent);
        this.setBlockNode(node);
        this.setShape(BlockShape.DECIDE_LATER);
    }

    @Override
    public void grow() {
        if (this.grown) {
            return;
        }
        this.grown = true;
        this.makeInjectionBlocks();
    }

    @Override
    public final void analyze() {
        if (this.analyzed) {
            return;
        }
        this.analyzed = true;
        this.setHasUserBreaks(this.contains('\n'));
        this.analyzeInjectedContent();
    }

    protected abstract void makeInjectionBlocks();

    protected abstract void analyzeInjectedContent();

    @Override
    @NotNull
    public ASTNode getNode() {
        return this.getBlockNode();
    }

    @Override
    public TextRange getRange() {
        return this.getBlockNode().getTextRange();
    }

    @Override
    public int getMinLength() {
        return this.getBlockNode().getTextLength();
    }

    @Override
    @NotNull
    public final List<Block> getSubBlocks() {
        this.grow();
        return this.injectedBlocks;
    }

    @Override
    @Nullable
    public SqlBlock getFirstNestedSqlBlock() {
        return null;
    }

    @Override
    @Nullable
    public SqlBlock getLastNestedSqlBlock() {
        return null;
    }

    @Override
    public boolean contains(char c) {
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = this.getBlockNode().getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return sqlFormattingContext.textContains(textRange, c);
    }

    public boolean isLeaf() {
        return this.grown ? this.injectedBlocks.isEmpty() : !SqlFormattingModelFun.hasInjection(this.getBlockNode());
    }

    @Override
    public boolean tailFormed() {
        return true;
    }

    @Override
    public boolean tailCompleted() {
        return true;
    }
}

