/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import git4idea.GitActivity;
import git4idea.GitStashUsageCollector;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import git4idea.index.GitStageTracker;
import git4idea.index.actions.StagingAreaOperation;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.NodeKind;
import git4idea.stash.GitStashOperations;
import git4idea.stash.GitStashUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0016J@\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020#0\"H\u0016J,\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 *\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010$\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/index/actions/GitStashOperation;", "Lgit4idea/index/actions/StagingAreaOperation;", "<init>", "()V", "actionText", "Ljava/util/function/Supplier;", "", "getActionText", "()Ljava/util/function/Supplier;", "progressTitle", "getProgressTitle", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "errorMessage", "getErrorMessage", "matches", "", "statusNode", "Lgit4idea/index/ui/GitFileStatusNode;", "processPaths", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "nodes", "", "reportResult", "successfulRoots", "", "exceptionsByRoot", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vcs/VcsException;", "SHOW_NOTIFICATION_PROPERTY", "showNonEmptyStagingAreaNotification", "stagedFiles", "Lcom/intellij/openapi/vcs/FilePath;", "Lgit4idea/index/GitStageTracker;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStageStashFilesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageStashFilesAction.kt\ngit4idea/index/actions/GitStashOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n1563#2:110\n1634#2,3:111\n774#2:114\n865#2,2:115\n1491#2:117\n1516#2,3:118\n1519#2,3:128\n1634#2,3:131\n1761#2,3:134\n382#3,7:121\n504#3,7:137\n126#4:144\n153#4,3:145\n*S KotlinDebug\n*F\n+ 1 GitStageStashFilesAction.kt\ngit4idea/index/actions/GitStashOperation\n*L\n44#1:110\n44#1:111,3\n75#1:114\n75#1:115,2\n75#1:117\n75#1:118,3\n75#1:128,3\n76#1:131,3\n77#1:134,3\n75#1:121,7\n94#1:137,7\n94#1:144\n94#1:145,3\n*E\n"})
public final class GitStashOperation
implements StagingAreaOperation {
    @NotNull
    public static final GitStashOperation INSTANCE = new GitStashOperation();
    @NotNull
    private static final Supplier<String> actionText;
    @NotNull
    private static final String progressTitle;
    @Nullable
    private static final Icon icon;
    @NotNull
    private static final String errorMessage;
    @NotNull
    private static final String SHOW_NOTIFICATION_PROPERTY = "git.stash.notify.non.empty.index";

    private GitStashOperation() {
    }

    @Override
    @NotNull
    public Supplier<String> getActionText() {
        return actionText;
    }

    @Override
    @NotNull
    public String getProgressTitle() {
        return progressTitle;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public boolean matches(@NotNull GitFileStatusNode statusNode) {
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        return statusNode.getKind() == NodeKind.UNSTAGED || statusNode.getKind() == NodeKind.UNTRACKED || statusNode.getKind() == NodeKind.STAGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitFileStatusNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message((String)"activity.name.stash", (Object[])new Object[0]), (ActivityId)GitActivity.Stash);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            StructuredIdeActivity activity = GitStashUsageCollector.logStashPush(project);
            try {
                Collection<FilePath> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String[] stringArray = (String[])nodes;
                VirtualFile virtualFile = root;
                Project project2 = project;
                boolean $i$f$map = false;
                void var13_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    GitFileStatusNode gitFileStatusNode = (GitFileStatusNode)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it2.getFilePath());
                }
                collection = (List)destination$iv$iv;
                stringArray = new String[]{"-u"};
                GitLineHandler handler = GitStashUtils.createStashHandler(project2, virtualFile, (Collection<? extends FilePath>)collection, stringArray);
                Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            }
            finally {
                StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
            }
            StagingAreaOperation.Companion.refreshVirtualFiles(nodes, true);
            GitStashUtils.refreshStash(project, root);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void reportResult(@NotNull Project project, @NotNull List<GitFileStatusNode> nodes, @NotNull Collection<? extends VirtualFile> successfulRoots, @NotNull MultiMap<VirtualFile, VcsException> exceptionsByRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(successfulRoots, (String)"successfulRoots");
        Intrinsics.checkNotNullParameter(exceptionsByRoot, (String)"exceptionsByRoot");
        StagingAreaOperation.super.reportResult(project, nodes, successfulRoots, exceptionsByRoot);
        if (!successfulRoots.isEmpty()) {
            GitStashOperations.INSTANCE.showSuccessNotification(project, successfulRoots, !exceptionsByRoot.isEmpty());
            this.showNonEmptyStagingAreaNotification(project, nodes, successfulRoots);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showNonEmptyStagingAreaNotification(Project project, List<GitFileStatusNode> nodes, Collection<? extends VirtualFile> successfulRoots) {
        if (PropertiesComponent.getInstance((Project)project).getBoolean(SHOW_NOTIFICATION_PROPERTY, true)) {
            void $this$groupByTo$iv$iv;
            Map.Entry $this$groupBy$iv2;
            GitFileStatusNode it;
            void $this$filterTo$iv$iv;
            GitStageTracker tracker = GitStageTracker.Companion.getInstance(project);
            Set<VirtualFile> stagedRoots = tracker.getState().getStagedRoots();
            Set stagedRootsToStash = new LinkedHashSet();
            Iterable $this$filter$iv = nodes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GitFileStatusNode)element$iv$iv;
                boolean bl = false;
                if (!(stagedRoots.contains(it.getRoot()) && successfulRoots.contains(it.getRoot()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv2;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                it = (GitFileStatusNode)element$iv$iv;
                boolean bl = false;
                VirtualFile key$iv$iv = it.getRoot();
                Object object2 = destination$iv$iv;
                VirtualFile key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry $this$groupBy$iv2 : destination$iv$iv.entrySet()) {
                boolean bl;
                VirtualFile root;
                block11: {
                    void destination$iv;
                    void $this$mapTo$iv;
                    root = (VirtualFile)$this$groupBy$iv2.getKey();
                    List nodesInRoot = (List)$this$groupBy$iv2.getValue();
                    Iterable $i$f$groupByTo2 = nodesInRoot;
                    Collection collection = new LinkedHashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it2;
                        GitFileStatusNode key$iv$iv = (GitFileStatusNode)item$iv;
                        void var23_34 = destination$iv;
                        boolean bl3 = false;
                        var23_34.add(it2.getFilePath());
                    }
                    Set paths = (Set)destination$iv;
                    Intrinsics.checkNotNull((Object)tracker);
                    Iterable $this$any$iv = this.stagedFiles(tracker, root);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FilePath it3 = (FilePath)element$iv;
                            boolean bl4 = false;
                            if (!(!paths.contains(it3))) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                stagedRootsToStash.add(root);
            }
            if (stagedRootsToStash.isEmpty()) {
                return;
            }
            Object[] objectArray = new Object[]{GitStashOperations.INSTANCE.getRootsText$intellij_vcs_git(project, stagedRootsToStash)};
            String string = GitBundle.message((String)"stash.changes.non.empty.index.for.roots.notification.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)GitBundle.message((String)"stash.changes.non.empty.index.notification.action", (Object[])new Object[0]), () -> GitStashOperation.showNonEmptyStagingAreaNotification$lambda$4(project));
            Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
            NotificationAction action = notificationAction;
            objectArray = new NotificationAction[]{action};
            VcsNotifier.getInstance((Project)project).notifyMinorWarning("git.stash.non.empty.index.detected", "", message, (NotificationAction[])objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<FilePath> stagedFiles(GitStageTracker $this$stagedFiles, VirtualFile root) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GitStageTracker.RootState rootState = $this$stagedFiles.getState().getRootStates().get(root);
        if (rootState == null) {
            return CollectionsKt.emptyList();
        }
        GitStageTracker.RootState rootState2 = rootState;
        Map $this$filterValues$iv = rootState2.getStatuses();
        boolean $i$f$filterValues = false;
        LinkedHashMap<FilePath, GitFileStatus> result$iv = new LinkedHashMap<FilePath, GitFileStatus>();
        for (Map.Entry<FilePath, GitFileStatus> entry$iv : $this$filterValues$iv.entrySet()) {
            GitFileStatus it = entry$iv.getValue();
            boolean bl = false;
            if (!(it.getStagedStatus() != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((FilePath)it.getKey());
        }
        return (List)destination$iv$iv;
    }

    private static final void showNonEmptyStagingAreaNotification$lambda$4(Project $project) {
        PropertiesComponent.getInstance((Project)$project).setValue(SHOW_NOTIFICATION_PROPERTY, false);
    }

    static {
        Supplier supplier = GitBundle.messagePointer((String)"stash.files.action.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        actionText = supplier;
        String string = GitBundle.message((String)"stash.files.progress.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        progressTitle = string;
        String string2 = GitBundle.message((String)"stash.files.error.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        errorMessage = string2;
    }
}

