/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaLibraryCoordinates;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.facet.JpaImplicitFacetImpl;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.ModifiablePersistenceFacet;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PerformanceAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JpaConfigurationModel {
    private static final List<JpaLibraryCoordinates> JPA_LIBRARY_COORDINATES_LIST = List.of(new JpaLibraryCoordinates("javax", "javaee-api"), new JpaLibraryCoordinates("javax", "javaee-web-api"), new JpaLibraryCoordinates("javax.persistence", "javax.persistence-api"), new JpaLibraryCoordinates("jakarta.platform", "jakarta.jakartaee-api"), new JpaLibraryCoordinates("jakarta.platform", "jakarta.jakartaee-web-api"), new JpaLibraryCoordinates("jakarta.persistence", "jakarta.persistence-api"), new JpaLibraryCoordinates("org.eclipse.persistence", "jakarta.persistence"), new JpaLibraryCoordinates("org.hibernate", "hibernate-core"), new JpaLibraryCoordinates("io.micronaut.configuration", "micronaut-hibernate-jpa"), new JpaLibraryCoordinates("io.micronaut.data", "micronaut-data-hibernate-jpa"), new JpaLibraryCoordinates("io.dropwizard", "dropwizard-hibernate"), new JpaLibraryCoordinates("io.quarkus", "quarkus-hibernate-orm"));
    private static final List<String> JPA_MAVEN_COORDS = ContainerUtil.map(JPA_LIBRARY_COORDINATES_LIST, JpaLibraryCoordinates::externalSystemName);
    private static final List<String> PERSISTENT_FACET_IDS = List.of("jpa", "hibernate");

    public static boolean hasJpaSupport(@NotNull Module module) {
        if (module == null) {
            JpaConfigurationModel.$$$reportNull$$$0(0);
        }
        return JpaConfigurationModel.hasJpaJars(module) || ContainerUtil.exists((Object[])FacetManager.getInstance((Module)module).getAllFacets(), facet -> facet instanceof JpaModuleConfiguration);
    }

    public static boolean hasJpaSupport(@NotNull Project project) {
        if (project == null) {
            JpaConfigurationModel.$$$reportNull$$$0(1);
        }
        return JpaConfigurationModel.hasJpaJars(project) || ProjectFacetManager.getInstance((Project)project).hasFacets(JpaFacet.ID);
    }

    public static boolean hasJpaJars(@NotNull Module module) {
        if (module == null) {
            JpaConfigurationModel.$$$reportNull$$$0(2);
        }
        return JavaLibraryUtil.hasAnyLibraryJar((Module)module, JPA_MAVEN_COORDS);
    }

    public static boolean hasJpaJars(@NotNull Project project) {
        if (project == null) {
            JpaConfigurationModel.$$$reportNull$$$0(3);
        }
        return JavaLibraryUtil.hasAnyLibraryJar((Project)project, JPA_MAVEN_COORDS);
    }

    @Nullable
    public static JpaModuleConfiguration getConfiguration(@Nullable Module module) {
        Facet[] facets;
        if (module == null) {
            return null;
        }
        PerformanceAssertions.assertDoesNotAffectHighlighting();
        for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!(facet instanceof JpaModuleConfiguration)) continue;
            return (JpaModuleConfiguration)facet;
        }
        return (JpaModuleConfiguration)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Project project = module.getProject();
            JpaImplicitFacetImpl result = null;
            ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>();
            dependencies.add(JavaLibraryModificationTracker.getInstance((Project)project));
            if (JpaConfigurationModel.hasJpaJars(module)) {
                ConfigFileInfo persistenceConfig = JpaConfigurationModel.findDefaultPersistenceConfig((ModuleRootModel)ModuleRootManager.getInstance((Module)module));
                JpaImplementationProvider jpaProvider = JpaConfigurationModel.findJpaImplementation(module);
                dependencies.add(PsiModificationTracker.getInstance((Project)project).forLanguage((Language)XMLLanguage.INSTANCE));
                FacetTypeRegistry facetTypeRegistry = FacetTypeRegistry.getInstance();
                for (String facetId : PERSISTENT_FACET_IDS) {
                    FacetType facetType = facetTypeRegistry.findFacetType(facetId);
                    if (facetType == null) continue;
                    dependencies.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(facetType.getId()));
                }
                result = new JpaImplicitFacetImpl(module, persistenceConfig, jpaProvider != null ? jpaProvider.getProviderName() : null);
            }
            return CachedValueProvider.Result.create(result, dependencies);
        });
    }

    @NotNull
    public static PersistenceFacet createModifiablePersistenceFacet(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            JpaConfigurationModel.$$$reportNull$$$0(4);
        }
        if (facet instanceof ModifiablePersistenceFacet) {
            PersistenceFacet persistenceFacet = facet;
            if (persistenceFacet == null) {
                JpaConfigurationModel.$$$reportNull$$$0(5);
            }
            return persistenceFacet;
        }
        if (facet instanceof JpaImplicitFacetImpl) {
            return JpaConfigurationModel.createJpaFacet((JpaImplicitFacetImpl)facet);
        }
        throw new UnsupportedOperationException("Unsupported persistence facet " + String.valueOf(facet));
    }

    @NotNull
    public static PersistenceFacet modifyConfiguration(@NotNull PersistenceFacet facet, @NotNull Consumer<ModifiablePersistenceFacet> action) {
        if (facet == null) {
            JpaConfigurationModel.$$$reportNull$$$0(6);
        }
        if (action == null) {
            JpaConfigurationModel.$$$reportNull$$$0(7);
        }
        if (facet instanceof ModifiablePersistenceFacet) {
            ApplicationManager.getApplication().runWriteAction(() -> action.accept((ModifiablePersistenceFacet)facet));
            PersistenceFacet persistenceFacet = facet;
            if (persistenceFacet == null) {
                JpaConfigurationModel.$$$reportNull$$$0(8);
            }
            return persistenceFacet;
        }
        if (facet instanceof JpaImplicitFacetImpl) {
            ModifiablePersistenceFacet jpaFacet = JpaConfigurationModel.createJpaFacet((JpaImplicitFacetImpl)facet);
            ApplicationManager.getApplication().runWriteAction(() -> action.accept(jpaFacet));
            ModifiablePersistenceFacet modifiablePersistenceFacet = jpaFacet;
            if (modifiablePersistenceFacet == null) {
                JpaConfigurationModel.$$$reportNull$$$0(9);
            }
            return modifiablePersistenceFacet;
        }
        throw new UnsupportedOperationException("Unsupported persistence facet " + String.valueOf(facet));
    }

    @NotNull
    private static ModifiablePersistenceFacet createJpaFacet(@NotNull JpaImplicitFacetImpl implicitFacet) {
        if (implicitFacet == null) {
            JpaConfigurationModel.$$$reportNull$$$0(10);
        }
        Module module = implicitFacet.getModule();
        JpaFacetType facetType = JpaFacetType.getInstance();
        JpaFacetConfiguration configuration = facetType.createDefaultConfiguration();
        configuration.setDefaultJPAProviderName(implicitFacet.getDefaultJPAProviderName());
        for (ConfigFile descriptor : implicitFacet.getDescriptors()) {
            configuration.getDescriptorsConfiguration().addConfigFile(descriptor.getInfo());
        }
        JpaFacet jpaFacet = (JpaFacet)FacetManager.getInstance((Module)module).createFacet((FacetType)facetType, facetType.getPresentableName(), (FacetConfiguration)configuration, null);
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableFacetModel modifiableModel = FacetManager.getInstance((Module)module).createModifiableModel();
            modifiableModel.addFacet((Facet)jpaFacet);
            modifiableModel.commit();
        });
        JpaFacet jpaFacet2 = jpaFacet;
        if (jpaFacet2 == null) {
            JpaConfigurationModel.$$$reportNull$$$0(11);
        }
        return jpaFacet2;
    }

    @Nullable
    private static JpaImplementationProvider findJpaImplementation(@NotNull Module module) {
        if (module == null) {
            JpaConfigurationModel.$$$reportNull$$$0(12);
        }
        JpaImplementationProvider suitableProvider = null;
        block0: for (JpaImplementationProvider provider : JpaImplementationProvider.EP_NAME.getExtensionList()) {
            for (JpaLibraryCoordinates coordinate : provider.getAutoDetectionCoordinates()) {
                if (!JavaLibraryUtil.hasLibraryJar((Module)module, (String)coordinate.externalSystemName())) continue;
                if (suitableProvider != null) {
                    return null;
                }
                suitableProvider = provider;
                continue block0;
            }
        }
        return suitableProvider;
    }

    @Nullable
    private static ConfigFileInfo findDefaultPersistenceConfig(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            JpaConfigurationModel.$$$reportNull$$$0(13);
        }
        return Stream.concat(rootModel.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE).stream(), rootModel.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE).stream()).flatMap(root -> {
            String descriptorRelativePath = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getDirectoryPath() + "/" + JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName();
            VirtualFile existingFile = root.findFileByRelativePath(descriptorRelativePath);
            return existingFile != null ? Stream.of(existingFile) : Stream.empty();
        }).map(file -> new ConfigFileInfo(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, file.getUrl())).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/facet/JpaConfigurationModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitFacet";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/facet/JpaConfigurationModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiablePersistenceFacet";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createJpaFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasJpaSupport";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasJpaJars";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModifiablePersistenceFacet";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifyConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createJpaFacet";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findJpaImplementation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultPersistenceConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

