/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.mapping;

import com.intellij.jpa.jpb.model.backend.ed.ddl.DbDialect;
import com.intellij.jpa.jpb.model.backend.ed.ddl.OracleDbDialect;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.OracleType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.mapping.ReMappingSettings;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0 0\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/liquibase/common/mapping/OracleReMappingSettings;", "Lcom/intellij/liquibase/common/mapping/ReMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/OracleType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/OracleType;)V", "isHibernate6Project", "", "mappingTypes", "", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "()Ljava/util/Map;", "sqlTypeToJdbcTypeCode", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getSqlTypeToJdbcTypeCode", "sqlSynonymTypes", "", "getSqlSynonymTypes", "getJavaType", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "column", "Lliquibase/structure/core/Column;", "getDbDialect", "Lcom/intellij/jpa/jpb/model/backend/ed/ddl/DbDialect;", "findTemporalTypeByColumnType", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute$TemporalType;", "sqlType", "getTemporalTypeMappings", "", "Companion", "intellij.liquibase.common"})
public final class OracleReMappingSettings
extends ReMappingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isHibernate6Project;
    @NotNull
    private final Map<String, HibernateSqlType> sqlTypeToJdbcTypeCode;
    @NotNull
    private static final Datatypes.BasicDatatype BFILE_TYPE;
    @NotNull
    private static final Datatypes.BasicDatatype ROWID_TYPE;
    @NotNull
    public static final String NUMBER_1 = "NUMBER(1)";
    @NotNull
    public static final String TIMESTAMP = "TIMESTAMP";
    @NotNull
    public static final String INTERVAL = "INTERVAL";
    private static final int INTEGER_PRECISION = 9;
    private static final int SHORT_PRECISION = 4;

    public OracleReMappingSettings(@NotNull Project project, @NotNull OracleType dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        super(project, (DbType)dbType);
        this.isHibernate6Project = JpaUtils.isHibernate6Project((Project)project, null);
        this.sqlTypeToJdbcTypeCode = MapsKt.mapOf((Pair)TuplesKt.to((Object)"XMLTYPE", (Object)HibernateSqlType.SQLXML));
    }

    @Override
    @NotNull
    public Map<String, Datatypes.BasicDatatype> getMappingTypes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CHAR", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"CHAR(1)", (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"VARCHAR2", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"NCHAR", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"NVARCHAR2", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"CLOB", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"NCLOB", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"LONG", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"INTEGER", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"SMALLINT", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)NUMBER_1, (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"NUMBER", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"FLOAT", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"DOUBLE", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"BINARY_FLOAT", (Object)Datatypes.BasicDatatype.Float), TuplesKt.to((Object)"BINARY_DOUBLE", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"DATE", (Object)Datatypes.BasicDatatype.LocalDate), TuplesKt.to((Object)TIMESTAMP, (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"TIMESTAMP WITH TIME ZONE", (Object)Datatypes.BasicDatatype.OffsetDateTime), TuplesKt.to((Object)"TIMESTAMP WITH LOCAL TIME ZONE", (Object)Datatypes.BasicDatatype.OffsetDateTime), TuplesKt.to((Object)"BFILE", (Object)BFILE_TYPE), TuplesKt.to((Object)"RAW", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)INTERVAL, (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"ROWID", (Object)ROWID_TYPE), TuplesKt.to((Object)"UROWID", (Object)ROWID_TYPE), TuplesKt.to((Object)"BLOB", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"XMLTYPE", (Object)(this.isHibernate6Project ? HibernateTypes.INSTANCE.getMapStringToObject() : Datatypes.BasicDatatype.String))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public Map<String, HibernateSqlType> getSqlTypeToJdbcTypeCode() {
        return this.sqlTypeToJdbcTypeCode;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"raw", (Object)CollectionsKt.listOf((Object)"long raw"));
        pairArray[1] = TuplesKt.to((Object)"char", (Object)CollectionsKt.listOf((Object)"CHARACTER"));
        Object[] objectArray = new String[]{"PLS_INTEGER", "INT", "SIGNTYPE", "POSITIVEN", "POSITIVE"};
        pairArray[2] = TuplesKt.to((Object)"INTEGER", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"DECIMAL", "DEC", "NUMERIC"};
        pairArray[3] = TuplesKt.to((Object)"NUMBER", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[4] = TuplesKt.to((Object)"TIMESTAMP WITH TIME ZONE", (Object)CollectionsKt.listOf((Object)"TIMESTAMP WITH TZ"));
        pairArray[5] = TuplesKt.to((Object)"TIMESTAMP WITH LOCAL TIME ZONE", (Object)CollectionsKt.listOf((Object)"TIMESTAMP WITH LOCAL TZ"));
        pairArray[6] = TuplesKt.to((Object)"VARCHAR2", (Object)CollectionsKt.listOf((Object)"VARCHAR"));
        pairArray[7] = TuplesKt.to((Object)"NVARCHAR2", (Object)CollectionsKt.listOf((Object)"NVARCHAR"));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Nullable
    public Datatype getJavaType(@NotNull Column column) {
        int columnSize;
        String sqlType;
        block6: {
            Datatype datatype;
            block8: {
                block9: {
                    int decimalDigits;
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
                        Datatypes.BasicDatatype explicitConfiguredJavaType = super.getExplicitConfiguredJavaType(column);
                        if (explicitConfiguredJavaType != null) {
                            return (Datatype)explicitConfiguredJavaType;
                        }
                        DataType dataType = column.getType();
                        sqlType = dataType.getTypeName();
                        Integer n = dataType.getColumnSize();
                        columnSize = n != null ? n : 0;
                        Integer n2 = dataType.getDecimalDigits();
                        int n3 = decimalDigits = n2 != null ? n2 : 0;
                        if (!StringsKt.equals((String)sqlType, (String)"number", (boolean)true)) break block6;
                        if (columnSize != 1 || decimalDigits != 0) break block7;
                        Datatypes.BasicDatatype basicDatatype = this.findMappingType(NUMBER_1);
                        if (basicDatatype == null) {
                            basicDatatype = Datatypes.BasicDatatype.Boolean;
                        }
                        datatype = (Datatype)basicDatatype;
                        break block8;
                    }
                    if (decimalDigits <= 0) break block9;
                    datatype = (Datatype)Datatypes.BasicDatatype.BigDecimal;
                    break block8;
                }
                datatype = (1 <= columnSize ? columnSize < 5 : false) ? (Datatype)Datatypes.BasicDatatype.Short : ((1 <= columnSize ? columnSize < 10 : false) ? (Datatype)Datatypes.BasicDatatype.Integer : (Datatype)Datatypes.BasicDatatype.Long);
            }
            return datatype;
        }
        if (StringsKt.equals((String)sqlType, (String)"float", (boolean)true)) {
            return columnSize >= 24 ? (Datatype)Datatypes.BasicDatatype.Double : (Datatype)Datatypes.BasicDatatype.Float;
        }
        Intrinsics.checkNotNull((Object)sqlType);
        if (StringsKt.startsWith((String)sqlType, (String)INTERVAL, (boolean)true)) {
            Datatypes.BasicDatatype basicDatatype = this.findMappingType(INTERVAL);
            return basicDatatype != null ? (Datatype)basicDatatype : (Datatype)Datatypes.BasicDatatype.String;
        }
        Datatype javaType = super.getJavaType(column);
        if (javaType != null) {
            return javaType;
        }
        if (StringsKt.startsWith$default((String)sqlType, (String)"TIMESTAMP(", (boolean)false, (int)2, null)) {
            return (Datatype)this.findMappingType(StringsKt.substringBefore$default((String)sqlType, (char)'(', null, (int)2, null) + StringsKt.substringAfter$default((String)sqlType, (char)')', null, (int)2, null));
        }
        return null;
    }

    @Override
    @NotNull
    public DbDialect getDbDialect() {
        DbDialect dbDialect = OracleDbDialect.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)dbDialect, (String)"INSTANCE");
        return dbDialect;
    }

    @Override
    @Nullable
    public EntityAttribute.TemporalType findTemporalTypeByColumnType(@Nullable String sqlType) {
        EntityAttribute.TemporalType temporalType = super.findTemporalTypeByColumnType(sqlType);
        if (temporalType != null) {
            return temporalType;
        }
        String string = sqlType;
        return (string != null ? StringsKt.startsWith$default((String)string, (String)"TIMESTAMP(", (boolean)false, (int)2, null) : false) ? EntityAttribute.TemporalType.TIMESTAMP : null;
    }

    @Override
    @NotNull
    public Map<EntityAttribute.TemporalType, String[]> getTemporalTypeMappings() {
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{"date"};
        pairArray[0] = TuplesKt.to((Object)EntityAttribute.TemporalType.DATE, (Object)stringArray);
        stringArray = new String[]{"timestamp", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH TZ", "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH LOCAL TZ"};
        pairArray[1] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIMESTAMP, (Object)stringArray);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    static {
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.createUnsafe((String)"oracle.sql.BFILE");
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"createUnsafe(...)");
        BFILE_TYPE = basicDatatype;
        Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.createUnsafe((String)"oracle.sql.ROWID");
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"createUnsafe(...)");
        ROWID_TYPE = basicDatatype2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/common/mapping/OracleReMappingSettings$Companion;", "", "<init>", "()V", "BFILE_TYPE", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getBFILE_TYPE", "()Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "ROWID_TYPE", "getROWID_TYPE", "NUMBER_1", "", "TIMESTAMP", "INTERVAL", "INTEGER_PRECISION", "", "SHORT_PRECISION", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Datatypes.BasicDatatype getBFILE_TYPE() {
            return BFILE_TYPE;
        }

        @NotNull
        public final Datatypes.BasicDatatype getROWID_TYPE() {
            return ROWID_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

