/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.dom.DatabaseChangeLog;
import com.intellij.liquibase.common.dom.IncludeFile;
import com.intellij.liquibase.structure.LiquibaseTreeElement;
import com.intellij.liquibase.structure.sections.IncludeAllSection;
import com.intellij.liquibase.structure.sections.IncludeSection;
import com.intellij.liquibase.structure.sections.LiquibaseOrderedSection;
import com.intellij.liquibase.structure.sections.LiquibaseTagSection;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/liquibase/structure/LiquibaseFileTreeElement;", "Lcom/intellij/liquibase/structure/LiquibaseTreeElement;", "Lcom/intellij/psi/xml/XmlFile;", "Lcom/intellij/navigation/ItemPresentation;", "xmlFile", "alreadyUsedFiles", "", "provideChildren", "", "isRoot", "<init>", "(Lcom/intellij/psi/xml/XmlFile;Ljava/util/List;ZZ)V", "getProvideChildren", "()Z", "getPresentation", "getIcon", "Ljavax/swing/Icon;", "unused", "getPresentableText", "", "getLocationString", "Lcom/intellij/openapi/util/NlsSafe;", "getChangelogDirectory", "Lcom/intellij/psi/PsiDirectory;", "getChildrenBase", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "createIncludeSections", "", "dbChangeLogTag", "Lcom/intellij/psi/xml/XmlTag;", "canNavigate", "intellij.liquibase"})
@SourceDebugExtension(value={"SMAP\nLiquibaseFileTreeElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseFileTreeElement.kt\ncom/intellij/liquibase/structure/LiquibaseFileTreeElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1056#2:97\n1#3:98\n*S KotlinDebug\n*F\n+ 1 LiquibaseFileTreeElement.kt\ncom/intellij/liquibase/structure/LiquibaseFileTreeElement\n*L\n63#1:97\n*E\n"})
public class LiquibaseFileTreeElement
extends LiquibaseTreeElement<XmlFile>
implements ItemPresentation {
    @NotNull
    private final List<XmlFile> alreadyUsedFiles;
    private final boolean provideChildren;
    private final boolean isRoot;

    public LiquibaseFileTreeElement(@NotNull XmlFile xmlFile, @NotNull List<? extends XmlFile> alreadyUsedFiles, boolean provideChildren, boolean isRoot) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter(alreadyUsedFiles, (String)"alreadyUsedFiles");
        Project project = xmlFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project, (XmlElement)xmlFile);
        this.alreadyUsedFiles = alreadyUsedFiles;
        this.provideChildren = provideChildren;
        this.isRoot = isRoot;
    }

    public /* synthetic */ LiquibaseFileTreeElement(XmlFile xmlFile, List list, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(xmlFile, list, bl, bl2);
    }

    protected final boolean getProvideChildren() {
        return this.provideChildren;
    }

    protected final boolean isRoot() {
        return this.isRoot;
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        Icon icon = AllIcons.Providers.Liquibase;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Liquibase");
        return icon;
    }

    @NotNull
    public String getPresentableText() {
        String string = ((XmlFile)this.getValue()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    public String getLocationString() {
        Object object = ((XmlFile)this.getValue()).getContainingDirectory();
        if (object == null || (object = HPsiUtil.getClassPathRelativePath((PsiFileSystemItem)((PsiFileSystemItem)object), (char)'/')) == null) {
            return null;
        }
        Object relativePath = object;
        String defaultPath = StringsKt.substringBefore$default((String)DatabaseMigrationConfig.Companion.getInstance(this.getProject()).getState().getMainChangeLogDir(), (String)"/#", null, (int)2, null);
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)relativePath, (CharSequence)defaultPath), (CharSequence)"/");
    }

    @Override
    @Nullable
    public PsiDirectory getChangelogDirectory() {
        return ((XmlFile)this.getValue()).getContainingDirectory();
    }

    @NotNull
    public List<StructureViewTreeElement> getChildrenBase() {
        if (!this.isRoot && !this.provideChildren) {
            return CollectionsKt.emptyList();
        }
        XmlTag xmlTag = ((XmlFile)this.getValue()).getRootTag();
        if (xmlTag == null) {
            return CollectionsKt.emptyList();
        }
        XmlTag rootTag = xmlTag;
        List result = new ArrayList();
        PsiElement psiElement = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getValue(...)");
        result.addAll(this.createIncludeSections((XmlFile)psiElement, rootTag));
        int idx = 0;
        XmlTag[] xmlTagArray = rootTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        for (XmlTag subTag : xmlTagArray) {
            String tagName;
            Intrinsics.checkNotNullExpressionValue((Object)subTag.getLocalName(), (String)"getLocalName(...)");
            Object[] objectArray = new String[]{"includeAll", "include"};
            if (ArraysKt.contains((Object[])objectArray, (Object)tagName)) continue;
            if (Intrinsics.areEqual((Object)"changeSet", (Object)tagName)) {
                XmlTag[] xmlTagArray2 = subTag.getSubTags();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray2, (String)"getSubTags(...)");
                for (XmlTag changeSetChildTag : xmlTagArray2) {
                    Project project = this.getProject();
                    Intrinsics.checkNotNull((Object)changeSetChildTag);
                    result.add(new LiquibaseTagSection(project, changeSetChildTag, idx++));
                }
                continue;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNull((Object)subTag);
            result.add(new LiquibaseTagSection(project, subTag, idx++));
        }
        Iterable $this$sortedBy$iv = result;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StructureViewTreeElement it = (StructureViewTreeElement)a;
                boolean bl = false;
                StructureViewTreeElement $this$asSafely$iv = it;
                boolean $i$f$asSafely = false;
                StructureViewTreeElement structureViewTreeElement = $this$asSafely$iv;
                if (!(structureViewTreeElement instanceof LiquibaseOrderedSection)) {
                    structureViewTreeElement = null;
                }
                LiquibaseOrderedSection liquibaseOrderedSection = (LiquibaseOrderedSection)structureViewTreeElement;
                it = (StructureViewTreeElement)b;
                Comparable comparable = Integer.valueOf(liquibaseOrderedSection != null ? liquibaseOrderedSection.getOrder() : 0);
                bl = false;
                $this$asSafely$iv = it;
                $i$f$asSafely = false;
                StructureViewTreeElement structureViewTreeElement2 = $this$asSafely$iv;
                if (!(structureViewTreeElement2 instanceof LiquibaseOrderedSection)) {
                    structureViewTreeElement2 = null;
                }
                LiquibaseOrderedSection liquibaseOrderedSection2 = (LiquibaseOrderedSection)structureViewTreeElement2;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(liquibaseOrderedSection2 != null ? liquibaseOrderedSection2.getOrder() : 0));
            }
        });
    }

    private final Collection<StructureViewTreeElement> createIncludeSections(XmlFile xmlFile, XmlTag dbChangeLogTag) {
        DomManager domManager = DomManager.getDomManager((Project)this.getProject());
        DatabaseChangeLog databaseChangeLog = null;
        List result = new ArrayList();
        XmlTag[] xmlTagArray = dbChangeLogTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        XmlTag[] xmlTagArray2 = xmlTagArray;
        int n = xmlTagArray2.length;
        for (int i = 0; i < n; ++i) {
            XmlFile includeDbChangeLogFile;
            GenericAttributeValue<DatabaseChangeLog> genericAttributeValue;
            Object v4;
            XmlTag xmlTag;
            Object object;
            List usedFilesList;
            XmlTag subTag;
            int index;
            block4: {
                String tagName;
                index = i;
                subTag = xmlTagArray2[i];
                Intrinsics.checkNotNullExpressionValue((Object)subTag.getLocalName(), (String)"getLocalName(...)");
                usedFilesList = CollectionsKt.plus((Collection)this.alreadyUsedFiles, (Object)xmlFile);
                if (Intrinsics.areEqual((Object)"includeAll", (Object)tagName)) {
                    Project project = this.getProject();
                    Intrinsics.checkNotNull((Object)subTag);
                    result.add(new IncludeAllSection(project, subTag, index, this.provideChildren, usedFilesList));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"include", (Object)tagName)) continue;
                if (databaseChangeLog == null) {
                    DomFileElement domFileElement = domManager.getFileElement(xmlFile, DatabaseChangeLog.class);
                    DatabaseChangeLog databaseChangeLog2 = databaseChangeLog = domFileElement != null ? (DatabaseChangeLog)domFileElement.getRootElement() : null;
                }
                if (databaseChangeLog == null) continue;
                boolean bl = false;
                object = databaseChangeLog.getIncludedFiles();
                xmlTag = object.iterator();
                while (xmlTag.hasNext()) {
                    Object t = xmlTag.next();
                    IncludeFile it = (IncludeFile)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getXmlTag(), (Object)subTag)) continue;
                    v4 = t;
                    break block4;
                }
                v4 = null;
            }
            IncludeFile includeFile = v4;
            PsiFile psiFile = includeFile != null && (genericAttributeValue = includeFile.getIncludedChangeLog()) != null && (object = (DatabaseChangeLog)genericAttributeValue.getValue()) != null && (xmlTag = object.getXmlTag()) != null ? xmlTag.getContainingFile() : null;
            XmlFile xmlFile2 = includeDbChangeLogFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            if (includeDbChangeLogFile == null || this.alreadyUsedFiles.contains(includeDbChangeLogFile)) continue;
            result.add(new IncludeSection(subTag, includeDbChangeLogFile, index, this.provideChildren, usedFilesList));
        }
        return result;
    }

    public boolean canNavigate() {
        return this.isRoot || this.provideChildren;
    }
}

