/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.CollectionsExKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.commons.intern.util.VectorAdapter;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathData;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathPoint;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PolygonData;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 I2\u00020\u0001:\u0001IB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJP\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\b\b\u0002\u0010 \u001a\u00020\nJ0\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dJH\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00170$2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0016\b\u0002\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\b\b\u0002\u0010(\u001a\u00020\nJ6\u0010)\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dJ(\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+0\u00172\f\u0010.\u001a\b\u0012\u0004\u0012\u00020&0/H\u0002J>\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0016\b\u0002\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dJB\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u001a\u0010'\u001a\u0016\u0012\u0004\u0012\u00020\u001b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u00170\u001dJ(\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$2\u0006\u00103\u001a\u00020\nJ4\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\n2\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00110\u001dJ\u0018\u0010:\u001a\u0002052\u0006\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u001bH\u0002J\u0006\u0010;\u001a\u00020\nJF\u0010<\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00170$2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010(\u001a\u00020\nH\u0002JV\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010 \u001a\u00020\n2\u0006\u0010(\u001a\u00020\nJ$\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020&0/2\u0006\u00108\u001a\u00020\nH\u0002J.\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00170$2\u0006\u00108\u001a\u00020\nJ\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u00172\f\u0010A\u001a\b\u0012\u0004\u0012\u00020@0\u0017H\u0002J\u000e\u0010B\u001a\u0002052\u0006\u0010C\u001a\u00020\nJ\u000e\u0010D\u001a\u0002052\u0006\u0010?\u001a\u00020\nJ\u0015\u0010E\u001a\u0002052\u0006\u0010F\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bGJ\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020@0\u00172\f\u0010A\u001a\b\u0012\u0004\u0012\u00020@0\u0017H\u0002J4\u0010H\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00170$2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00170$H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006J"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;)V", "myAlphaEnabled", "", "myResamplingEnabled", "getMyResamplingEnabled", "()Z", "setMyResamplingEnabled", "(Z)V", "myResamplingPrecision", "", "getMyResamplingPrecision", "()D", "setMyResamplingPrecision", "(D)V", "createBands", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "toLocationUpper", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "toLocationLower", "simplifyBorders", "createLines", "toLocation", "createPathData", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "locationTransform", "closePath", "createPathDataByGroup", "createPolygon", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PolygonData;", "domainPathData", "", "createRectPolygon", "createSteps", "paths", "horizontalThenVertical", "decorate", "", "path", "p", "filled", "strokeScaler", "decorateFillingPart", "meetsRadarPlotReq", "preparePathData", "renderBands", "renderPaths", "resample", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathPoint;", "linestring", "setAlphaEnabled", "b", "setResamplingEnabled", "setResamplingPrecision", "precision", "setResamplingPrecision$plot_base", "toClient", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLinesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,480:1\n1549#2:481\n1620#2,3:482\n1549#2:485\n1620#2,3:486\n1603#2,9:489\n1855#2:498\n1856#2:500\n1612#2:501\n1603#2,9:502\n1855#2:511\n1549#2:512\n1620#2,3:513\n1856#2:518\n1612#2:519\n1549#2:520\n1620#2,2:521\n1549#2:523\n1620#2,3:524\n1622#2:528\n1855#2,2:529\n1603#2,9:531\n1855#2:540\n1856#2:542\n1612#2:543\n1855#2,2:544\n1238#2,2:548\n1603#2,9:550\n1855#2:559\n1856#2:561\n1612#2:562\n1241#2:563\n1603#2,9:564\n1855#2:573\n1856#2:575\n1612#2:576\n1238#2,4:579\n1238#2,2:585\n1360#2:587\n1446#2,5:588\n1241#2:593\n1238#2,2:597\n1603#2,9:599\n1855#2:608\n1856#2:610\n1612#2:611\n1241#2:612\n1238#2,2:615\n1603#2,9:617\n1855#2:626\n1603#2,9:627\n1855#2:636\n1856#2:638\n1612#2:639\n1856#2:641\n1612#2:642\n1241#2:643\n1238#2,2:646\n1360#2:648\n1446#2,5:649\n1241#2:654\n1#3:499\n1#3:516\n1#3:517\n1#3:527\n1#3:541\n1#3:560\n1#3:574\n1#3:594\n1#3:609\n1#3:637\n1#3:640\n453#4:546\n403#4:547\n453#4:577\n403#4:578\n453#4:583\n403#4:584\n453#4:595\n403#4:596\n453#4:613\n403#4:614\n453#4:644\n403#4:645\n*S KotlinDebug\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper\n*L\n68#1:481\n68#1:482,3\n114#1:485\n114#1:486,3\n115#1:489,9\n115#1:498\n115#1:500\n115#1:501\n117#1:502,9\n117#1:511\n119#1:512\n119#1:513,3\n117#1:518\n117#1:519\n123#1:520\n123#1:521,2\n125#1:523\n125#1:524,3\n123#1:528\n150#1:529,2\n177#1:531,9\n177#1:540\n177#1:542\n177#1:543\n194#1:544,2\n238#1:548,2\n251#1:550,9\n251#1:559\n251#1:561\n251#1:562\n238#1:563\n256#1:564,9\n256#1:573\n256#1:575\n256#1:576\n310#1:579,4\n317#1:585,2\n317#1:587\n317#1:588,5\n317#1:593\n319#1:597,2\n319#1:599,9\n319#1:608\n319#1:610\n319#1:611\n319#1:612\n323#1:615,2\n324#1:617,9\n324#1:626\n326#1:627,9\n326#1:636\n326#1:638\n326#1:639\n324#1:641\n324#1:642\n323#1:643\n335#1:646,2\n335#1:648\n335#1:649,5\n335#1:654\n115#1:499\n117#1:517\n177#1:541\n251#1:560\n256#1:574\n319#1:609\n326#1:637\n324#1:640\n238#1:546\n238#1:547\n310#1:577\n310#1:578\n317#1:583\n317#1:584\n319#1:595\n319#1:596\n323#1:613\n323#1:614\n335#1:644\n335#1:645\n*E\n"})
public class LinesHelper
extends GeomHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean myAlphaEnabled;
    private boolean myResamplingEnabled;
    private double myResamplingPrecision;

    public LinesHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        super(pos, coord, ctx2);
        this.myAlphaEnabled = true;
        this.myResamplingPrecision = 0.95;
    }

    protected final boolean getMyResamplingEnabled() {
        return this.myResamplingEnabled;
    }

    protected final void setMyResamplingEnabled(boolean bl) {
        this.myResamplingEnabled = bl;
    }

    protected final double getMyResamplingPrecision() {
        return this.myResamplingPrecision;
    }

    protected final void setMyResamplingPrecision(double d) {
        this.myResamplingPrecision = d;
    }

    public final boolean meetsRadarPlotReq() {
        return this.getCoord().isPolar() && this.getCtx$plot_base().getPlotContext().hasScale(Aes.Companion.getX()) && !this.getCtx$plot_base().getPlotContext().getScale(Aes.Companion.getX()).isContinuous();
    }

    public final void setAlphaEnabled(boolean b2) {
        this.myAlphaEnabled = b2;
    }

    public final void setResamplingEnabled(boolean resample2) {
        this.myResamplingEnabled = resample2;
    }

    public final void setResamplingPrecision$plot_base(double precision) {
        this.myResamplingPrecision = precision;
    }

    @NotNull
    public final List<LinePath> createLines(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocation2) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocation2, (String)"toLocation");
        Map<Integer, PathData> pathDataByGroup = this.createPathDataByGroup(dataPoints2, toLocation2);
        return this.renderPaths(pathDataByGroup.values(), false);
    }

    @NotNull
    public final List<LinePath> renderPaths(@NotNull Map<Integer, ? extends List<PathData>> paths, boolean filled) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        return this.renderPaths(CollectionsKt.flatten((Iterable)paths.values()), filled);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinePath> renderPaths(Collection<PathData> paths, boolean filled) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LinePath linePath;
            List<DoubleVector> list2;
            void path2;
            PathData pathData = (PathData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = this.myResamplingEnabled;
            if (bl2) {
                list2 = PolylineSimplifier.Companion.douglasPeucker(path2.getCoordinates(), 0.25);
            } else if (!bl2) {
                list2 = path2.getCoordinates();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<DoubleVector> visualPath = list2;
            boolean bl3 = filled;
            if (bl3) {
                linePath = LinePath.Companion.polygon((Iterable<DoubleVector>)visualPath);
            } else if (!bl3) {
                linePath = LinePath.Companion.line((Iterable<DoubleVector>)visualPath);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LinePath element = linePath;
            LinesHelper.decorate$default(this, element, path2.getAes(), filled, null, 8, null);
            collection.add(element);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<Integer, List<PathData>> createPathData(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> locationTransform, boolean closePath) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(locationTransform, (String)"locationTransform");
        Map<Integer, List<PathData>> domainData = this.preparePathData(dataPoints2, locationTransform, closePath);
        return this.toClient(domainData);
    }

    public static /* synthetic */ Map createPathData$default(LinesHelper linesHelper, Iterable iterable, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPathData");
        }
        if ((n & 2) != 0) {
            function1 = GeomUtil.INSTANCE.getTO_LOCATION_X_Y();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return linesHelper.createPathData(iterable, function1, bl);
    }

    @NotNull
    public final List<Pair<SvgNode, PolygonData>> createPolygon(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> locationTransform) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(locationTransform, (String)"locationTransform");
        Collection<PathData> domainPathData = GeomUtil.INSTANCE.createPathGroups(dataPoints2, locationTransform, true, false).values();
        return this.createPolygon(domainPathData);
    }

    public static /* synthetic */ List createPolygon$default(LinesHelper linesHelper, Iterable iterable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPolygon");
        }
        if ((n & 2) != 0) {
            function1 = GeomUtil.INSTANCE.getTO_LOCATION_X_Y();
        }
        return linesHelper.createPolygon(iterable, function1);
    }

    @NotNull
    public final List<Pair<SvgNode, PolygonData>> createRectPolygon(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, ? extends List<DoubleVector>> locationTransform) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(locationTransform, (String)"locationTransform");
        List<PathData> domainPathData = GeomUtil.INSTANCE.createPathDataFromRectangle(dataPoints2, locationTransform);
        return this.createPolygon((Collection<PathData>)domainPathData);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<SvgNode, PolygonData>> createPolygon(Collection<PathData> domainPathData) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Iterator it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv = domainPathData;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable<PolygonData> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            PathData pathData = (PathData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GeometryKt.splitRings(((PathData)((Object)it)).getPoints(), PathPoint.Companion.getLOC_EQ()));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            PolygonData it$iv$iv;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = it.next();
            boolean bl = false;
            List it2 = (List)element$iv$iv;
            boolean bl2 = false;
            if (PolygonData.Companion.create(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List domainPolygonData = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv2 = domainPolygonData;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<PolygonData> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            PolygonData it$iv$iv;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv2.next();
            boolean bl7 = false;
            PolygonData polygon2 = (PolygonData)element$iv$iv;
            boolean bl4 = false;
            Iterable bl3 = polygon2.getRings();
            boolean $i$f$map2 = false;
            void var19_50 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it3;
                List list2 = (List)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl5 = false;
                collection2.add(this.myResamplingEnabled ? this.resample((List<PathPoint>)it3) : this.toClient((List<PathPoint>)it3));
            }
            List it4 = (List)destination$iv$iv3;
            boolean bl6 = false;
            if (PolygonData.Companion.create(it4) == null) continue;
            boolean $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv2 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List clientPolygonData = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = clientPolygonData;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv4;
            void $this$map$iv4;
            void polygon3;
            element$iv$iv$iv = (PolygonData)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            Iterable bl7 = polygon3.getCoordinates();
            boolean $i$f$map22 = false;
            void bl4 = $this$map$iv4;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                void it5;
                List $i$f$mapTo2 = (List)item$iv$iv2;
                Collection collection3 = destination$iv$iv5;
                boolean bl8 = false;
                collection3.add(PolylineSimplifier.Companion.douglasPeucker((List<DoubleVector>)it5, 0.25));
            }
            List list3 = (List)destination$iv$iv5;
            Companion $i$f$map22 = Companion;
            Iterable p0 = list3;
            boolean bl9 = false;
            List it6 = $i$f$map22.insertPathSeparators(p0);
            boolean bl10 = false;
            LinePath element = LinePath.Companion.polygon(it6);
            LinesHelper.decorate$default(this, element, polygon3.getAes(), true, null, 8, null);
            collection.add(element.getRootGroup());
        }
        List svg = (List)destination$iv$iv4;
        return CollectionsKt.zip((Iterable)svg, (Iterable)clientPolygonData);
    }

    private final List<PathPoint> resample(List<PathPoint> linestring) {
        List smoothed = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.windowed$default((Iterable)linestring, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2 = (List)element$iv;
            boolean bl = false;
            PathPoint p1 = (PathPoint)list2.get(0);
            PathPoint p2 = (PathPoint)list2.get(1);
            AdaptiveResampler<PathPoint> resampler2 = LinesHelper.resample$resampler(this, p1.getAes());
            List<PathPoint> resampledPoints = resampler2.resample(p1, p2);
            if (resampledPoints.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            smoothed.addAll((Collection)resampledPoints.subList(0, resampledPoints.size() - 1));
        }
        PathPoint endPoint = (PathPoint)CollectionsKt.last(linestring);
        DoubleVector endCoord = this.toClient(endPoint.getCoord(), endPoint.getAes());
        if (endCoord != null) {
            smoothed.add(new PathPoint(endPoint.getAes(), endCoord));
        }
        return smoothed;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PathPoint> toClient(List<PathPoint> linestring) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = linestring;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PathPoint pathPoint;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PathPoint p = (PathPoint)element$iv$iv;
            boolean bl2 = false;
            if (this.toClient(p.getCoord(), p.getAes()) != null) {
                DoubleVector it;
                boolean bl3 = false;
                pathPoint = new PathPoint(p.getAes(), it);
            } else {
                pathPoint = null;
            }
            if (pathPoint == null) continue;
            PathPoint it$iv$iv = pathPoint;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<Integer, PathData> createPathDataByGroup(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocation2) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocation2, (String)"toLocation");
        return GeomUtil.INSTANCE.createPathGroups(dataPoints2, this.toClientLocation$plot_base(toLocation2), true, false);
    }

    @NotNull
    public final List<LinePath> createSteps(@NotNull Map<Integer, PathData> paths, boolean horizontalThenVertical) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        ArrayList<LinePath> linePaths = new ArrayList<LinePath>();
        Iterable $this$forEach$iv = paths.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PathData subPath = (PathData)element$iv;
            boolean bl = false;
            List<DoubleVector> points2 = subPath.getCoordinates();
            if (!(!((Collection)points2).isEmpty())) continue;
            ArrayList<DoubleVector> newPoints = new ArrayList<DoubleVector>();
            DoubleVector prev = null;
            for (DoubleVector point2 : points2) {
                if (prev != null) {
                    double x2 = horizontalThenVertical ? point2.getX() : prev.getX();
                    double y2 = horizontalThenVertical ? prev.getY() : point2.getY();
                    newPoints.add(new DoubleVector(x2, y2));
                }
                newPoints.add(point2);
                prev = point2;
            }
            LinePath line2 = LinePath.Companion.line((Iterable<DoubleVector>)newPoints);
            LinesHelper.decorate$default(this, line2, subPath.getAes(), false, null, 8, null);
            linePaths.add(line2);
        }
        return linePaths;
    }

    @NotNull
    public final List<LinePath> createBands(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationUpper, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationLower, boolean simplifyBorders) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocationUpper, (String)"toLocationUpper");
        Intrinsics.checkNotNullParameter(toLocationLower, (String)"toLocationLower");
        return this.renderBands(dataPoints2, toLocationUpper, toLocationLower, simplifyBorders, false);
    }

    public static /* synthetic */ List createBands$default(LinesHelper linesHelper, Iterable iterable, Function1 function1, Function1 function12, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBands");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return linesHelper.createBands(iterable, (Function1<? super DataPointAesthetics, DoubleVector>)function1, (Function1<? super DataPointAesthetics, DoubleVector>)function12, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LinePath> renderBands(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationUpper, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationLower, boolean simplifyBorders, boolean closePath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocationUpper, (String)"toLocationUpper");
        Intrinsics.checkNotNullParameter(toLocationLower, (String)"toLocationLower");
        Map<Integer, List<PathData>> domainUpperPathData = this.preparePathData(dataPoints2, toLocationUpper, closePath);
        Map<Integer, List<PathData>> domainLowerPathData = this.preparePathData(dataPoints2, toLocationLower, closePath);
        Map<Integer, List<PathData>> $this$mapValues$iv = domainUpperPathData;
        boolean $i$f$mapValues = false;
        Map<Integer, List<PathData>> map2 = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List<PathData> lowerPathData;
            List list2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            int group2 = ((Number)entry2.getKey()).intValue();
            List upperPathData = (List)entry2.getValue();
            if (domainLowerPathData.get(group2) == null) {
                list2 = CollectionsKt.emptyList();
            } else if (upperPathData.isEmpty() || lowerPathData.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv;
                if (!(upperPathData.size() == lowerPathData.size())) {
                    boolean $i$a$-require-LinesHelper$renderBands$domainBandsPathData$1$22 = false;
                    String $i$a$-require-LinesHelper$renderBands$domainBandsPathData$1$22 = "Upper and lower path data should contain the same number of paths";
                    throw new IllegalArgumentException($i$a$-require-LinesHelper$renderBands$domainBandsPathData$1$22.toString());
                }
                Iterable iterable = CollectionsKt.zip((Iterable)upperPathData, (Iterable)lowerPathData);
                boolean $i$f$mapNotNull = false;
                void var28_35 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PathData it$iv$iv2;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                    boolean bl3 = false;
                    Pair pair2 = (Pair)element$iv$iv;
                    boolean bl4 = false;
                    PathData upperPath = (PathData)pair2.component1();
                    PathData lowerPath = (PathData)pair2.component2();
                    if (PathData.Companion.create(CollectionsKt.plus((Collection)upperPath.getPoints(), (Iterable)CollectionsKt.reversed((Iterable)lowerPath.getPoints()))) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv2);
                }
                list2 = (List)destination$iv$iv2;
            }
            List list3 = list2;
            map4.put(k, list3);
        }
        Map domainBandsPathData = destination$iv$iv;
        Map<Integer, List<PathData>> clientBandsPathData = this.toClient(domainBandsPathData);
        Iterable $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)clientBandsPathData.values());
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            LinePath linePath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            PathData pathData = (PathData)element$iv$iv;
            boolean bl6 = false;
            List<DoubleVector> points2 = pathData.getCoordinates();
            if (!((Collection)points2).isEmpty()) {
                LinePath path2 = LinePath.Companion.polygon((Iterable<DoubleVector>)(simplifyBorders ? PolylineSimplifier.Companion.douglasPeucker(points2, 0.25) : points2));
                this.decorateFillingPart(path2, pathData.getAes());
                linePath = path2;
            } else {
                linePath = null;
            }
            if (linePath == null) continue;
            LinePath it$iv$iv = linePath;
            boolean bl7 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    public final void decorate(@NotNull LinePath path2, @NotNull DataPointAesthetics p, boolean filled, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
        Color stroke2;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
        Color color = stroke2 = p.color();
        Intrinsics.checkNotNull((Object)color);
        double strokeAlpha = AestheticsUtil.INSTANCE.alpha(color, p);
        path2.color().set(Colors.INSTANCE.withOpacity(stroke2, strokeAlpha));
        if (filled || !this.myAlphaEnabled) {
            path2.color().set(stroke2);
        }
        if (filled) {
            this.decorateFillingPart(path2, p);
        }
        double size2 = ((Number)strokeScaler.invoke((Object)p)).doubleValue();
        path2.width().set(size2);
        LineType lineType2 = p.lineType();
        path2.lineType().set(lineType2);
    }

    public static /* synthetic */ void decorate$default(LinesHelper linesHelper, LinePath linePath, DataPointAesthetics dataPointAesthetics, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decorate");
        }
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).strokeWidth(p0);
                }
            };
        }
        linesHelper.decorate(linePath, dataPointAesthetics, bl, (Function1<? super DataPointAesthetics, Double>)function1);
    }

    private final void decorateFillingPart(LinePath path2, DataPointAesthetics p) {
        Color fill2;
        Color color = fill2 = p.fill();
        Intrinsics.checkNotNull((Object)color);
        double fillAlpha = AestheticsUtil.INSTANCE.alpha(color, p);
        path2.fill().set(Colors.INSTANCE.withOpacity(fill2, fillAlpha));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<PathData>> preparePathData(Iterable<? extends DataPointAesthetics> dataPoints2, Function1<? super DataPointAesthetics, DoubleVector> locationTransform, boolean closePath) {
        void $this$mapValuesTo$iv$iv;
        Map<Integer, PathData> domainPathData;
        Map<Integer, PathData> $this$mapValues$iv = domainPathData = GeomUtil.INSTANCE.createPathGroups(dataPoints2, locationTransform, true, closePath);
        boolean $i$f$mapValues = false;
        Map<Integer, PathData> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            PathData pathData = (PathData)entry2.getValue();
            List list2 = CollectionsKt.listOf((Object)pathData);
            map4.put(k, list2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, List<PathData>> toClient(Map<Integer, ? extends List<PathData>> domainPathData) {
        Map<Integer, List<PathData>> map2;
        boolean bl = this.myResamplingEnabled;
        if (bl) {
            List list2;
            Map<Integer, List<PathData>> map3;
            Object k;
            Map.Entry it$iv$iv;
            Map.Entry entry;
            boolean bl2;
            Map<Integer, List<PathData>> map4;
            void $this$mapValuesTo$iv$iv;
            Map<Integer, List<PathData>> $this$mapValues$iv = domainPathData;
            boolean $i$f$mapValues = false;
            Map<Integer, ? extends List<PathData>> map5 = $this$mapValues$iv;
            Map<Integer, List<PathData>> destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                map4 = destination$iv$iv;
                bl2 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map3 = map4;
                boolean bl3 = false;
                List groupPath = (List)entry.getValue();
                Iterable iterable = groupPath;
                Companion companion = Companion;
                boolean $i$f$flatMap = false;
                void var21_56 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PathData p0 = (PathData)element$iv$iv;
                    boolean bl4 = false;
                    Iterable list$iv$iv = companion.splitByStyle(p0);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
                map3.put((Integer)k, list2);
            }
            Map<Integer, List<PathData>> it = destination$iv$iv;
            boolean $i$a$-let-LinesHelper$toClient$42 = false;
            $this$mapValues$iv = Companion.interpolatePathData((Map<Integer, ? extends List<PathData>>)it);
            $i$f$mapValues = false;
            Map<Integer, List<PathData>> $i$a$-let-LinesHelper$toClient$42 = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv$iv;
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map4 = destination$iv$iv;
                bl2 = false;
                entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map3 = map4;
                boolean bl5 = false;
                List paths = (List)entry.getValue();
                Iterable $this$mapNotNull$iv = paths;
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$flatMap = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                element$iv$iv = $this$forEach$iv$iv$iv.iterator();
                while (element$iv$iv.hasNext()) {
                    PathData it$iv$iv2;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = element$iv$iv.next();
                    boolean bl6 = false;
                    PathData it2 = (PathData)element$iv$iv2;
                    boolean bl7 = false;
                    if (PathData.Companion.create(this.resample(it2.getPoints())) == null) continue;
                    boolean bl8 = false;
                    destination$iv$iv3.add(it$iv$iv2);
                }
                list2 = (List)destination$iv$iv3;
                map3.put((Integer)k, list2);
            }
            map2 = destination$iv$iv;
        } else if (!bl) {
            void $this$mapValuesTo$iv$iv;
            Map clientPathData;
            List list3;
            Map map6;
            Object k;
            void $this$mapValuesTo$iv$iv2;
            Map<Integer, ? extends List<PathData>> $this$mapValues$iv = domainPathData;
            boolean $i$f$mapValues = false;
            Map<Integer, ? extends List<PathData>> destination$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object object = destination$iv$iv4;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
                Map.Entry bl5 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map6 = object;
                boolean bl9 = false;
                List groupPath = (List)bl5.getValue();
                Iterable $this$mapNotNull$iv = groupPath;
                boolean $i$f$mapNotNull = false;
                Iterable destination$iv$iv3 = $this$mapNotNull$iv;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PathData it$iv$iv3;
                    void $this$mapNotNullTo$iv$iv2;
                    Object element$iv$iv$iv3;
                    Object element$iv$iv = element$iv$iv$iv3 = iterator2.next();
                    boolean bl10 = false;
                    PathData segment2 = (PathData)element$iv$iv;
                    boolean bl11 = false;
                    Iterable $this$mapNotNull$iv2 = segment2.getPoints();
                    boolean $i$f$mapNotNull2 = false;
                    Iterable iterable = $this$mapNotNull$iv2;
                    Collection destination$iv$iv6 = new ArrayList();
                    boolean $i$f$mapNotNullTo2 = false;
                    void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                    while (iterator3.hasNext()) {
                        PathPoint pathPoint;
                        Object element$iv$iv$iv4;
                        Object element$iv$iv3 = element$iv$iv$iv4 = iterator3.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        PathPoint p = (PathPoint)element$iv$iv3;
                        boolean bl12 = false;
                        DoubleVector doubleVector = this.toClient(p.getCoord(), p.getAes());
                        if (doubleVector != null) {
                            DoubleVector it = doubleVector;
                            boolean bl13 = false;
                            pathPoint = new PathPoint(p.getAes(), it);
                        } else {
                            pathPoint = null;
                        }
                        if (pathPoint == null) continue;
                        PathPoint it$iv$iv4 = pathPoint;
                        boolean bl14 = false;
                        destination$iv$iv6.add(it$iv$iv4);
                    }
                    List points2 = (List)destination$iv$iv6;
                    if (PathData.Companion.create(points2) == null) continue;
                    boolean bl15 = false;
                    destination$iv$iv5.add(it$iv$iv3);
                }
                list3 = (List)destination$iv$iv5;
                map6.put(k, list3);
            }
            Map $this$mapValues$iv2 = clientPathData = destination$iv$iv4;
            boolean $i$f$mapValues2 = false;
            destination$iv$iv4 = $this$mapValues$iv2;
            Map destination$iv$iv7 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo2 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void it$iv$iv;
                object = (Map.Entry)element$iv$iv$iv;
                Map map7 = destination$iv$iv7;
                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv3 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map6 = map7;
                boolean bl16 = false;
                List pathData = (List)entry.getValue();
                Iterable $i$f$mapNotNull = pathData;
                Companion companion = Companion;
                boolean $i$f$flatMap = false;
                void $i$f$mapNotNullTo = $this$flatMap$iv;
                Collection destination$iv$iv8 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PathData p0 = (PathData)element$iv$iv;
                    boolean bl17 = false;
                    Iterable list$iv$iv = companion.splitByStyle(p0);
                    CollectionsKt.addAll((Collection)destination$iv$iv8, (Iterable)list$iv$iv);
                }
                list3 = (List)destination$iv$iv8;
                map6.put(k, list3);
            }
            Map clientVariadicPathData = destination$iv$iv7;
            map2 = Companion.interpolatePathData(clientVariadicPathData);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    private static final AdaptiveResampler<PathPoint> resample$resampler(LinesHelper this$0, DataPointAesthetics aes2) {
        VectorAdapter<PathPoint> adapter2 = new VectorAdapter<PathPoint>(aes2){
            final /* synthetic */ DataPointAesthetics $aes;
            {
                this.$aes = $aes;
            }

            public double x(@NotNull PathPoint p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return p.getCoord().getX();
            }

            public double y(@NotNull PathPoint p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return p.getCoord().getY();
            }

            @NotNull
            public PathPoint create(double x2, double y2) {
                return new PathPoint(this.$aes, new DoubleVector(x2, y2));
            }

            @NotNull
            public PathPoint create(@NotNull Number x2, @NotNull Number y2) {
                return VectorAdapter.DefaultImpls.create(this, x2, y2);
            }

            public double getX(@NotNull PathPoint $this$x) {
                return VectorAdapter.DefaultImpls.getX(this, $this$x);
            }

            public double getY(@NotNull PathPoint $this$y) {
                return VectorAdapter.DefaultImpls.getY(this, $this$y);
            }
        };
        return AdaptiveResampler.Companion.generic(this$0.myResamplingPrecision, adapter2, (Function1)new Function1<PathPoint, PathPoint>(this$0, aes2){
            final /* synthetic */ LinesHelper this$0;
            final /* synthetic */ DataPointAesthetics $aes;
            {
                this.this$0 = $receiver;
                this.$aes = $aes;
                super(1);
            }

            @Nullable
            public final PathPoint invoke(@NotNull PathPoint p) {
                PathPoint pathPoint;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                DoubleVector doubleVector = this.this$0.toClient(p.getCoord(), this.$aes);
                if (doubleVector != null) {
                    DoubleVector doubleVector2 = doubleVector;
                    DataPointAesthetics dataPointAesthetics = this.$aes;
                    DoubleVector it = doubleVector2;
                    boolean bl = false;
                    pathPoint = new PathPoint(dataPointAesthetics, it);
                } else {
                    pathPoint = null;
                }
                return pathPoint;
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007H\u0002J2\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\tJ \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0015\u001a\u00020\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper$Companion;", "", "()V", "insertPathSeparators", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "rings", "", "interpolatePathData", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/PathData;", "variadicPath", "lerp", "p1", "p2", "progress", "", "midPointsPathInterpolator", "path", "splitByStyle", "pathData", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nLinesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,480:1\n1603#2,9:481\n1855#2:490\n1856#2:492\n1612#2:493\n1549#2:494\n1620#2,3:495\n1569#2,11:498\n1864#2,2:509\n1866#2:512\n1580#2:513\n1238#2,4:516\n1#3:491\n1#3:511\n453#4:514\n403#4:515\n*S KotlinDebug\n*F\n+ 1 LinesHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper$Companion\n*L\n366#1:481,9\n366#1:490\n366#1:492\n366#1:493\n376#1:494\n376#1:495,3\n384#1:498,11\n384#1:509,2\n384#1:512\n384#1:513\n410#1:516,4\n366#1:491\n384#1:511\n410#1:514\n410#1:515\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<DoubleVector> insertPathSeparators(Iterable<? extends List<DoubleVector>> rings) {
            ArrayList<DoubleVector> result2 = new ArrayList<DoubleVector>();
            for (List<DoubleVector> list2 : rings) {
                if (!result2.isEmpty()) {
                    result2.add(LinePath.Companion.getEND_OF_SUBPATH());
                }
                result2.addAll((Collection)list2);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PathData> splitByStyle(@NotNull PathData pathData) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
            Function1[] function1Array = new Function1[]{splitByStyle.1.INSTANCE, splitByStyle.2.INSTANCE, splitByStyle.3.INSTANCE, splitByStyle.4.INSTANCE, splitByStyle.5.INSTANCE};
            Iterable $this$mapNotNull$iv = CollectionsExKt.splitBy((Collection)pathData.getPoints(), ComparisonsKt.compareBy((Function1[])function1Array));
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PathData it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                List it = (List)element$iv$iv;
                boolean bl2 = false;
                if (PathData.Companion.create(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<PathData> midPointsPathInterpolator(List<PathData> path2) {
            void $this$mapIndexedNotNullTo$iv$iv;
            DoubleVector prevSubPathEnd;
            Iterable $this$mapTo$iv$iv;
            if (path2.size() == 1) {
                return path2;
            }
            Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)path2, (int)2, (int)1, (boolean)false, (int)4, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PathData prevSubPath = (PathData)list2.get(0);
                PathData nextSubPath = (PathData)list2.get(1);
                prevSubPathEnd = (DoubleVector)CollectionsKt.last(prevSubPath.getCoordinates());
                DoubleVector nextSubPathStart = (DoubleVector)CollectionsKt.first(nextSubPath.getCoordinates());
                DoubleVector midPoint = Companion.lerp(prevSubPathEnd, nextSubPathStart, 0.5);
                collection.add(midPoint);
            }
            List jointPoints = (List)destination$iv$iv;
            Iterable $this$mapIndexedNotNull$iv = path2;
            boolean $i$f$mapIndexedNotNull = false;
            $this$mapTo$iv$iv = $this$mapIndexedNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                PathPoint leftJointPoint;
                PathData pathData;
                void subPath;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                prevSubPathEnd = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                PathData pathData2 = (PathData)element$iv$iv;
                int i = index$iv$iv;
                boolean bl2 = false;
                int n2 = i;
                if (n2 == 0) {
                    PathPoint rightJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.last(subPath.getPoints()), null, (DoubleVector)jointPoints.get(i), 1, null);
                    pathData = PathData.Companion.create(CollectionsKt.plus((Collection)subPath.getPoints(), (Object)rightJointPoint));
                } else if (n2 == CollectionsKt.getLastIndex(path2)) {
                    leftJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.first(subPath.getPoints()), null, (DoubleVector)jointPoints.get(i - 1), 1, null);
                    pathData = PathData.Companion.create(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)leftJointPoint), (Iterable)subPath.getPoints()));
                } else {
                    leftJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.first(subPath.getPoints()), null, (DoubleVector)jointPoints.get(i - 1), 1, null);
                    PathPoint rightJointPoint = PathPoint.copy$default((PathPoint)CollectionsKt.last(subPath.getPoints()), null, (DoubleVector)jointPoints.get(i), 1, null);
                    pathData = PathData.Companion.create(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)leftJointPoint), (Iterable)subPath.getPoints()), (Object)rightJointPoint));
                }
                if (pathData == null) continue;
                PathData it$iv$iv = pathData;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final DoubleVector lerp(DoubleVector p1, DoubleVector p2, double progress) {
            return p1.add(p2.subtract(p1).mul(progress));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Integer, List<PathData>> interpolatePathData(@NotNull Map<Integer, ? extends List<PathData>> variadicPath) {
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter(variadicPath, (String)"variadicPath");
            Map<Integer, ? extends List<PathData>> $this$mapValues$iv = variadicPath;
            boolean $i$f$mapValues = false;
            Map<Integer, ? extends List<PathData>> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                List pathSegments = (List)entry2.getValue();
                List<PathData> list2 = Companion.midPointsPathInterpolator(pathSegments);
                map4.put(k, list2);
            }
            return destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

