/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.TitlePosition;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bJ8\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J=\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b J4\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J4\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J4\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018JB\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00132\b\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J0\u0010)\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.H\u0002J8\u0010/\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00132\b\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponentHelper;", "", "()V", "addTitle", "", "svgComponent", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "text", "", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "justification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "boundRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rotation", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification$Companion$TextRotation;", "className", "captionElementAndTextBounds", "Lkotlin/Pair;", "caption", "plotOuterBounds", "geomAreaBounds", "plotTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "createTextRectangle", "elementRect", "topMargin", "", "rightMargin", "bottomMargin", "leftMargin", "createTextRectangle$plot_builder", "drawCaptionDebugInfo", "textRect", "drawSubtitleDebugInfo", "subtitle", "drawTitleDebugInfo", "title", "subtitleElementAndTextBounds", "titleElementRect", "textBoundingBox", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "textRectangle", "margins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "titleElementAndTextBounds", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotSvgComponentHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotSvgComponentHelper.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponentHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1#2:263\n*E\n"})
public final class PlotSvgComponentHelper {
    @NotNull
    public static final PlotSvgComponentHelper INSTANCE = new PlotSvgComponentHelper();

    private PlotSvgComponentHelper() {
    }

    private final DoubleRectangle textRectangle(DoubleRectangle elementRect, Thickness margins) {
        return this.createTextRectangle$plot_builder(elementRect, margins.getTop(), margins.getRight(), margins.getBottom(), margins.getLeft());
    }

    @NotNull
    public final DoubleRectangle createTextRectangle$plot_builder(@NotNull DoubleRectangle elementRect, double topMargin, double rightMargin, double bottomMargin, double leftMargin) {
        Intrinsics.checkNotNullParameter((Object)elementRect, (String)"elementRect");
        return new DoubleRectangle(elementRect.getLeft() + leftMargin, elementRect.getTop() + topMargin, elementRect.getWidth() - (rightMargin + leftMargin), elementRect.getHeight() - (topMargin + bottomMargin));
    }

    public static /* synthetic */ DoubleRectangle createTextRectangle$plot_builder$default(PlotSvgComponentHelper plotSvgComponentHelper, DoubleRectangle doubleRectangle, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d4 = 0.0;
        }
        return plotSvgComponentHelper.createTextRectangle$plot_builder(doubleRectangle, d, d2, d3, d4);
    }

    @NotNull
    public final Pair<DoubleRectangle, DoubleRectangle> titleElementAndTextBounds(@Nullable String title, @NotNull DoubleRectangle plotOuterBounds, @NotNull DoubleRectangle geomAreaBounds, @NotNull PlotTheme plotTheme) {
        DoubleRectangle doubleRectangle;
        Intrinsics.checkNotNullParameter((Object)plotOuterBounds, (String)"plotOuterBounds");
        Intrinsics.checkNotNullParameter((Object)geomAreaBounds, (String)"geomAreaBounds");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        if (title == null) {
            return new Pair(null, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[plotTheme.titlePosition().ordinal()]) {
            case 1: {
                doubleRectangle = geomAreaBounds;
                break;
            }
            case 2: {
                doubleRectangle = plotOuterBounds;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle titleAlignmentArea = doubleRectangle;
        DoubleRectangle elementRect = new DoubleRectangle(titleAlignmentArea.getLeft(), plotOuterBounds.getTop(), titleAlignmentArea.getWidth(), PlotLayoutUtil.INSTANCE.titleThickness$plot_builder(title, PlotLabelSpecFactory.INSTANCE.plotTitle(plotTheme), plotTheme.titleMargins()));
        DoubleRectangle textRect = this.textRectangle(elementRect, plotTheme.titleMargins());
        return new Pair((Object)elementRect, (Object)textRect);
    }

    @NotNull
    public final Pair<DoubleRectangle, DoubleRectangle> subtitleElementAndTextBounds(@Nullable String subtitle, @NotNull DoubleRectangle plotOuterBounds, @NotNull DoubleRectangle geomAreaBounds, @Nullable DoubleRectangle titleElementRect, @NotNull PlotTheme plotTheme) {
        DoubleRectangle doubleRectangle;
        Intrinsics.checkNotNullParameter((Object)plotOuterBounds, (String)"plotOuterBounds");
        Intrinsics.checkNotNullParameter((Object)geomAreaBounds, (String)"geomAreaBounds");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        if (subtitle == null) {
            return new Pair(null, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[plotTheme.titlePosition().ordinal()]) {
            case 1: {
                doubleRectangle = geomAreaBounds;
                break;
            }
            case 2: {
                doubleRectangle = plotOuterBounds;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle titleAlignmentArea = doubleRectangle;
        DoubleRectangle doubleRectangle2 = titleElementRect;
        DoubleRectangle elementRect = new DoubleRectangle(titleAlignmentArea.getLeft(), doubleRectangle2 != null ? doubleRectangle2.getBottom() : plotOuterBounds.getTop(), titleAlignmentArea.getWidth(), PlotLayoutUtil.INSTANCE.titleThickness$plot_builder(subtitle, PlotLabelSpecFactory.INSTANCE.plotSubtitle(plotTheme), plotTheme.subtitleMargins()));
        DoubleRectangle textRect = this.textRectangle(elementRect, plotTheme.subtitleMargins());
        return new Pair((Object)elementRect, (Object)textRect);
    }

    @NotNull
    public final Pair<DoubleRectangle, DoubleRectangle> captionElementAndTextBounds(@Nullable String caption, @NotNull DoubleRectangle plotOuterBounds, @NotNull DoubleRectangle geomAreaBounds, @NotNull PlotTheme plotTheme) {
        DoubleRectangle doubleRectangle;
        Intrinsics.checkNotNullParameter((Object)plotOuterBounds, (String)"plotOuterBounds");
        Intrinsics.checkNotNullParameter((Object)geomAreaBounds, (String)"geomAreaBounds");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        if (caption == null) {
            return new Pair(null, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[plotTheme.captionPosition().ordinal()]) {
            case 1: {
                doubleRectangle = geomAreaBounds;
                break;
            }
            case 2: {
                doubleRectangle = plotOuterBounds;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleRectangle captionAlignmentArea = doubleRectangle;
        String it = caption;
        boolean bl = false;
        double captionRectHeight = PlotLayoutUtil.INSTANCE.titleThickness$plot_builder(caption, PlotLabelSpecFactory.INSTANCE.plotCaption(plotTheme), plotTheme.captionMargins());
        DoubleRectangle elementRect = new DoubleRectangle(captionAlignmentArea.getLeft(), plotOuterBounds.getBottom() - captionRectHeight, captionAlignmentArea.getWidth(), captionRectHeight);
        DoubleRectangle textRect = this.textRectangle(elementRect, plotTheme.captionMargins());
        return new Pair((Object)elementRect, (Object)textRect);
    }

    public final void addTitle(@NotNull SvgComponent svgComponent2, @Nullable String text2, @NotNull LabelSpec labelSpec, @NotNull TextJustification justification, @NotNull DoubleRectangle boundRect, @Nullable TextJustification.Companion.TextRotation rotation, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)svgComponent2, (String)"svgComponent");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)justification, (String)"justification");
        Intrinsics.checkNotNullParameter((Object)boundRect, (String)"boundRect");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (text2 == null) {
            return;
        }
        double lineHeight = labelSpec.height();
        Label textLabel = new Label(text2, 0, labelSpec.getMarkdown(), 2, null);
        textLabel.addClassName(className);
        Pair<DoubleVector, Text.HorizontalAnchor> pair2 = TextJustification.Companion.applyJustification(boundRect, PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(text2, labelSpec), lineHeight, justification, rotation);
        DoubleVector position = (DoubleVector)pair2.component1();
        Text.HorizontalAnchor hAnchor = (Text.HorizontalAnchor)((Object)pair2.component2());
        textLabel.setLineHeight(lineHeight);
        textLabel.setHorizontalAnchor(hAnchor);
        textLabel.moveTo(position);
        TextJustification.Companion.TextRotation textRotation = rotation;
        if (textRotation != null) {
            double p0 = textRotation.getAngle();
            boolean bl = false;
            textLabel.rotate(p0);
        }
        svgComponent2.add(textLabel);
    }

    public static /* synthetic */ void addTitle$default(PlotSvgComponentHelper plotSvgComponentHelper, SvgComponent svgComponent2, String string, LabelSpec labelSpec, TextJustification textJustification, DoubleRectangle doubleRectangle, TextJustification.Companion.TextRotation textRotation, String string2, int n, Object object) {
        if ((n & 0x20) != 0) {
            textRotation = null;
        }
        plotSvgComponentHelper.addTitle(svgComponent2, string, labelSpec, textJustification, doubleRectangle, textRotation, string2);
    }

    public final void drawTitleDebugInfo(@NotNull SvgComponent svgComponent2, @Nullable String title, @Nullable DoubleRectangle elementRect, @Nullable DoubleRectangle textRect, @NotNull PlotTheme plotTheme) {
        DoubleRectangle it;
        Intrinsics.checkNotNullParameter((Object)svgComponent2, (String)"svgComponent");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        DoubleRectangle doubleRectangle = textRect;
        if (doubleRectangle != null) {
            it = doubleRectangle;
            boolean bl = false;
            SvgComponent.drawDebugRect$default(svgComponent2, it, Color.Companion.getLIGHT_BLUE(), null, 4, null);
        }
        DoubleRectangle doubleRectangle2 = elementRect;
        if (doubleRectangle2 != null) {
            it = doubleRectangle2;
            boolean bl = false;
            SvgComponent.drawDebugRect$default(svgComponent2, it, Color.Companion.getGRAY(), null, 4, null);
        }
        if (title != null && textRect != null) {
            SvgComponent.drawDebugRect$default(svgComponent2, PlotSvgComponentHelper.textBoundingBox$default(this, title, textRect, PlotLabelSpecFactory.INSTANCE.plotTitle(plotTheme), plotTheme.titleJustification(), null, 16, null), Color.Companion.getDARK_GREEN(), null, 4, null);
        }
    }

    public final void drawSubtitleDebugInfo(@NotNull SvgComponent svgComponent2, @Nullable String subtitle, @Nullable DoubleRectangle elementRect, @Nullable DoubleRectangle textRect, @NotNull PlotTheme plotTheme) {
        DoubleRectangle it;
        Intrinsics.checkNotNullParameter((Object)svgComponent2, (String)"svgComponent");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        DoubleRectangle doubleRectangle = textRect;
        if (doubleRectangle != null) {
            it = doubleRectangle;
            boolean bl = false;
            SvgComponent.drawDebugRect$default(svgComponent2, it, Color.Companion.getLIGHT_BLUE(), null, 4, null);
        }
        DoubleRectangle doubleRectangle2 = elementRect;
        if (doubleRectangle2 != null) {
            it = doubleRectangle2;
            boolean bl = false;
            SvgComponent.drawDebugRect$default(svgComponent2, it, Color.Companion.getGRAY(), null, 4, null);
        }
        if (subtitle != null && textRect != null) {
            SvgComponent.drawDebugRect$default(svgComponent2, PlotSvgComponentHelper.textBoundingBox$default(this, subtitle, textRect, PlotLabelSpecFactory.INSTANCE.plotSubtitle(plotTheme), plotTheme.subtitleJustification(), null, 16, null), Color.Companion.getDARK_GREEN(), null, 4, null);
        }
    }

    public final void drawCaptionDebugInfo(@NotNull SvgComponent svgComponent2, @Nullable String caption, @Nullable DoubleRectangle elementRect, @Nullable DoubleRectangle textRect, @NotNull PlotTheme plotTheme) {
        DoubleRectangle it;
        Intrinsics.checkNotNullParameter((Object)svgComponent2, (String)"svgComponent");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        DoubleRectangle doubleRectangle = textRect;
        if (doubleRectangle != null) {
            it = doubleRectangle;
            boolean bl = false;
            SvgComponent.drawDebugRect$default(svgComponent2, it, Color.Companion.getLIGHT_BLUE(), null, 4, null);
        }
        DoubleRectangle doubleRectangle2 = elementRect;
        if (doubleRectangle2 != null) {
            it = doubleRectangle2;
            boolean bl = false;
            SvgComponent.drawDebugRect$default(svgComponent2, it, Color.Companion.getGRAY(), null, 4, null);
        }
        if (caption != null && textRect != null) {
            SvgComponent.drawDebugRect$default(svgComponent2, PlotSvgComponentHelper.textBoundingBox$default(this, caption, textRect, PlotLabelSpecFactory.INSTANCE.plotCaption(plotTheme), plotTheme.captionJustification(), null, 16, null), Color.Companion.getDARK_GREEN(), null, 4, null);
        }
    }

    @NotNull
    public final DoubleRectangle textBoundingBox(@NotNull String text2, @NotNull DoubleRectangle boundRect, @NotNull LabelSpec labelSpec, @NotNull TextJustification justification, @NotNull Orientation orientation) {
        DoubleRectangle doubleRectangle;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)boundRect, (String)"boundRect");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)justification, (String)"justification");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        DoubleVector textDimensions = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(text2, labelSpec);
        if (orientation.isHorizontal()) {
            double x2 = boundRect.getLeft() + boundRect.getWidth() * justification.getX() - (justification.getX() < 0.5 ? 0.0 : (justification.getX() == 0.5 ? textDimensions.getX() / (double)2 : textDimensions.getX()));
            doubleRectangle = new DoubleRectangle(x2, boundRect.getCenter().getY() - textDimensions.getY() / (double)2, textDimensions.getX(), textDimensions.getY());
        } else {
            double y2 = boundRect.getBottom() - boundRect.getHeight() * justification.getX() - (justification.getX() < 0.5 ? textDimensions.getX() : (justification.getX() == 0.5 ? textDimensions.getX() / (double)2 : 0.0));
            doubleRectangle = new DoubleRectangle(boundRect.getCenter().getX() - textDimensions.getY() / (double)2, y2, textDimensions.getY(), textDimensions.getX());
        }
        return doubleRectangle;
    }

    public static /* synthetic */ DoubleRectangle textBoundingBox$default(PlotSvgComponentHelper plotSvgComponentHelper, String string, DoubleRectangle doubleRectangle, LabelSpec labelSpec, TextJustification textJustification, Orientation orientation, int n, Object object) {
        if ((n & 0x10) != 0) {
            orientation = Orientation.TOP;
        }
        return plotSvgComponentHelper.textBoundingBox(string, doubleRectangle, labelSpec, textJustification, orientation);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TitlePosition.values().length];
            try {
                nArray[TitlePosition.PANEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TitlePosition.PLOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

