/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.toolwindow;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SpringMvcView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SpringMvcViewSettings
implements PersistentStateComponent<Settings> {
    private final Settings mySettings = new Settings();
    public static final Topic<Listener> TOPIC = new Topic("Spring MVC View settings", Listener.class);

    public static void fireSettingsChanged(@NotNull Project project, @NotNull ChangeType changeType) {
        if (project == null) {
            SpringMvcViewSettings.$$$reportNull$$$0(0);
        }
        if (changeType == null) {
            SpringMvcViewSettings.$$$reportNull$$$0(1);
        }
        ((Listener)project.getMessageBus().syncPublisher(TOPIC)).settingsChanged(changeType);
    }

    public static SpringMvcViewSettings getInstance(Project project) {
        return (SpringMvcViewSettings)project.getService(SpringMvcViewSettings.class);
    }

    @Nullable
    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(@NotNull Settings settings) {
        if (settings == null) {
            SpringMvcViewSettings.$$$reportNull$$$0(2);
        }
        XmlSerializerUtil.copyBean((Object)settings, (Object)this.mySettings);
    }

    public boolean isShowDoc() {
        return this.mySettings.showDoc;
    }

    public void setShowDoc(boolean value) {
        this.mySettings.showDoc = value;
    }

    public Set<RequestMethod> getRequestMethods() {
        return this.mySettings.requestMethods;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcViewSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fireSettingsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void settingsChanged(@NotNull ChangeType var1);
    }

    public static enum ChangeType {
        UPDATE_LIST,
        UPDATE_DETAILS;

    }

    public static class Settings {
        public volatile boolean showDoc = true;
        public Set<RequestMethod> requestMethods = EnumSet.allOf(RequestMethod.class);
    }
}

