/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient;

import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\bH$J\u001c\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H&J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u0018H&J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u001cH\u0004J\u0014\u0010!\u001a\u0004\u0018\u00010\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u001cH\u0004J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0002J\u0016\u0010,\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0002J\u0018\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a0\rH$J\b\u00102\u001a\u00020\u001aH$J\u0018\u00103\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u00020\nH\u0002\u00a8\u00065"}, d2={"Lcom/intellij/spring/mvc/webClient/SpringWebClientModel;", "", "<init>", "()V", "findHolders", "", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findHoldersUnderProgress", "getUrlApiMethods", "", "Lcom/intellij/psi/PsiMethod;", "hasApiClassUsages", "", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "getApiClasses", "Lcom/intellij/psi/PsiClass;", "findUrl", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "uriMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "findBaseUrl", "", "uExpression", "Lorg/jetbrains/uast/UExpression;", "findHttpMethod", "urlNode", "getExpressionValue", "argument", "getLocalVariableReferenceExpressionValue", "apiMethods", "searchMethodHolders", "", "method", "webClientScope", "holders", "", "Lcom/intellij/psi/PsiElement;", "getUastScope", "originalScope", "unionScope", "scopes", "excludePackages", "project", "Lcom/intellij/openapi/project/Project;", "getPackageBlackList", "getWebClientPackage", "getWebClientScope", "baseScope", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringWebClientModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringWebClientModel.kt\ncom/intellij/spring/mvc/webClient/SpringWebClientModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,138:1\n1563#2:139\n1634#2,3:140\n1563#2:156\n1634#2,3:157\n1617#2,9:162\n1869#2:171\n1870#2:174\n1626#2:175\n11879#3,9:143\n13805#3:152\n13806#3:154\n11888#3:155\n1#4:153\n1#4:172\n1#4:173\n37#5,2:160\n*S KotlinDebug\n*F\n+ 1 SpringWebClientModel.kt\ncom/intellij/spring/mvc/webClient/SpringWebClientModel\n*L\n92#1:139\n92#1:140,3\n102#1:156\n102#1:157,3\n117#1:162,9\n117#1:171\n117#1:174\n117#1:175\n98#1:143,9\n98#1:152\n98#1:154\n98#1:155\n98#1:153\n117#1:173\n102#1:160,2\n*E\n"})
public abstract class SpringWebClientModel {
    @NotNull
    public final Set<WebClientHolder> findHolders(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.findHoldersUnderProgress(module, scope);
    }

    private final Set<WebClientHolder> findHoldersUnderProgress(Module module, GlobalSearchScope scope) {
        return this.findHoldersUnderProgress(this.getUrlApiMethods(module), module, scope);
    }

    @NotNull
    protected abstract List<PsiMethod> getUrlApiMethods(@NotNull Module var1);

    private final boolean hasApiClassUsages(ScopedCacheValueHolder<?> query, GlobalSearchScope scope) {
        List<PsiClass> apiClasses = this.getApiClasses(query);
        if (apiClasses.isEmpty()) {
            return false;
        }
        GlobalSearchScope webClientScope = this.getWebClientScope(query.getProject(), scope);
        return !Intrinsics.areEqual((Object)webClientScope, (Object)GlobalSearchScope.EMPTY_SCOPE);
    }

    @NotNull
    public abstract List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> var1);

    @NotNull
    public final List<WebClientUrl> findUrl(@NotNull UCallExpression uriMethodCall) {
        String string;
        String httpMethod;
        Intrinsics.checkNotNullParameter((Object)uriMethodCall, (String)"uriMethodCall");
        if (uriMethodCall.getValueArgumentCount() == 0) {
            return CollectionsKt.emptyList();
        }
        UExpression uExpression = uriMethodCall.getArgumentForParameter(0);
        if (uExpression == null) {
            return CollectionsKt.emptyList();
        }
        UExpression argument = uExpression;
        PsiElement psiElement = argument.getSourcePsi();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement sourcePsi = psiElement;
        String string2 = this.getExpressionValue(argument);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String calculatedUri = string2;
        ArrayList<WebClientUrl> urlCollector = new ArrayList<WebClientUrl>();
        String string3 = this.findHttpMethod(uriMethodCall);
        if (string3 == null) {
            string3 = httpMethod = "GET";
        }
        if ((string = this.findBaseUrl((UExpression)UastUtils.getOutermostQualified((UExpression)((UExpression)uriMethodCall)))) == null) {
            string = "";
        }
        String baseUrl = string;
        urlCollector.add(new WebClientUrl(sourcePsi, baseUrl + calculatedUri, httpMethod));
        return urlCollector;
    }

    @Nullable
    public abstract String findBaseUrl(@Nullable UExpression var1);

    @Nullable
    public abstract String findHttpMethod(@NotNull UCallExpression var1);

    @Nullable
    protected final String getExpressionValue(@Nullable UExpression argument) {
        String exactValue;
        if (argument == null) {
            return null;
        }
        String string = exactValue = UastUtils.evaluateString((UExpression)argument);
        if (string != null) {
            return string;
        }
        UStringConcatenationsFacade concatenationsFacade = UStringConcatenationsFacade.Companion.createFromUExpression$default((UStringConcatenationsFacade.Companion)UStringConcatenationsFacade.Companion, (UExpression)argument, (boolean)false, (int)2, null);
        if (concatenationsFacade == null) {
            return this.getLocalVariableReferenceExpressionValue(argument);
        }
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return null;
        }
        return UrlPathModelKt.getEndpointUrlPresentation((PartiallyKnownString)concatenationsFacade.asPartiallyKnownString());
    }

    @Nullable
    protected final String getLocalVariableReferenceExpressionValue(@Nullable UExpression argument) {
        PsiVariable resolve2;
        if (!(argument instanceof UReferenceExpression)) {
            return null;
        }
        PsiElement psiElement = ((UReferenceExpression)argument).resolve();
        PsiVariable psiVariable = resolve2 = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
        return this.getExpressionValue((UExpression)UastContextKt.toUElement((PsiElement)((PsiElement)(psiVariable != null ? psiVariable.getInitializer() : null)), UExpression.class));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<WebClientHolder> findHoldersUnderProgress(List<? extends PsiMethod> apiMethods, Module module, GlobalSearchScope scope) {
        void $this$mapTo$iv$iv;
        if (apiMethods.isEmpty()) {
            return SetsKt.emptySet();
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GlobalSearchScope webClientScope = this.getWebClientScope(project, scope);
        if (Intrinsics.areEqual((Object)webClientScope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return SetsKt.emptySet();
        }
        HashSet holders = new HashSet();
        for (PsiMethod psiMethod : apiMethods) {
            this.searchMethodHolders(psiMethod, webClientScope, holders);
        }
        Iterable $this$map$iv = holders;
        boolean bl = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new WebClientHolder((PsiElement)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void searchMethodHolders(PsiMethod method, GlobalSearchScope webClientScope, Set<PsiElement> holders) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        VirtualFile[] methodIdFiles;
        CacheManager cacheManager = CacheManager.getInstance((Project)method.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"getInstance(...)");
        CacheManager cacheManager2 = cacheManager;
        VirtualFile[] virtualFileArray = cacheManager2.getVirtualFilesWithWord(method.getName(), (short)1, webClientScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getVirtualFilesWithWord(...)");
        VirtualFile[] virtualFileArray2 = methodIdFiles = virtualFileArray;
        Set<PsiElement> set = holders;
        boolean $i$f$mapNotNull = false;
        void var8_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiFile it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void virtualFile = element$iv$iv;
            boolean bl2 = false;
            if (method.getManager().findFile((VirtualFile)virtualFile) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        set.addAll((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope getUastScope(GlobalSearchScope originalScope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = UastLanguagePlugin.Companion.getInstances();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLanguage().getAssociatedFileType());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LanguageFileType[] fileTypes = thisCollection$iv.toArray(new LanguageFileType[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, (FileType[])((FileType[])Arrays.copyOf(fileTypes, fileTypes.length)));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        return globalSearchScope;
    }

    private final GlobalSearchScope unionScope(List<? extends GlobalSearchScope> scopes) {
        GlobalSearchScope globalSearchScope;
        if (scopes.isEmpty()) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"EMPTY_SCOPE");
        } else {
            GlobalSearchScope globalSearchScope3 = GlobalSearchScope.union((Collection)scopes);
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"union(...)");
        }
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope excludePackages(Project project, GlobalSearchScope scope) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Iterable iterable = this.getPackageBlackList();
        SpringWebClientModel springWebClientModel = this;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GlobalSearchScope globalSearchScope;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String pkg = (String)element$iv$iv;
            boolean bl2 = false;
            if (javaPsiFacade.findPackage(pkg) != null) {
                PsiPackage it;
                boolean bl3 = false;
                globalSearchScope = PackageScope.packageScope((PsiPackage)it, (boolean)false);
            } else {
                globalSearchScope = null;
            }
            if (globalSearchScope == null) continue;
            GlobalSearchScope it$iv$iv = globalSearchScope;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        GlobalSearchScope excludedPackagesScope = springWebClientModel.unionScope((List)destination$iv$iv);
        GlobalSearchScope globalSearchScope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)excludedPackagesScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"intersectWith(...)");
        return globalSearchScope;
    }

    @NotNull
    protected abstract List<String> getPackageBlackList();

    @NotNull
    protected abstract String getWebClientPackage();

    private final GlobalSearchScope getWebClientScope(Project project, GlobalSearchScope baseScope) {
        GlobalSearchScope nonBlackListScope = this.excludePackages(project, this.getUastScope(baseScope));
        CacheManager cacheManager = CacheManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"getInstance(...)");
        CacheManager cacheManager2 = cacheManager;
        Object[] objectArray = cacheManager2.getVirtualFilesWithWord(this.getWebClientPackage(), (short)1, nonBlackListScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getVirtualFilesWithWord(...)");
        Object[] containingFiles = objectArray;
        if (containingFiles.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)ArraysKt.toList((Object[])containingFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        return globalSearchScope;
    }
}

