/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVar;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.utils.ArrayHelper;
import com.intellij.rml.dfa.utils.Cancellation;

public class RelExprBinary
extends RelExpr {
    public static final int UNITE = 0;
    public static final int INTERSECT = 1;
    public static final int IMPLICATE = 2;
    public static final int SUBTRACT = 3;
    private final int opCode;
    private RelExpr left;
    private RelExpr right;
    private boolean isSemiNaive;
    private boolean isUpdateOperation;

    public RelExprBinary(int opCode, RelExpr left2, RelExpr right2, Context context) {
        super(context, left2, right2);
        this.opCode = opCode;
        this.left = left2;
        this.right = right2;
    }

    public RelExpr getLeft() {
        return this.left;
    }

    public RelExpr getRight() {
        return this.right;
    }

    public void setSemiNaive(boolean semiNaive) {
        this.isSemiNaive = semiNaive;
    }

    public boolean isUpdateOperation() {
        return this.isUpdateOperation;
    }

    public void setUpdateOperation(boolean updateOperation) {
        this.isUpdateOperation = updateOperation;
    }

    @Override
    public void accept(RelExprVisitor visitor2) {
        if (visitor2.visitBinaryStart(this)) {
            this.left.accept(visitor2);
            this.right.accept(visitor2);
        }
        visitor2.visitBinaryEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        this.left = this.left.transform(transformer);
        this.right = this.right.transform(transformer);
        return transformer.transformBinary(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return ArrayHelper.uniteArrays(this.left.getDomains(variablesManager, domainsPool), this.right.getDomains(variablesManager, domainsPool), Domain.class);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        IRelation result;
        IRelation leftResult;
        String relName;
        IRelation rightRelation;
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        IRelation cached = variablesManager.getRelation(this.getResultCacheRelName(), cancellation);
        if (this.canBeCached && cached != null) {
            return cached.getClone();
        }
        IRelation iRelation = rightRelation = this.right instanceof RelExprVar ? variablesManager.getRelation(((RelExprVar)this.right).getRelName(), cancellation) : null;
        if (this.isUpdateOperation) {
            relName = ((RelExprVar)this.left).getRelName();
            leftResult = relationsManager.makeRepositoryRelation(variablesManager.getRelation(relName, cancellation), relName);
        } else {
            leftResult = rightRelation != null && rightRelation.isEmpty() && this.opCode == 1 && !this.isSemiNaive ? relationsManager.makeEmptyRelation(this.left.getDomains(variablesManager, domainsPool)) : this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        }
        IRelation rightResult = leftResult.isEmpty() && (this.opCode == 1 || this.opCode == 3) && !this.isSemiNaive ? relationsManager.makeEmptyRelation(this.right.getDomains(variablesManager, domainsPool)) : this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        cancellation.checkCancelled();
        if (this.isUpdateOperation) {
            relName = ((RelExprVar)this.left).getRelName();
            rightResult = rightResult.extendDomains(this.left.getDomains(variablesManager, domainsPool), this.toShortString() + "[" + this.astNodeId + "]");
            rightResult = rightResult.fastRename(variablesManager.getRelationDomains(relName), cancellation);
        }
        if (this.isSemiNaive) {
            String leftSumRelName = "SemiNaiveCache" + this.left.astNodeId;
            String rightSumRelName = "SemiNaiveCache" + this.right.astNodeId;
            IRelation leftSum = variablesManager.getRelation(leftSumRelName, cancellation);
            IRelation rightSum = variablesManager.getRelation(rightSumRelName, cancellation);
            if (leftSum != null) {
                leftSum = leftSum.unsafeUnite(leftResult, cancellation);
                leftSum.kill();
            } else {
                leftSum = leftResult;
            }
            if (rightSum != null) {
                rightSum = rightSum.unsafeUnite(rightResult, cancellation);
                rightSum.kill();
            } else {
                rightSum = rightResult;
            }
            variablesManager.storeRelation(leftSumRelName, leftSum);
            variablesManager.storeRelation(rightSumRelName, rightSum);
            result = leftResult.unsafeIntersect(rightSum, cancellation).unsafeUnite(leftSum.unsafeIntersect(rightResult, cancellation), cancellation);
        } else if (this.opCode == 0) {
            result = leftResult.unsafeUnite(rightResult, cancellation);
        } else if (this.opCode == 1) {
            result = leftResult.unsafeIntersect(rightResult, cancellation);
        } else if (this.opCode == 3) {
            IRelation rightResultComplement = rightResult.complement(cancellation);
            result = leftResult.unsafeIntersect(rightResultComplement, cancellation);
            rightResultComplement.kill();
        } else if (this.opCode == 2) {
            IRelation leftResultComplement = leftResult.complement(cancellation);
            result = leftResultComplement.unsafeUnite(rightResult, cancellation);
            leftResultComplement.kill();
        } else {
            throw new DfaInternalException("Unknown op code " + this.opCode);
        }
        leftResult.kill();
        rightResult.kill();
        variablesManager.storeRelation(this.getResultCacheRelName(), result.getClone());
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
        return result;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public RelExpr getLeftOperand() {
        return this.left;
    }

    public RelExpr getRightOperand() {
        return this.right;
    }

    @Override
    public String toLongString() {
        return "RelExprBinary{opCode=" + this.opCode + ", left=" + this.left.toLongString() + ", right=" + this.right.toLongString() + "}";
    }

    @Override
    public String toShortString() {
        String operation = switch (this.opCode) {
            case 0 -> "+";
            case 3 -> "-";
            case 1 -> "*";
            case 2 -> "=>";
            default -> throw new DfaInternalException();
        };
        Object leftStr = this.left.toShortString();
        Object rightStr = this.right.toShortString();
        if (this.opCode == 1) {
            if (this.left instanceof RelExprBinary && ((RelExprBinary)this.left).opCode != 1) {
                leftStr = "(" + (String)leftStr + ")";
            }
            if (this.right instanceof RelExprBinary && ((RelExprBinary)this.right).opCode != 1) {
                rightStr = "(" + (String)rightStr + ")";
            }
        }
        return (String)leftStr + " " + operation + " " + (String)rightStr;
    }
}

