/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringElementStub;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringElementImpl<StubT extends JSDestructuringElementStub<?>>
extends JSStubElementImpl<StubT>
implements JSDestructuringElement {
    public JSDestructuringElementImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringElementImpl(StubT stub, IElementType elementType) {
        super(stub, elementType);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        JSDestructuringContainer destructuringContainer;
        if (processor == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(2);
        }
        if ((destructuringContainer = (JSDestructuringContainer)PsiTreeUtil.getChildOfType((PsiElement)this, JSDestructuringContainer.class)) != null) {
            return destructuringContainer.processDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDestructuringElementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringElement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public JSDestructuringContainer getTarget() {
        PsiElement child = JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSElementTypes.DESTRUCTURING_CONTAINERS);
        return child instanceof JSDestructuringContainer ? (JSDestructuringContainer)child : null;
    }

    @Override
    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    @Override
    @Nullable
    public JSExpression getInitializerOrStub() {
        JSDestructuringElementStub stub = (JSDestructuringElementStub)this.getStub();
        if (stub != null) {
            if (!stub.hasOwnInitializer()) {
                return null;
            }
            StubElement<?> initializerStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, true);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getInitializer();
    }

    @Override
    public boolean hasOwnInitializer() {
        JSDestructuringElementStub stub = (JSDestructuringElementStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasOwnInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public JSType getJSType() {
        JSTypeDeclaration element = this.getTypeElement();
        if (element != null) {
            return element.getJSType();
        }
        JSType typeFromInitializer = this.buildTypeFromInitializer();
        if (typeFromInitializer != null) {
            return typeFromInitializer;
        }
        return null;
    }

    @Nullable
    protected JSType buildTypeFromInitializer() {
        if (DialectDetector.isTypeScript((PsiElement)this)) {
            JSExpression initializer;
            JSExpression jSExpression = initializer = this.hasInitializer() ? this.getInitializer() : null;
            if (initializer != null) {
                return new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        }
        return null;
    }

    @Nullable
    public JSTypeDeclaration getTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    public void delete() throws IncorrectOperationException {
        if (JSVarStatementBase.handleChildDeletion(this)) {
            return;
        }
        PsiElement parent = this.getParent();
        if (JSDestructuringUtil.isDestructuring(parent)) {
            if (parent instanceof JSDestructuringArray) {
                JSVariableBaseImpl.removeDestructuringArrayItem((JSDestructuringArray)parent, (PsiElement)this);
            } else {
                parent.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

