/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.config.JSConfigService;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfigService
extends JSConfigService {
    public boolean isAccessible(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    @NotNull
    public Condition<VirtualFile> getAccessScope(@NotNull VirtualFile var1);

    @NotNull
    @ApiStatus.Internal
    default public IntPredicate getFilterId(@NotNull VirtualFile scope, boolean useProjectScopeGraph) {
        if (scope == null) {
            TypeScriptConfigService.$$$reportNull$$$0(0);
        }
        IntPredicate intPredicate = this.getFilterId(scope);
        if (intPredicate == null) {
            TypeScriptConfigService.$$$reportNull$$$0(1);
        }
        return intPredicate;
    }

    @NotNull
    public IntPredicate getFilterId(@NotNull VirtualFile var1);

    @NotNull
    default public Condition<VirtualFile> getIsInGraphCondition(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigService.$$$reportNull$$$0(2);
        }
        Condition<VirtualFile> condition = this.getAccessScope(scope);
        if (condition == null) {
            TypeScriptConfigService.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @ApiStatus.Experimental
    @NotNull
    default public GlobalSearchScope createConfigScope(final @NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigService.$$$reportNull$$$0(4);
        }
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return TypeScriptConfigService.this.configGraphIncludesFile(file, config);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public TypeScriptConfig getPreferableConfig(@Nullable VirtualFile var1);

    @Nullable
    @ApiStatus.Experimental
    public TypeScriptConfig getPreferableOrParentConfig(@Nullable VirtualFile var1);

    @Nullable
    @ApiStatus.Experimental
    public TypeScriptConfig getDirectIncludePreferableConfig(@Nullable VirtualFile var1);

    @NotNull
    public List<VirtualFile> getRootConfigFiles();

    default public boolean configGraphIncludesFile(@NotNull VirtualFile file, @NotNull TypeScriptConfig tsConfig) {
        if (file == null) {
            TypeScriptConfigService.$$$reportNull$$$0(5);
        }
        if (tsConfig == null) {
            TypeScriptConfigService.$$$reportNull$$$0(6);
        }
        return tsConfig.getInclude().accept(file);
    }

    @Nullable
    public TypeScriptConfig parseConfigFile(@Nullable VirtualFile var1);

    @ApiStatus.Experimental
    default public void addConfigListener(@NotNull TypeScriptConfigListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            TypeScriptConfigService.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            TypeScriptConfigService.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    public ModificationTracker getTracker();

    public boolean isImplicitIncludedNodeModulesFile(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3);

    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsInGraphCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilterId";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIsInGraphCondition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configGraphIncludesFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConfigListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface IntPredicate {
        public boolean contains(int var1);
    }

    public static final class Provider {
        public static boolean isAccessible(@NotNull Project project, @NotNull VirtualFile scope, @NotNull VirtualFile referencedFile) {
            if (project == null) {
                Provider.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                Provider.$$$reportNull$$$0(1);
            }
            if (referencedFile == null) {
                Provider.$$$reportNull$$$0(2);
            }
            TypeScriptConfigService service = Provider.get(project);
            return service.isAccessible(scope, referencedFile);
        }

        @NotNull
        public static TypeScriptConfigService get(@NotNull Project project) {
            if (project == null) {
                Provider.$$$reportNull$$$0(3);
            }
            TypeScriptConfigService typeScriptConfigService = (TypeScriptConfigService)project.getService(TypeScriptConfigService.class);
            if (typeScriptConfigService == null) {
                Provider.$$$reportNull$$$0(4);
            }
            return typeScriptConfigService;
        }

        public static boolean isAccessible(@NotNull PsiElement source, @NotNull PsiElement reference) {
            if (source == null) {
                Provider.$$$reportNull$$$0(5);
            }
            if (reference == null) {
                Provider.$$$reportNull$$$0(6);
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)source);
            VirtualFile ref = PsiUtilCore.getVirtualFile((PsiElement)reference);
            if (file == null || ref == null) {
                return true;
            }
            return Provider.isAccessible(source.getProject(), file, ref);
        }

        public static GlobalSearchScope getConfigResolveScope(@NotNull PsiElement context) {
            if (context == null) {
                Provider.$$$reportNull$$$0(7);
            }
            Project project = context.getProject();
            GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope(context);
            if (!Provider.checkProject(project)) {
                return defaultScope;
            }
            TypeScriptConfigService service = Provider.get(project);
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context);
            if (virtualFile == null) {
                return defaultScope;
            }
            IntPredicate predicate = service.getFilterId(virtualFile, false);
            return new GlobalSearchScopeWithIdFilter(defaultScope, predicate);
        }

        private static boolean checkProject(@Nullable Project project) {
            return project != null && !project.isDefault() && !project.isDisposed();
        }

        public static TypeScriptConfig parseConfigFile(Project project, @Nullable VirtualFile file) {
            if (file == null || !Provider.checkProject(project)) {
                return null;
            }
            TypeScriptConfigService service = Provider.get(project);
            return service.parseConfigFile(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAccessible";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigResolveScope";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

