/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.server.TomcatWslInspector;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "toWslEnvVariables", "", "", "envVariables", "intellij.javaee.appServers.tomcat"})
public final class TomcatWslSupportUtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Map<String, String> toWslEnvVariables(@NotNull Map<String, String> envVariables) {
        String string;
        Object object;
        String wslPath;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(envVariables, (String)"envVariables");
        String string2 = envVariables.get("CATALINA_HOME");
        if (string2 == null) {
            string2 = envVariables.get("CATALINA_TMPDIR");
        }
        if ((objectArray = (Object[])(wslPath = string2)) == null || objectArray.length() == 0 || !WslSupportUtil.isWslPath((String)wslPath)) {
            LOG.warn("Unable to convert environment variables - no WSL path provided");
            objectArray = new Object[]{envVariables.get("CATALINA_HOME")};
            throw new ExecutionException(TomcatBundle.message("tomcat.wsl.env.vars.conversion.error", objectArray));
        }
        Map wslEnvVariables = MapsKt.toMutableMap(envVariables);
        if (envVariables.containsKey("CATALINA_BASE")) {
            String string3 = envVariables.get("CATALINA_BASE");
            Intrinsics.checkNotNull((Object)string3);
            wslEnvVariables.put("CATALINA_BASE", WslSupportUtil.fromWinToLinuxMntPath((String)wslPath, (String)string3));
        }
        if (envVariables.containsKey("CATALINA_TMPDIR")) {
            String string4 = envVariables.get("CATALINA_TMPDIR");
            Intrinsics.checkNotNull((Object)string4);
            String catalinaTmpDir = string4;
            object = wslEnvVariables;
            string = "CATALINA_TMPDIR";
            String string5 = WslSupportUtil.fromWslToLinuxPath((String)catalinaTmpDir);
            if (string5 == null) {
                string5 = catalinaTmpDir;
            }
            String string6 = string5;
            object.put(string, string6);
        }
        if (envVariables.containsKey("CATALINA_HOME")) {
            Map map = wslEnvVariables;
            object = "CATALINA_HOME";
            String string7 = WslSupportUtil.fromWslToLinuxPath((String)wslPath);
            if (string7 == null) {
                string7 = wslPath;
            }
            string = string7;
            map.put(object, string);
        }
        if (envVariables.containsKey("JAVA_OPTS")) {
            String string8 = envVariables.get("JAVA_OPTS");
            Intrinsics.checkNotNull((Object)string8);
            wslEnvVariables.put("JAVA_OPTS", string8);
        }
        return wslEnvVariables;
    }

    static {
        Logger logger = Logger.getInstance(TomcatWslInspector.INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

