/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.model;

import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedObjectDefinition;
import com.intellij.swagger.core.diff.model.SwModifiedRootElement;
import com.intellij.swagger.core.diff.model.SwModifiedSpecification;
import com.intellij.swagger.core.diff.model.SwModifiedUrl;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u000f0\u001aH\u0016J$\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00162\b\u0010\u0005\u001a\u0004\u0018\u00010\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/swagger/core/diff/model/SwModifiedSpecification;", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "original", "modified", "<init>", "(Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;)V", "getOriginal", "()Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "getModified", "root", "getRoot", "()Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "myUrlsDiff", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "Lcom/intellij/swagger/core/model/api/SwUrl;", "getMyUrlsDiff", "()Lcom/intellij/swagger/core/diff/SwDiffResult;", "myUrlsDiff$delegate", "Lkotlin/Lazy;", "myDefinitionsDiff", "Lcom/intellij/swagger/core/model/api/SwDefinition;", "getMyDefinitionsDiff", "myDefinitionsDiff$delegate", "computeChildrenDiffs", "", "", "getModifiedDefinitionOrNull", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwModifiedSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwModifiedSpecification.kt\ncom/intellij/swagger/core/diff/model/SwModifiedSpecification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n295#2,2:47\n295#2,2:49\n295#2,2:51\n*S KotlinDebug\n*F\n+ 1 SwModifiedSpecification.kt\ncom/intellij/swagger/core/diff/model/SwModifiedSpecification\n*L\n37#1:47,2\n38#1:49,2\n41#1:51,2\n*E\n"})
public final class SwModifiedSpecification
implements SwModifiedElement<SwSpecificationFile>,
SwModifiedRootElement {
    @NotNull
    private final SwSpecificationFile original;
    @NotNull
    private final SwSpecificationFile modified;
    @NotNull
    private final SwModifiedRootElement root;
    @NotNull
    private final Lazy myUrlsDiff$delegate;
    @NotNull
    private final Lazy myDefinitionsDiff$delegate;

    public SwModifiedSpecification(@NotNull SwSpecificationFile original, @NotNull SwSpecificationFile modified) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        this.original = original;
        this.modified = modified;
        this.root = this;
        this.myUrlsDiff$delegate = LazyKt.lazy(() -> SwModifiedSpecification.myUrlsDiff_delegate$lambda$0(this));
        this.myDefinitionsDiff$delegate = LazyKt.lazy(() -> SwModifiedSpecification.myDefinitionsDiff_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public SwSpecificationFile getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public SwSpecificationFile getModified() {
        return this.modified;
    }

    @Override
    @NotNull
    public SwModifiedRootElement getRoot() {
        return this.root;
    }

    private final SwDiffResult<SwUrl> getMyUrlsDiff() {
        Lazy lazy = this.myUrlsDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    private final SwDiffResult<SwDefinition> getMyDefinitionsDiff() {
        Lazy lazy = this.myDefinitionsDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    @NotNull
    public Collection<SwDiffResult<? extends Object>> computeChildrenDiffs() {
        Object[] objectArray = new SwDiffResult[]{this.getMyUrlsDiff(), this.getMyDefinitionsDiff()};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public SwDiffResult<SwDefinition> getModifiedDefinitionOrNull(@Nullable SwDefinition original, @Nullable SwDefinition modified) {
        Object v3;
        block8: {
            SwDefinition definition;
            SwDefinition swDefinition;
            Object v0;
            SwDefinition it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block6: {
                $this$firstOrNull$iv = this.getMyDefinitionsDiff().getCreated();
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (SwDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)modified)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            if ((swDefinition = (SwDefinition)v0) == null) {
                Object v2;
                block7: {
                    $this$firstOrNull$iv = this.getMyDefinitionsDiff().getRemoved();
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (SwDefinition)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)original)) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                swDefinition = v2;
            }
            if ((definition = swDefinition) != null) {
                return new SwDiffResult<SwDefinition>(modified, original);
            }
            Iterable $this$firstOrNull$iv2 = this.getMyDefinitionsDiff().getPreserved();
            boolean $i$f$firstOrNull2 = false;
            for (Object element$iv : $this$firstOrNull$iv2) {
                SwModifiedElement it2 = (SwModifiedElement)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it2.getOriginal(), (Object)original) && Intrinsics.areEqual(it2.getModified(), (Object)modified))) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        SwModifiedElement swModifiedElement = v3;
        if (swModifiedElement == null) {
            return null;
        }
        SwModifiedElement modifiedElement = swModifiedElement;
        return new SwDiffResult<SwDefinition>(SetsKt.emptySet(), SetsKt.emptySet(), SetsKt.setOf((Object)modifiedElement));
    }

    private static final SwDiffResult myUrlsDiff_delegate$lambda$0(SwModifiedSpecification this$0) {
        return SwDiffUtilsKt.calculateDiffBetween((Collection)this$0.getOriginal().getUrls(), (Collection)this$0.getModified().getUrls(), (Function1)myUrlsDiff.2.1.INSTANCE, (arg_0, arg_1) -> SwModifiedSpecification.myUrlsDiff_delegate$lambda$0$0(this$0, arg_0, arg_1));
    }

    private static final SwModifiedElement myUrlsDiff_delegate$lambda$0$0(SwModifiedSpecification this$0, SwUrl before, SwUrl after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedUrl(before, after, this$0.getRoot());
    }

    private static final SwDiffResult myDefinitionsDiff_delegate$lambda$0(SwModifiedSpecification this$0) {
        return SwDiffUtilsKt.calculateDiffBetween((Collection)this$0.getOriginal().getAllLocalObjectDefinitions(), (Collection)this$0.getModified().getAllLocalObjectDefinitions(), (Function1)myDefinitionsDiff.2.1.INSTANCE, (arg_0, arg_1) -> SwModifiedSpecification.myDefinitionsDiff_delegate$lambda$0$0(this$0, arg_0, arg_1));
    }

    private static final SwModifiedElement myDefinitionsDiff_delegate$lambda$0$0(SwModifiedSpecification this$0, SwDefinition before, SwDefinition after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedObjectDefinition(before, after, this$0.getRoot());
    }
}

