/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.quickfix;

import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpandStaticImportFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.family.expand.static.import", (Object[])new Object[0]);
        if (string == null) {
            ExpandStaticImportFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            ExpandStaticImportFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ExpandStaticImportFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            ExpandStaticImportFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiImportStaticReferenceElement) {
            PsiImportStaticReferenceElement referenceElement = (PsiImportStaticReferenceElement)element;
            PsiImportStaticStatement staticImport = ExpandStaticImportFix.getImportStaticStatement((PsiJavaCodeReferenceElement)referenceElement);
            List expressionToExpand = ImportsUtil.collectReferencesThrough((PsiFile)referenceElement.getContainingFile(), (PsiJavaCodeReferenceElement)referenceElement, (PsiImportStaticStatement)staticImport);
            ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)referenceElement, (PsiImportStaticStatement)staticImport);
        }
    }

    private static PsiImportStaticStatement getImportStaticStatement(PsiJavaCodeReferenceElement referenceElement) {
        PsiImportStaticStatement importStatic;
        PsiElement parent = referenceElement.getParent();
        return parent instanceof PsiImportStaticStatement ? (importStatic = (PsiImportStaticStatement)parent) : (PsiImportStaticStatement)ObjectUtils.tryCast((Object)referenceElement.advancedResolve(true).getCurrentFileResolveScope(), PsiImportStaticStatement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/quickfix/ExpandStaticImportFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/quickfix/ExpandStaticImportFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

