/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;

@NonNls
public final class SpringMessagingConstants {
    public static final String UTIL_TASK_EXECUTOR = "java.util.concurrent.Executor";
    public static final String TASK_EXECUTOR = "org.springframework.core.task.TaskExecutor";
    public static final String TASK_SCHEDULER = "org.springframework.scheduling.TaskScheduler";
    public static final String ERROR_HANDLER = "org.springframework.util.ErrorHandler";
    public static final String TRANSACTION_MANAGER = "org.springframework.transaction.PlatformTransactionManager";
    public static final String SUBSCRIBE_MAPPING = "org.springframework.messaging.simp.annotation.SubscribeMapping";
    public static final String SEND_TO_USER = "org.springframework.messaging.simp.annotation.SendToUser";
    public static final String MESSAGE_EXCEPTION_HANDLER = "org.springframework.messaging.handler.annotation.MessageExceptionHandler";
    public static final String JMS_OPERATIONS = "org.springframework.jms.core.JmsOperations";
    public static final String JMS_MESSAGE_OPERATIONS = "org.springframework.jms.core.JmsMessageOperations";
    public static final String JMS_TEMPLATE = "org.springframework.jms.core.JmsTemplate";
    public static final String JMS_MESSAGING_TEMPLATE = "org.springframework.jms.core.JmsMessagingTemplate";
    public static final String JMS_LISTENER = "org.springframework.jms.annotation.JmsListener";
    public static final String JMS_LISTENERS = "org.springframework.jms.annotation.JmsListeners";
    public static final String JMS_LISTENER_CONTAINER_FACTORY = "org.springframework.jms.config.JmsListenerContainerFactory";
    public static final String RABBIT_LISTENER = "org.springframework.amqp.rabbit.annotation.RabbitListener";
    public static final String RABBIT_LISTENERS = "org.springframework.amqp.rabbit.annotation.RabbitListeners";
    public static final String RABBIT_QUEUE_BINDING = "org.springframework.amqp.rabbit.annotation.QueueBinding";
    public static final String RABBIT_QUEUE = "org.springframework.amqp.rabbit.annotation.Queue";
    public static final String RABBIT_EXCHANGE = "org.springframework.amqp.rabbit.annotation.Exchange";
    public static final String KAFKA_LISTENER = "org.springframework.kafka.annotation.KafkaListener";
    public static final String KAFKA_LISTENERS = "org.springframework.kafka.annotation.KafkaListeners";
    public static final String KAFKA_TOPIC_PARTITION = "org.springframework.kafka.annotation.TopicPartition";
    public static final List<String> JMS_SEND_OPERATIONS_DESTINATION_METHODS = List.of("convertAndSend", "execute", "send");
    public static final List<String> JMS_RECEIVE_OPERATIONS_DESTINATION_METHODS = List.of("receive", "receiveAndConvert", "receiveSelected", "receiveSelectedAndConvert");
    public static final List<String> JMS_SEND_AND_RECEIVE_OPERATIONS_DESTINATION_METHODS = List.of("convertSendAndReceive", "sendAndReceive");
    public static final List<String> JMS_OPERATIONS_DESTINATION_METHODS = ContainerUtil.flatten(List.of(JMS_SEND_OPERATIONS_DESTINATION_METHODS, JMS_RECEIVE_OPERATIONS_DESTINATION_METHODS, JMS_SEND_AND_RECEIVE_OPERATIONS_DESTINATION_METHODS));
    public static final List<String> JMS_OPERATIONS_QUEUE_METHODS = List.of("browse", "browseSelected");
    public static final List<String> JMS_MESSAGE_SEND_OPERATIONS_METHODS = List.of("convertAndSend", "send");
    public static final List<String> JMS_MESSAGE_RECEIVE_OPERATIONS_METHODS = List.of("receive", "receiveAndConvert");
    public static final List<String> JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_METHODS = List.of("convertSendAndReceive", "sendAndReceive");
    public static final List<String> JMS_MESSAGE_OPERATIONS_METHODS = ContainerUtil.flatten(List.of(JMS_MESSAGE_SEND_OPERATIONS_METHODS, JMS_MESSAGE_RECEIVE_OPERATIONS_METHODS, JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_METHODS));
    public static final List<String> JMS_MESSAGING_TEMPLATE_METHODS = List.of("setDefaultDestinationName");
    public static final String RABBIT_OPERATIONS = "org.springframework.amqp.rabbit.core.RabbitOperations";
    public static final String RABBIT_TEMPLATE = "org.springframework.amqp.rabbit.core.RabbitTemplate";
    public static final String RABBIT_ADMIN = "org.springframework.amqp.rabbit.core.RabbitAdmin";
    public static final String AMQP_TEMPLATE = "org.springframework.amqp.core.AmqpTemplate";
    public static final String AMQP_ADMIN = "org.springframework.amqp.core.AmqpAdmin";
    public static final String AMQP_MESSAGE_CONVERTER = "org.springframework.amqp.support.converter.MessageConverter";
    public static final String AMQP_CONNECTION_FACTORY = "org.springframework.amqp.rabbit.connection.ConnectionFactory";
    public static final String AMQP_SIMPLE_LISTENER_CONTAINER = "org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer";
    public static final String AMQP_FANOUT_EXCHANGE = "org.springframework.amqp.core.FanoutExchange";
    public static final String AMQP_DIRECT_EXCHANGE = "org.springframework.amqp.core.DirectExchange";
    public static final String AMQP_TOPIC_EXCHANGE = "org.springframework.amqp.core.TopicExchange";
    public static final String AMQP_HEADERS_EXCHANGE = "org.springframework.amqp.core.HeadersExchange";
    public static final String AMQP_FEDERATED_EXCHANGE = "org.springframework.amqp.core.FederatedExchange";
    public static final String AMQP_QUEUE = "org.springframework.amqp.core.Queue";
    public static final String AMQP_EXCHANGE = "org.springframework.amqp.core.Exchange";
    public static final String RABBIT_MQ_CLIENT_CONNECTION_FACTORY = "com.rabbitmq.client.ConnectionFactory";
    public static final String RABBIT_CACHING_CONNECTION_FACTORY = "org.springframework.amqp.rabbit.connection.CachingConnectionFactory";
    public static final String RABBIT_BINDING = "org.springframework.amqp.core.Binding";
    public static final String RABBIT_BINDING_DESTINATION_TYPE = "org.springframework.amqp.core.Binding.DestinationType";
    public static final String RABBIT_QUEUE_BUILDER = "org.springframework.amqp.core.QueueBuilder";
    public static final String RABBIT_EXCHANGE_BUILDER = "org.springframework.amqp.core.ExchangeBuilder";
    public static final String RABBIT_LISTENER_CONTAINER_FACTORY = "org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory";
    public static final String RABBIT_LISTENER_ERROR_HANDLER = "org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler";
    public static final String RABBIT_REPLY_POST_PROCESSOR = "org.springframework.amqp.rabbit.listener.adapter.ReplyPostProcessor";
    public static final String KAFKA_OPERATIONS = "org.springframework.kafka.core.KafkaOperations";
    public static final String KAFKA_TEMPLATE = "org.springframework.kafka.core.KafkaTemplate";
    public static final String KAFKA_REPLYING_TEMPLATE = "org.springframework.kafka.requestreply.ReplyingKafkaTemplate";
    public static final String KAFKA_AGGREGATING_TEMPLATE = "org.springframework.kafka.requestreply.AggregatingReplyingKafkaTemplate";
    public static final String KAFKA_REACTIVE_TEMPLATE = "org.springframework.kafka.core.reactive.ReactiveKafkaConsumerTemplate";
    public static final String KAFKA_TOPIC_BUILDER = "org.springframework.kafka.config.TopicBuilder";
    public static final String KAFKA_LISTENER_CONTAINER_FACTORY = "org.springframework.kafka.config.KafkaListenerContainerFactory";
    public static final String KAFKA_LISTENER_ERROR_HANDLER = "org.springframework.kafka.listener.KafkaListenerErrorHandler";
    public static final String JMS_NAMESPACE_KEY = "Spring Jms namespace key";
    public static final String JMS_NAMESPACE = "http://www.springframework.org/schema/jms";
    public static final String RABBIT_NAMESPACE_KEY = "Spring Rabbit namespace key";
    public static final String RABBIT_NAMESPACE = "http://www.springframework.org/schema/rabbit";
    public static final String ACTIVE_NAMESPACE_KEY = "Spring Active namespace key";
    public static final String ACTIVE_NAMESPACE = "http://activemq.apache.org/schema/core";
    public static final List<String> SPRING_MQ_ANNOTATIONS = List.of("org.springframework.jms.annotation.JmsListener", "org.springframework.amqp.rabbit.annotation.RabbitListener", "org.springframework.kafka.annotation.KafkaListener");
    public static final String JAVAX_JMS_CONNECTION = "javax.jms.Connection";
    public static final String JAKARTA_JMS_CONNECTION = "jakarta.jms.Connection";
    public static final String JAVAX_JMS_CONNECTION_FACTORY = "javax.jms.ConnectionFactory";
    public static final String JAKARTA_JMS_CONNECTION_FACTORY = "jakarta.jms.ConnectionFactory";
    public static final String JAVAX_JMS_QUEUE_CONNECTION_FACTORY = "javax.jms.QueueConnectionFactory";
    public static final String JAKARTA_JMS_QUEUE_CONNECTION_FACTORY = "jakarta.jms.QueueConnectionFactory";
    public static final String JAVAX_JMS_EXCEPTION_LISTENER = "javax.jms.ExceptionListener";
    public static final String JAKARTA_JMS_EXCEPTION_LISTENER = "jakarta.jms.ExceptionListener";
    public static final String JAVAX_JMS_QUEUE = "javax.jms.Queue";
    public static final String JAKARTA_JMS_QUEUE = "jakarta.jms.Queue";
    public static final String JAVAX_JMS_TOPIC = "javax.jms.Topic";
    public static final String JAKARTA_JMS_TOPIC = "jakarta.jms.Topic";
    public static final String JAVAX_JMS_QUEUE_CONNECTION = "javax.jms.QueueConnection";
    public static final String JAKARTA_JMS_QUEUE_CONNECTION = "jakarta.jms.QueueConnection";
    public static final String JAVAX_JMS_TOPIC_CONNECTION = "javax.jms.TopicConnection";
    public static final String JAKARTA_JMS_TOPIC_CONNECTION = "jakarta.jms.TopicConnection";
    public static final String JAVAX_JMS_TOPIC_CONNECTION_FACTORY = "javax.jms.TopicConnectionFactory";
    public static final String JAKARTA_JMS_TOPIC_CONNECTION_FACTORY = "jakarta.jms.TopicConnectionFactory";
    public static final String JAVAX_JMS_MESSAGE_CONSUMER = "javax.jms.MessageConsumer";
    public static final String JAKARTA_JMS_MESSAGE_CONSUMER = "jakarta.jms.MessageConsumer";
    public static final String JAVAX_JMS_DIR_CONTEXT = "javax.naming.directory.DirContext";
    public static final String JAKARTA_JMS_DIR_CONTEXT = "jakarta.naming.directory.DirContext";
    public static final String JAVAX_JMS_MBEAN_SERVER = "javax.management.MBeanServer";
    public static final String JAKARTA_JMS_MBEAN_SERVER = "jakarta.management.MBeanServer";
    public static final String JAVAX_JMS_SSL_CONTEXT = "javax.net.ssl.SSLContext";
    public static final String JAKARTA_JMS_SSL_CONTEXT = "jakarta.net.ssl.SSLContext";

    private SpringMessagingConstants() {
    }
}

