/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.gutter.CdiBaseLineMarkerProvider;
import com.intellij.cdi.gutter.CdiGutterUtilsKt;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiEventObserves;
import com.intellij.cdi.jam.events.CdiEventObservesAsync;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.jam.JamService;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.semantic.SemService;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class CdiEventsModelClassAnnotator
extends CdiBaseLineMarkerProvider {
    private static final String FIRE_EVENT_METHOD = "fire";
    private static final String FIRE_ASYNC_EVENT_METHOD = "fireAsync";
    private static final List<String> OBSERVES_ANNOTATIONS = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION.jakarta(), CdiAnnoConstants.OBSERVES_ANNOTATION.javax(), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.jakarta(), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.javax());

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UCallExpression uCallExpression;
        UReferenceExpression uReferenceExpression;
        String referenceName;
        UElement uElement;
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(0);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(2);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)psiElement)) instanceof UIdentifier) {
            PsiElement psiElement2;
            UElement uParent = uElement.getUastParent();
            if (uParent instanceof UParameter && (psiElement2 = uParent.getJavaPsi()) instanceof PsiParameter) {
                PsiParameter psiParameter = (PsiParameter)psiElement2;
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, OBSERVES_ANNOTATIONS, (int)0)) {
                    CdiEventsModelClassAnnotator.annotateObserves(psiParameter, result, module);
                }
            } else if (uParent instanceof UField || uParent instanceof UMethod) {
                PsiClassType eventType = CdiEventsModelClassAnnotator.getEventPsiType(module);
                if (eventType == null) {
                    return;
                }
                PsiElement javaPsi = uParent.getJavaPsi();
                if (javaPsi == null) {
                    return;
                }
                CdiInject cdiInject = (CdiInject)SemService.getSemService((Project)module.getProject()).getSemElement(CdiInject.INJECT_JAM_KEY, javaPsi);
                if (cdiInject != null && !CdiInjectionUtils.getInjectionPointOfType((PsiType)eventType, cdiInject).isEmpty()) {
                    CdiEventsModelClassAnnotator.annotateEvents(cdiInject, result, module, CdiJamModel.getModel(module).getObserves());
                }
            }
        } else if (uElement instanceof UReferenceExpression && (FIRE_EVENT_METHOD.equals(referenceName = (uReferenceExpression = (UReferenceExpression)uElement).getResolvedName()) || FIRE_ASYNC_EVENT_METHOD.equals(referenceName)) && (uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uReferenceExpression, UCallExpression.class)) != null && CdiEventsModelClassAnnotator.isFireEventEventExpression(uCallExpression)) {
            CdiEventsModelClassAnnotator.annotateFireEventExpression(uCallExpression, module, result);
        }
    }

    public static boolean isFireEventEventExpression(@NotNull UCallExpression uCallExpression) {
        PsiMethod psiMethod;
        String methodName;
        if (uCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(3);
        }
        if ((FIRE_EVENT_METHOD.equals(methodName = uCallExpression.getMethodName()) || FIRE_ASYNC_EVENT_METHOD.equals(methodName)) && (psiMethod = uCallExpression.resolve()) != null) {
            PsiClass containingClass = psiMethod.getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)CdiClassesConstants.EVENT.fqn((PsiElement)psiMethod));
        }
        return false;
    }

    private static void annotateFireEventExpression(@NotNull UCallExpression uCallExpression, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Set<CdiObserves> observes;
        if (uCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(5);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(6);
        }
        if (!(observes = CdiEventsModelClassAnnotator.getObserves(uCallExpression, module)).isEmpty() && uCallExpression.getMethodIdentifier() != null && uCallExpression.getMethodIdentifier().getSourcePsi() != null) {
            PsiElement sourcePsi = uCallExpression.getMethodIdentifier().getSourcePsi();
            CdiEventsModelClassAnnotator.addGotoObservesIcon(result, sourcePsi, (NotNullLazyValue<Collection<? extends PsiElement>>)NotNullLazyValue.lazy(() -> ContainerUtil.mapNotNull((Collection)observes, cdiObserves -> cdiObserves.getPsiElement())));
        }
    }

    @NotNull
    private static Set<CdiObserves> getObserves(@NotNull UCallExpression uCallExpression, @NotNull Module module) {
        Set<CdiObserves> allObservesList;
        if (uCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(7);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(8);
        }
        if ((allObservesList = CdiJamModel.getModel(module).getObserves()).isEmpty()) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<CdiObserves> observes = CdiEventsModelClassAnnotator.getObserves(uCallExpression, module, allObservesList);
        if (observes.isEmpty()) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(10);
            }
            return set;
        }
        String methodName = uCallExpression.getMethodName();
        boolean isAsyncMethodCall = FIRE_ASYNC_EVENT_METHOD.equals(methodName);
        if (isAsyncMethodCall) {
            Set<CdiObserves> set = observes.stream().filter(async -> async instanceof CdiEventObservesAsync).collect(Collectors.toSet());
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(11);
            }
            return set;
        }
        Set<CdiObserves> set = observes.stream().filter(notAsync -> notAsync instanceof CdiEventObserves).collect(Collectors.toSet());
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static Set<CdiObserves> getObserves(@NotNull UCallExpression uCallExpression, Module module, Set<? extends CdiObserves> allObservesList) {
        CdiInject<?> injectedEvent;
        if (uCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(13);
        }
        if ((injectedEvent = CdiEventsModelClassAnnotator.getInjectedEvent(uCallExpression)) == null) {
            return CdiEventsModelClassAnnotator.collectObserves(CdiEventsModelClassAnnotator.getHandledEventType(uCallExpression), allObservesList);
        }
        return CdiEventsModelClassAnnotator.collectObserves(injectedEvent, allObservesList, module);
    }

    @Nullable
    private static CdiInject<?> getInjectedEvent(@NotNull UCallExpression uCallExpression) {
        PsiElement psiElement;
        UField uField;
        UReferenceExpression uReferenceExpression;
        PsiElement resolvedReference;
        UDeclaration uDeclaration;
        UExpression uExpression;
        if (uCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(14);
        }
        if ((uExpression = uCallExpression.getReceiver()) instanceof UReferenceExpression && (uDeclaration = (UDeclaration)UastContextKt.toUElement((PsiElement)(resolvedReference = (uReferenceExpression = (UReferenceExpression)uExpression).resolve()), UDeclaration.class)) != null && uDeclaration.getUastAnchor() != null && (uField = (UField)UastContextKt.getUastParentOfType((PsiElement)uDeclaration.getUastAnchor().getSourcePsi(), UField.class)) != null && (psiElement = uField.getJavaPsi()) instanceof PsiField) {
            PsiField psiField = (PsiField)psiElement;
            JamService jamService = JamService.getJamService((Project)psiField.getProject());
            return (CdiInject)jamService.getJamElement(CdiInject.INJECT_JAM_KEY, (PsiElement)psiField);
        }
        return null;
    }

    @Nullable
    private static PsiType getHandledEventType(@NotNull UCallExpression uCallExpression) {
        List arguments;
        if (uCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(15);
        }
        return !(arguments = uCallExpression.getValueArguments()).isEmpty() ? ((UExpression)arguments.get(0)).getExpressionType() : null;
    }

    @Nullable
    private static PsiClassType getEventPsiType(@NotNull Module module) {
        JavaPsiFacade psiFacade;
        PsiClass eventPsiClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(16);
        }
        if ((eventPsiClass = (psiFacade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass(CdiClassesConstants.EVENT.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return psiFacade.getElementFactory().createType(eventPsiClass);
        }
        return null;
    }

    private static void annotateObserves(@NotNull PsiParameter psiParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull Module module) {
        if (psiParameter == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(17);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(18);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(19);
        }
        CdiEventsModelClassAnnotator.addGotoFiresIcon(result, psiParameter, (NotNullLazyValue<Collection<? extends PsiElement>>)NotNullLazyValue.lazy(() -> ContainerUtil.mapNotNull(CdiEventsModelClassAnnotator.getFireEventPoints(psiParameter, module), firePoint -> ((PsiElement)firePoint.first).isValid() ? (PsiElement)firePoint.first : null)));
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventPoints(@NotNull PsiParameter psiParameter, @NotNull Module module) {
        if (psiParameter == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(20);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(21);
        }
        JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)CdiAnnoConstants.OBSERVES_ANNOTATION);
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)CdiAnnoConstants.OBSERVES_ANNOTATION.fqn(javaeeType), (int)0)) {
            return CdiEventsModelClassAnnotator.getFireEventExpressions(psiParameter.getType(), module, scope);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.fqn(javaeeType), (int)0)) {
            return CdiEventsModelClassAnnotator.getFireAsyncEventExpressions(psiParameter.getType(), module, scope);
        }
        Set<Pair<PsiElement, PsiType>> set = Collections.emptySet();
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(22);
        }
        return set;
    }

    private static void annotateEvents(CdiInject<? extends PsiMember> event, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, Module module, Set<? extends CdiObserves> allObservesList) {
        Set<CdiObserves> observes;
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(23);
        }
        if (!(observes = CdiEventsModelClassAnnotator.collectObserves(event, allObservesList, module)).isEmpty()) {
            CdiEventsModelClassAnnotator.addGotoObservesIcon(result, event.getPsiElement(), (NotNullLazyValue<Collection<? extends PsiElement>>)NotNullLazyValue.lazy(() -> ContainerUtil.mapNotNull((Collection)observes, cdiObserves -> cdiObserves.getPsiElement())));
        }
    }

    private static void addGotoObservesIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiElement psiElement, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(24);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)JavaUltimateIcons.Cdi.Gutter.Publisher, (String)"CDI").setTargetRenderer(ObservesTargetPresentationRenderer::new).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.observes", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.observes", new Object[0]));
        result.add(builder.createLineMarkerInfo(CdiEventsModelClassAnnotator.getLeafElement(psiElement)));
    }

    @NotNull
    private static PsiElement getLeafElement(@NotNull PsiElement psiElement) {
        UDeclaration uDeclaration;
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(25);
        }
        if ((uDeclaration = (UDeclaration)UastContextKt.toUElement((PsiElement)psiElement, UDeclaration.class)) != null && uDeclaration.getUastAnchor() != null && uDeclaration.getUastAnchor().getSourcePsi() != null) {
            PsiElement psiElement2 = uDeclaration.getUastAnchor().getSourcePsi();
            if (psiElement2 == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(26);
            }
            return psiElement2;
        }
        PsiIdentifier nameIdentifier = null;
        if (psiElement instanceof PsiVariable) {
            nameIdentifier = ((PsiVariable)psiElement).getNameIdentifier();
        } else if (psiElement instanceof PsiMethod) {
            nameIdentifier = ((PsiMethod)psiElement).getNameIdentifier();
        }
        Object object = nameIdentifier == null ? psiElement : nameIdentifier;
        if (object == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(27);
        }
        return object;
    }

    private static void addGotoFiresIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiParameter psiParameter, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(28);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)JavaUltimateIcons.Cdi.Gutter.Listener, (String)"CDI").setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.fires", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.fires", new Object[0])).setTargetRenderer(EventFireTargetPresentationRenderer::new);
        result.add(builder.createLineMarkerInfo(CdiEventsModelClassAnnotator.getLeafElement((PsiElement)psiParameter)));
    }

    private static Set<CdiObserves> collectObserves(CdiInject<? extends PsiMember> event, Set<? extends CdiObserves> allObservesList, Module module) {
        PsiType eventType = CdiEventsModelClassAnnotator.getEventType(event, CdiEventsModelClassAnnotator.getEventPsiType(module));
        if (eventType != null) {
            PsiAnnotation[] eventQualifierAnnotations = event.getQualifierAnnotations();
            return allObservesList.stream().filter(observes -> {
                PsiType type = observes.getType();
                return type != null && type.isAssignableFrom(eventType) && CdiEventsModelClassAnnotator.isQualifiersAssignable(eventQualifierAnnotations, (PsiModifierListOwner)observes.getPsiElement());
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<CdiObserves> collectObserves(@Nullable PsiType handledEventType, @NotNull Set<? extends CdiObserves> allObservesList) {
        if (allObservesList == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(29);
        }
        if (handledEventType != null) {
            return allObservesList.stream().filter(observes -> {
                PsiType type = observes.getType();
                return type != null && type.isAssignableFrom(handledEventType);
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    private static PsiType getEventType(CdiInject<? extends PsiMember> event, PsiClassType eventPsiType) {
        String eventAnno = CdiClassesConstants.EVENT.fqn(event.getPsiElement());
        for (InjectionPointDescriptor pair : event.getInjectionPoints()) {
            PsiType injectionPointType = pair.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom((PsiType)eventPsiType)) continue;
            return PsiUtil.substituteTypeParameter((PsiType)injectionPointType, (String)eventAnno, (int)0, (boolean)false);
        }
        return null;
    }

    private static boolean isQualifiersAssignable(PsiAnnotation[] qualifierAnnotation, PsiModifierListOwner candidate) {
        return CdiManager.hasAnnotated(candidate, qualifierAnnotation, null);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> searchAndCacheFireEventExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(30);
        }
        if (searchScope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(31);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)fireEventMethod, () -> CachedValueProvider.Result.create(CdiEventsModelClassAnnotator.searchFireEventExpressions(fireEventMethod, searchScope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(32);
        }
        return set;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> searchFireEventExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(33);
        }
        if (searchScope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(34);
        }
        @NotNull LinkedHashSet<Pair<PsiElement, PsiType>> set = new LinkedHashSet<Pair<PsiElement, PsiType>>();
        MethodReferencesSearch.search((PsiMethod)fireEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            UExpression firstArgument;
            UCallExpression uCallExpression;
            UReferenceExpression uReferenceExpression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)psiReference.getElement(), UReferenceExpression.class);
            if (uReferenceExpression != null && (uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uReferenceExpression, UCallExpression.class)) != null && !uCallExpression.getValueArguments().isEmpty() && (firstArgument = uCallExpression.getArgumentForParameter(0)) != null) {
                set.add(Pair.create((Object)uCallExpression.getSourcePsi(), (Object)firstArgument.getExpressionType()));
            }
            return true;
        });
        LinkedHashSet<Pair<PsiElement, PsiType>> linkedHashSet = set;
        if (linkedHashSet == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(35);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventExpressions(@NotNull PsiType handledType, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (handledType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(36);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(38);
        }
        return CdiEventsModelClassAnnotator.filter(CdiEventsModelClassAnnotator.getFireEventExpressions(FIRE_EVENT_METHOD, module, scope), handledType);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireAsyncEventExpressions(@NotNull PsiType handledType, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (handledType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(39);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(41);
        }
        return CdiEventsModelClassAnnotator.filter(CdiEventsModelClassAnnotator.getFireEventExpressions(FIRE_ASYNC_EVENT_METHOD, module, scope), handledType);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventExpressions(@NotNull String methodName, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (methodName == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(42);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(43);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(44);
        }
        LinkedHashSet<Pair<PsiElement, PsiType>> firePoints = new LinkedHashSet<Pair<PsiElement, PsiType>>();
        for (PsiMethod fireEventMethod : CdiEventsModelClassAnnotator.getFireEventMethods(module, methodName)) {
            firePoints.addAll(CdiEventsModelClassAnnotator.searchAndCacheFireEventExpressions(fireEventMethod, (SearchScope)scope));
        }
        LinkedHashSet<Pair<PsiElement, PsiType>> linkedHashSet = firePoints;
        if (linkedHashSet == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(45);
        }
        return linkedHashSet;
    }

    private static PsiMethod[] getFireEventMethods(@NotNull Module module, @NotNull String fireMethod) {
        PsiClass eventClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(46);
        }
        if (fireMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(47);
        }
        if ((eventClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CdiClassesConstants.EVENT.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return eventClass.findMethodsByName(fireMethod, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> filter(@NotNull Set<? extends Pair<PsiElement, PsiType>> firePoints, @NotNull PsiType eventType) {
        if (firePoints == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(48);
        }
        if (eventType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(49);
        }
        Set<Pair<PsiElement, PsiType>> set = firePoints.stream().filter(firePoint -> {
            PsiType firedEventType = (PsiType)firePoint.second;
            return firedEventType != null && eventType.isAssignableFrom(firedEventType);
        }).collect(Collectors.toSet());
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(50);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 22, 26, 27, 32, 35, 45, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 16: 
            case 19: 
            case 21: 
            case 37: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 18: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uCallExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 35: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allObservesList";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireEventMethod";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledType";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireMethod";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firePoints";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getObserves";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireEventPoints";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafElement";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAndCacheFireEventExpressions";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "searchFireEventExpressions";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireEventExpressions";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFireEventEventExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotateFireEventExpression";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getObserves";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 26: 
            case 27: 
            case 32: 
            case 35: 
            case 45: 
            case 50: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEvent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHandledEventType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEventPsiType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "annotateObserves";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventPoints";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "annotateEvents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addGotoObservesIcon";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLeafElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addGotoFiresIcon";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectObserves";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "searchAndCacheFireEventExpressions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "searchFireEventExpressions";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventExpressions";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFireAsyncEventExpressions";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventMethods";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 22, 26, 27, 32, 35, 45, 50 -> new IllegalStateException(string);
        };
    }

    private static class EventFireTargetPresentationRenderer
    extends PsiTargetPresentationRenderer<PsiElement> {
        private EventFireTargetPresentationRenderer() {
        }

        protected Icon getIcon(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                EventFireTargetPresentationRenderer.$$$reportNull$$$0(0);
            }
            if (psiElement instanceof PsiMethodCallExpression) {
                return JavaUltimateIcons.Cdi.Gutter.Publisher;
            }
            return super.getIcon(psiElement);
        }

        @NotNull
        @Nls
        public String getElementText(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                EventFireTargetPresentationRenderer.$$$reportNull$$$0(1);
            }
            String string = EventFireTargetPresentationRenderer.elementText(psiElement);
            if (string == null) {
                EventFireTargetPresentationRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String getContainerText(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                EventFireTargetPresentationRenderer.$$$reportNull$$$0(3);
            }
            if (psiElement instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement;
                return CdiGutterUtilsKt.getContainerText(psiMethodCallExpression);
            }
            return super.getContainerText(psiElement);
        }

        @NlsSafe
        public static String elementText(PsiElement psiElement) {
            String text = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiElement);
            return text.replaceAll(" ", "").replaceAll("\n", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$EventFireTargetPresentationRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$EventFireTargetPresentationRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainerText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ObservesTargetPresentationRenderer
    extends PsiTargetPresentationRenderer<PsiElement> {
        private ObservesTargetPresentationRenderer() {
        }

        @NotNull
        @NlsSafe
        public String getElementText(@NotNull PsiElement element) {
            if (element == null) {
                ObservesTargetPresentationRenderer.$$$reportNull$$$0(0);
            }
            PsiMethod method = (PsiMethod)element.getParent().getParent();
            StringBuilder sb = new StringBuilder();
            sb.append(method.getName());
            sb.append("(");
            ArrayList<String> params = new ArrayList<String>();
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                if (psiParameter.equals((Object)element)) {
                    params.add(element.getText());
                    continue;
                }
                params.add(psiParameter.getType().getPresentableText());
            }
            sb.append(StringUtil.join(params, (String)","));
            sb.append(")");
            String string = sb.toString();
            if (string == null) {
                ObservesTargetPresentationRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected Icon getIcon(@NotNull PsiElement element) {
            if (element == null) {
                ObservesTargetPresentationRenderer.$$$reportNull$$$0(2);
            }
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Method);
        }

        @Nullable
        @Nls
        public String getContainerText(@NotNull PsiElement element) {
            if (element == null) {
                ObservesTargetPresentationRenderer.$$$reportNull$$$0(3);
            }
            return element.getContainingFile().getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$ObservesTargetPresentationRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$ObservesTargetPresentationRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementText";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getContainerText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

