/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CdiDisposerMethodInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(2);
        }
        for (PsiMethod method : CdiCommonUtils.getDisposerMethods(aClass)) {
            if (method.getModifierList().hasModifierProperty("abstract")) {
                CdiDisposerMethodInspection.registerProblem(holder, CdiDisposerMethodInspection.getIdentifyingElement((PsiModifierListOwner)method), CdiInspectionBundle.message("CdiDisposerMethodInspection.non.abstract.disposer.method", new Object[0]));
            }
            if (CdiDisposerMethodInspection.getDisposeParameters(method).size() <= 1) continue;
            CdiDisposerMethodInspection.registerProblem(holder, CdiDisposerMethodInspection.getIdentifyingElement((PsiModifierListOwner)method), CdiInspectionBundle.message("CdiDisposerMethodInspection.too.many.dispose.parameters", new Object[0]));
        }
    }

    private static Set<PsiParameter> getDisposeParameters(@NotNull PsiMethod method) {
        if (method == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(3);
        }
        HashSet<PsiParameter> disposedParameters = new HashSet<PsiParameter>();
        String disposesAnno = CdiAnnoConstants.DISPOSES_ANNOTATION.fqn((PsiElement)method);
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)disposesAnno, (int)1)) continue;
            disposedParameters.add(psiParameter);
        }
        return disposedParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiDisposerMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisposeParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

