/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation;

import com.google.common.base.Strings;
import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.ValidationLibrary;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AnnotationDescriptor;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AssociationOverridesAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AttributeOverridesAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.BasicAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.CollectionTableAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.CreatedByAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.CreatedDateAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.ElementCollectionAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.EmbeddedAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.EmbeddedIdAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.GeneratedValueAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.HibernateConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.IdAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JoinColumnsAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.LastModifiedByAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.LastModifiedDateAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.ManyToManyAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.ManyToOneAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.MapsIdAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.OneToManyAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.OneToOneAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.OrderByAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.SequenceGeneratorAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.SpringAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.TableGeneratorAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.TemporalAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.TimeZoneColumnAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.TimeZoneStorageAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.TransientAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.VersionAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.DecimalMaxAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.DecimalMinAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.DigitsAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.EmailAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.FutureAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.FutureOrPresentAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.MaxAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.MinAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.NegativeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.NegativeOrZeroAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.NotBlankAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.NotEmptyAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.NotNullAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.PastAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.PastOrPresentAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.PatternAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.PositiveAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.PositiveOrZeroAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.SizeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.CodePointLengthAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.CreditCardNumberAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.CurrencyAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.DurationMaxAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.DurationMinAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.LengthAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.LuhnCheckAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.RangeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.constraint.hibernate.UrlAnnotation;
import com.intellij.jpa.jpb.model.core.backend.LibraryModificationTracker;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AnnotationHelper {
    protected final Project project;
    protected Map<AnnotationDescriptor, Annotation> attrAnnotations;
    private static final Key<CachedValue<Map<String, Annotation>>> KEY = Key.create((String)"com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper#getAttrAnnotations");

    public AnnotationHelper(Project project) {
        this.project = project;
        this.attrAnnotations = new LinkedHashMap<AnnotationDescriptor, Annotation>();
        this.initAnnotations();
    }

    protected void initAnnotations() {
        this.attrAnnotations.put(JpaAttributeAnnotation.SequenceGenerator, new SequenceGeneratorAnnotation(this.project));
        this.attrAnnotations.put(JpaAttributeAnnotation.TableGenerator, new TableGeneratorAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.GeneratedValue, new GeneratedValueAnnotation(this.project));
        this.attrAnnotations.put(JpaAttributeAnnotation.OneToOne, new OneToOneAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.OneToMany, new OneToManyAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.ManyToOne, new ManyToOneAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.ManyToMany, new ManyToManyAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.Basic, new BasicAnnotation(this.project));
        this.attrAnnotations.put(JpaAttributeAnnotation.OrderBy, new OrderByAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.JoinColumns, new JoinColumnsAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.MapsId, new MapsIdAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.AttributeOverrides, new AttributeOverridesAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.AssociationOverrides, new AssociationOverridesAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.CollectionTable, new CollectionTableAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.ElementCollection, new ElementCollectionAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.Embedded, new EmbeddedAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.EmbeddedId, new EmbeddedIdAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.Transient, new TransientAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.NotNull, new NotNullAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Past, new PastAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Future, new FutureAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Min, new MinAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Max, new MaxAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.DecimalMin, new DecimalMinAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.DecimalMax, new DecimalMaxAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Size, new SizeAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Pattern, new PatternAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Digits, new DigitsAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Email, new EmailAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.NotEmpty, new NotEmptyAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.NotBlank, new NotBlankAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Positive, new PositiveAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.PositiveOrZero, new PositiveOrZeroAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.Negative, new NegativeAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.NegativeOrZero, new NegativeOrZeroAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.PastOrPresent, new PastOrPresentAnnotation());
        this.attrAnnotations.put(JpaConstraintAnnotation.FutureOrPresent, new FutureOrPresentAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.Length, new LengthAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.CodePointLength, new CodePointLengthAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.CreditCardNumber, new CreditCardNumberAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.Currency, new CurrencyAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.DurationMin, new DurationMinAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.DurationMax, new DurationMaxAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.Range, new RangeAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.LuhnCheck, new LuhnCheckAnnotation());
        this.attrAnnotations.put(HibernateConstraintAnnotation.URL, new UrlAnnotation());
        this.attrAnnotations.put(SpringAnnotation.CreatedDate, new CreatedDateAnnotation());
        this.attrAnnotations.put(SpringAnnotation.CreatedBy, new CreatedByAnnotation());
        this.attrAnnotations.put(SpringAnnotation.LastModifiedDate, new LastModifiedDateAnnotation());
        this.attrAnnotations.put(SpringAnnotation.LastModifiedBy, new LastModifiedByAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.Temporal, new TemporalAnnotation(this.project));
        this.attrAnnotations.put(JpaAttributeAnnotation.TimeZoneStorage, new TimeZoneStorageAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.TimeZoneColumn, new TimeZoneColumnAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.Version, new VersionAnnotation());
        this.attrAnnotations.put(JpaAttributeAnnotation.Id, new IdAnnotation());
    }

    public static AnnotationHelper getInstance(Project project) {
        return (AnnotationHelper)project.getService(AnnotationHelper.class);
    }

    public static boolean isInsertValueAnnotationForBigDecimal(int precision, int scale) {
        return precision != 0 || scale != 0;
    }

    public static String formatAnnotation(String annotation, String params) {
        if (Strings.isNullOrEmpty((String)params)) {
            return String.format("@%s", annotation);
        }
        return String.format("@%s(%s)", annotation, params);
    }

    public static String formatAnnotation(String annotation, Object ... paramsNameValueNameValue) {
        if (paramsNameValueNameValue.length == 0) {
            return String.format("@%s", annotation);
        }
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < paramsNameValueNameValue.length; i += 2) {
            if (!params.isEmpty()) {
                params.append(", ");
            }
            params.append(paramsNameValueNameValue[i]).append(" = ").append(paramsNameValueNameValue[i + 1]);
        }
        return String.format("@%s(%s)", annotation, params);
    }

    public static Map<String, Annotation> getAttrAnnotations(PsiElement psiElement) {
        return AnnotationHelper.getAttrAnnotations(psiElement.getProject());
    }

    public static Map<String, Annotation> getAttrAnnotations(Project project) {
        return AnnotationHelper.getInstance(project).getAttrAnnotations();
    }

    public Map<String, Annotation> getAttrAnnotations() {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.project);
        return (Map)cachedValuesManager.getCachedValue((UserDataHolder)this.project, KEY, () -> {
            Map<String, Annotation> attrAnnotations = this.collectAnnotations();
            Map<ValidationLibrary, Boolean> validationLibraryInfo = AnnotationHelper.loadValidationLibraryInfo(this.project);
            Map actualAnnotations = Collections.unmodifiableMap(EntryStream.of(attrAnnotations).filterValues(annotation -> {
                if (!(annotation instanceof AbstractConstraintAnnotation)) {
                    return true;
                }
                String annotationFqn = annotation.getFqn(this.project, null);
                for (Map.Entry entry : validationLibraryInfo.entrySet()) {
                    Collection<String> validationLibBasePackages = ((ValidationLibrary)((Object)((Object)((Object)entry.getKey())))).getBasePackages();
                    if (!Boolean.TRUE.equals(entry.getValue()) || !ContainerUtil.exists(validationLibBasePackages, pack -> StringUtil.startsWith((CharSequence)annotationFqn, (CharSequence)pack))) continue;
                    return true;
                }
                return false;
            }).toCustomMap(LinkedHashMap::new));
            return CachedValueProvider.Result.create(actualAnnotations, (Object[])new Object[]{LibraryModificationTracker.getInstance(this.project)});
        }, false);
    }

    @NotNull
    public Map<String, Annotation> collectAnnotations() {
        Map map = (Map)StreamEx.of(this.attrAnnotations.entrySet()).collect(Collectors.toMap(entry -> ((AnnotationDescriptor)entry.getKey()).toString(), Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        if (map == null) {
            AnnotationHelper.$$$reportNull$$$0(0);
        }
        return map;
    }

    public static Map<ValidationLibrary, Boolean> loadValidationLibraryInfo(Project project) {
        Object[] libraries = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
        HashMap<ValidationLibrary, Boolean> result = new HashMap<ValidationLibrary, Boolean>();
        for (ValidationLibrary library : ValidationLibrary.values()) {
            result.put(library, StreamEx.of((Object[])libraries).anyMatch(l -> l.getName() != null && l.getName().contains(library.getLibraryName())));
        }
        return result;
    }

    public static boolean isEntity(EntityAttribute attribute) {
        EntityAttribute.MappingType mappingType = attribute.getMappingType();
        return mappingType == EntityAttribute.MappingType.ASSOCIATION;
    }

    public static String wrap(String s) {
        return "\"" + s + "\"";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationHelper", "collectAnnotations"));
    }
}

