/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.indexing;

import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.util.HProjectUtils;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/indexing/LombokService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectState", "Lcom/intellij/jpa/jpb/model/config/ProjectState;", "isLombokProject", "", "generateGettersAndSetters", "Companion", "intellij.javaee.jpa.jpb.model"})
public final class LombokService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final ProjectState projectState;

    public LombokService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        JpaPluginProjectConfig jpaPluginProjectConfig = JpaPluginProjectConfig.Companion.getInstance(this.project);
        this.projectState = jpaPluginProjectConfig != null ? jpaPluginProjectConfig.getState() : null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isLombokProject() {
        return HProjectUtils.isClassAvailableInLibraries(this.project, "lombok.Lombok");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean generateGettersAndSetters() {
        if (!this.isLombokProject()) return false;
        ProjectState projectState = this.projectState;
        if (projectState == null) return false;
        if (!projectState.isLombokGetterAndSetter) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/indexing/LombokService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/backend/ed/indexing/LombokService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LombokService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LombokService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LombokService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

