/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.module;

import com.intellij.jpa.jpb.model.core.module.HModule;
import com.intellij.jpa.jpb.model.core.module.HModuleKt;
import com.intellij.jpa.jpb.model.core.util.SourcesUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/jpb/model/core/module/HModuleImpl;", "Lcom/intellij/jpa/jpb/model/core/module/HModule;", "rootModule", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getRootModule", "()Lcom/intellij/openapi/module/Module;", "sourceRoots", "", "Lcom/intellij/psi/PsiDirectory;", "getSourceRoots", "()Ljava/util/List;", "resourceRoots", "getResourceRoots", "testSourceRoots", "getTestSourceRoots", "testResourceRoots", "getTestResourceRoots", "librariesSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getLibrariesSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.javaee.jpa.jpb.model.core"})
public final class HModuleImpl
implements HModule {
    @NotNull
    private final Module rootModule;

    public HModuleImpl(@NotNull Module rootModule) {
        Intrinsics.checkNotNullParameter((Object)rootModule, (String)"rootModule");
        this.rootModule = rootModule;
    }

    @Override
    @NotNull
    public Module getRootModule() {
        return this.rootModule;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getSourceRoots() {
        List<VirtualFile> list = SourcesUtils.INSTANCE.getSourceRoots(this.getRootModule(), false);
        Project project = this.getRootModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getResourceRoots() {
        List<VirtualFile> list = SourcesUtils.INSTANCE.getResourceRoots(this.getRootModule(), false);
        Project project = this.getRootModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getTestSourceRoots() {
        List<VirtualFile> list = SourcesUtils.INSTANCE.getSourceRoots(this.getRootModule(), true);
        Project project = this.getRootModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public List<PsiDirectory> getTestResourceRoots() {
        List<VirtualFile> list = SourcesUtils.INSTANCE.getResourceRoots(this.getRootModule(), true);
        Project project = this.getRootModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return HModuleKt.access$toPsiDirectories(list, project);
    }

    @Override
    @NotNull
    public GlobalSearchScope getLibrariesSearchScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)((SearchScope)this.getRootModule().getModuleWithLibrariesScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.getRootModule().getModuleScope()))), (Project)this.getRootModule().getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"toGlobalSearchScope(...)");
        return globalSearchScope;
    }
}

