/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.dialog;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.ui.dialog.CircleBorder;
import com.intellij.jpa.jpb.model.ui.dialog.ConfigureButtonUI;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HDialogWrapper
extends DialogWrapper {
    protected final Project project;
    protected boolean isCtrlEnterCommitShortcut;

    public HDialogWrapper(boolean canBeParent) {
        this(null, canBeParent);
    }

    protected HDialogWrapper(@Nullable Project project) {
        this(project, true);
    }

    protected HDialogWrapper(@Nullable Project project, boolean canBeParent) {
        this(project, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    protected HDialogWrapper(@Nullable Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            HDialogWrapper.$$$reportNull$$$0(0);
        }
        this(project, null, canBeParent, ideModalityType);
    }

    public HDialogWrapper(Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            HDialogWrapper.$$$reportNull$$$0(1);
        }
        super(project, parentComponent, canBeParent, ideModalityType);
        this.isCtrlEnterCommitShortcut = false;
        this.project = project;
    }

    protected void init() {
        super.init();
        this.myHelpAction.setEnabled(this.getHelpId() != null);
        if (this.isCtrlEnterCommitShortcut) {
            JRootPane rootPane = this.getRootPane();
            rootPane.setDefaultButton(null);
            if (ClientSystemInfo.isMac()) {
                rootPane.registerKeyboardAction(e -> {
                    Action okAction = this.getOKAction();
                    JButton okButton = this.getButton(okAction);
                    if (okButton == null) {
                        this.doOKAction();
                    } else {
                        okButton.doClick();
                    }
                }, KeyStroke.getKeyStroke(10, 256), 1);
            }
            rootPane.registerKeyboardAction(e -> {
                Action okAction = this.getOKAction();
                JButton okButton = this.getButton(okAction);
                if (okButton == null) {
                    this.doOKAction();
                } else {
                    okButton.doClick();
                }
            }, KeyStroke.getKeyStroke(10, 128), 1);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JButton okBtn;
        if (this.isCtrlEnterCommitShortcut && (okBtn = this.getButton(this.getOKAction())) != null) {
            return okBtn;
        }
        return super.getPreferredFocusedComponent();
    }

    @NotNull
    protected @NotNull Action @NotNull [] createLeftSideActions() {
        Action[] actionArray;
        if (this.getConfigurableName() == null) {
            actionArray = super.createLeftSideActions();
        } else {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = new ConfigureAction();
        }
        if (actionArray == null) {
            HDialogWrapper.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    public void setWidth(int width) {
        this.setSize(width, this.getSize().height);
    }

    public void setHeight(int height) {
        this.setSize(this.getSize().width, height);
    }

    public int showAndGetExitCode() {
        if (!this.isModal()) {
            throw new IllegalStateException("The showAndGetExitCode() method is for modal dialogs only");
        }
        this.show();
        return this.getExitCode();
    }

    protected JButton createJButtonForAction(Action action2) {
        JButton button = super.createJButtonForAction(action2);
        if (action2 instanceof ConfigureAction) {
            if (!UIUtil.isUnderWin10LookAndFeel()) {
                button.setUI((ButtonUI)ConfigureButtonUI.createUI());
            }
            String text = button.getText();
            button.setToolTipText(text);
            button.setText(null);
            button.setIcon(AllIcons.General.GearPlain);
            button.setOpaque(false);
            button.setContentAreaFilled(false);
            button.setBorderPainted(true);
            button.setBorder((Border)((Object)new CircleBorder()));
            Dimension dimension = new Dimension(JBUI.scale((int)28), JBUI.scale((int)30));
            button.setMinimumSize(dimension);
            button.setMaximumSize(dimension);
            button.setPreferredSize(dimension);
        }
        return button;
    }

    @NlsContexts.ConfigurableName
    @Nullable
    protected String getConfigurableName() {
        return null;
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.commit();
            this.close(0);
        }
    }

    protected void commit() {
    }

    protected void changeDialogHeight(int extraHeight) {
        ApplicationManager.getApplication().invokeLater(() -> {
            Dimension dialogSize = this.getSize();
            this.setSize(dialogSize.width, dialogSize.height - extraHeight);
            this.repaint();
        }, ModalityState.current(), o -> !this.isShowing());
    }

    public void updateSizeDialog() {
        Window window = this.getWindow();
        window.setPreferredSize(new Dimension());
        window.pack();
        window.revalidate();
        this.pack();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class ConfigureAction
    extends AbstractAction {
        public ConfigureAction() {
            super(JpaModelBundle.message("action.text.open.settings", new Object[0]), null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String configurableName = HDialogWrapper.this.getConfigurableName();
            if (configurableName != null) {
                ShowSettingsUtil.getInstance().showSettingsDialog(HDialogWrapper.this.project, configurableName);
            }
        }
    }

    protected class SimpleAction
    extends DialogWrapper.DialogWrapperAction {
        private final int exitCode;
        protected boolean isStartValidate;
        final /* synthetic */ HDialogWrapper this$0;

        public SimpleAction(@NlsContexts.Button HDialogWrapper this$0, String name, int exitCode) {
            this.this$0 = this$0;
            super((DialogWrapper)this$0, name);
            this.isStartValidate = false;
            this.exitCode = exitCode;
        }

        public SimpleAction(@NlsContexts.Button @NotNull HDialogWrapper this$0, String name, int exitCode, boolean isStartValidate) {
            if (name == null) {
                SimpleAction.$$$reportNull$$$0(0);
            }
            this(this$0, name, exitCode);
            this.isStartValidate = isStartValidate;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        protected void doAction(ActionEvent e) {
            List infoList;
            if (this.isStartValidate && !(infoList = this.this$0.doValidateAll()).isEmpty()) {
                ValidationInfo info = (ValidationInfo)infoList.get(0);
                if (info.component != null && info.component.isVisible()) {
                    IdeFocusManager.getInstance(null).requestFocus((Component)info.component, true);
                }
                DialogEarthquakeShaker.shake((Window)this.this$0.getPeer().getWindow());
                this.this$0.startTrackingValidation();
                return;
            }
            this.this$0.close(this.exitCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper$SimpleAction", "<init>"));
        }
    }
}

