/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.google.common.base.Strings;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.SpringAnnotation;
import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.liquibase.ns.ImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.liquibase.ns.SpringImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.model.CollectionTable;
import com.intellij.jpa.jpb.model.model.CompositeTypeEntity;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.MapDatatype;
import com.intellij.jpa.jpb.model.model.SimpleEnumPsiType;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.jpa.jpb.model.util.StudioPropertyUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class AttributeUtil {
    private static final Logger log = Logger.getInstance(AttributeUtil.class);

    public static AttributeUtil getInstance(Project project) {
        return (AttributeUtil)project.getService(AttributeUtil.class);
    }

    @Nullable
    public static Datatype getElementCollectionType(PsiMember member) {
        PsiAnnotation elementCollAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection);
        if (elementCollAnn == null) {
            return null;
        }
        PsiType type = AttributeUtil.getMemberType(member);
        PsiClass resolvedType = null;
        if (type instanceof PsiArrayType) {
            PsiType arrayType = ((PsiArrayType)type).getComponentType();
            if (arrayType instanceof PsiPrimitiveType) {
                return Datatypes.BasicDatatype.getInstanceStrict(arrayType.getCanonicalText());
            }
            resolvedType = AttributeUtil.resolveTypeParameter(arrayType);
        } else if (type instanceof PsiClassType) {
            MapDatatype mapFqn;
            PsiClassType refType = (PsiClassType)type;
            if (refType.getParameters().length == 1) {
                PsiClass compositeTypeEmbeddable;
                PsiType targetType = refType.getParameters()[0];
                if (targetType instanceof PsiWildcardType) {
                    PsiWildcardType wildcardType = (PsiWildcardType)targetType;
                    targetType = wildcardType.getBound();
                }
                if ((compositeTypeEmbeddable = AttributeUtil.getCompositeTypeEmbeddable(member, targetType)) != null) {
                    return CompositeTypeEntity.Companion.getInstance(compositeTypeEmbeddable);
                }
                resolvedType = PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
            } else if (refType.getParameters().length == 2 && (mapFqn = AttributeUtil.getMapDatatype(refType)) != null) {
                return mapFqn;
            }
        }
        return resolvedType == null ? null : AttributeUtil.resolveDatatype(resolvedType);
    }

    public static PsiClass getCompositeTypeEmbeddable(PsiMember attributeMember, PsiType memberType) {
        return Optional.ofNullable(attributeMember.getAnnotation("org.hibernate.annotations.CompositeType")).map(ann -> StudioAnnotationUtil.getDeclaredReferenceTypeValue(ann, "value")).or(() -> Optional.ofNullable(attributeMember.getContainingClass()).flatMap(clazz -> Arrays.stream(clazz.getAnnotations()).filter(ann -> ann.hasQualifiedName("org.hibernate.annotations.CompositeTypeRegistration")).filter(ann -> Objects.equals(memberType, StudioAnnotationUtil.getDeclaredReferenceTypeValue(ann, "embeddableClass"))).map(ann -> StudioAnnotationUtil.getDeclaredReferenceTypeValue(ann, "userType")).filter(Objects::nonNull).findAny())).filter(type -> type instanceof PsiClassType).map(type -> ((PsiClassType)type).resolve()).flatMap(clazz -> Arrays.stream(clazz.findMethodsByName("embeddable", false)).findFirst()).map(PsiMethod::getBody).map(body -> (PsiClassObjectAccessExpression)PsiTreeUtil.findChildOfType((PsiElement)body, PsiClassObjectAccessExpression.class)).map(expr -> expr.getOperand().getType()).filter(type -> type instanceof PsiClassType).map(type -> ((PsiClassType)type).resolve()).orElse(null);
    }

    @Nullable
    public static MapDatatype getMapDatatype(PsiClassType refType) {
        PsiClass resolvedRefClass = refType.resolve();
        if (InheritanceUtil.isInheritor((PsiClass)resolvedRefClass, (boolean)false, (String)"java.util.Map")) {
            PsiClass keyTypeClass = AttributeUtil.resolveTypeParameter(refType.getParameters()[0]);
            PsiClass valueTypeClass = AttributeUtil.resolveTypeParameter(refType.getParameters()[1]);
            Datatype resolvedKeyDatatype = AttributeUtil.resolveDatatype(keyTypeClass);
            Datatype resolvedValueDatatype = AttributeUtil.resolveDatatype(valueTypeClass);
            String mapFqn = resolvedRefClass.getQualifiedName();
            if (resolvedKeyDatatype != null && resolvedValueDatatype != null && mapFqn != null) {
                return new MapDatatype(mapFqn, resolvedKeyDatatype, resolvedValueDatatype);
            }
        }
        return null;
    }

    @Nullable
    private static Datatype resolveDatatype(@Nullable PsiClass typeClass) {
        if (typeClass == null) {
            return null;
        }
        if (EntityUtil.isEntity(typeClass)) {
            return EntityPsi.getInstance(typeClass);
        }
        if (typeClass.isEnum()) {
            return SimpleEnumPsiType.getInstance(typeClass);
        }
        String qualifiedName = typeClass.getQualifiedName();
        return qualifiedName == null ? null : Datatypes.BasicDatatype.getInstance(qualifiedName);
    }

    @Nullable
    private static PsiClass resolveTypeParameter(PsiType targetType) {
        if (targetType instanceof PsiWildcardType) {
            targetType = ((PsiWildcardType)targetType).getBound();
        }
        return PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
    }

    private EntityAttribute.MappingType getAssociationMappingType(PsiMember member) {
        return EntityAttribute.MappingType.ASSOCIATION;
    }

    @Nullable
    public static EntityAttribute.MappingType getMappingType(PsiMember member) {
        Module module;
        PsiType primitiveType;
        boolean isPrimitiveArrayType;
        PsiType type = AttributeUtil.getMemberType(member);
        boolean bl = isPrimitiveArrayType = type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType() instanceof PsiPrimitiveType;
        if (isPrimitiveArrayType && (primitiveType = ((PsiArrayType)type).getComponentType()).equalsToText(Byte.TYPE.getSimpleName())) {
            return EntityAttribute.MappingType.DATATYPE;
        }
        if (type instanceof PsiPrimitiveType) {
            return EntityAttribute.MappingType.DATATYPE;
        }
        Project project = member.getProject();
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{JpaAttributeAnnotation.ElementCollection.getFqn(project, module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member))}) != null) {
            return EntityAttribute.MappingType.ELEMENT_COLLECTION;
        }
        PsiClass referencedClass = AttributeUtil.getReferencedClass(member);
        if (referencedClass == null) {
            return isPrimitiveArrayType || AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.Type", JpaAttributeAnnotation.Convert.getFqn(project, module)}) != null ? EntityAttribute.MappingType.DATATYPE : null;
        }
        if (EntityUtil.isEmbeddable(referencedClass) || AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{JpaAttributeAnnotation.Embedded.getFqn(project, module)}) != null) {
            return EntityAttribute.MappingType.EMBEDDED;
        }
        if (EntityUtil.isEntity(referencedClass)) {
            return AttributeUtil.getInstance(project).getAssociationMappingType(member);
        }
        if (referencedClass.isEnum()) {
            return EntityAttribute.MappingType.ENUM;
        }
        return EntityAttribute.MappingType.DATATYPE;
    }

    @Nullable
    public static Datatype getAttrType(@NotNull PsiClass entityClass, @NotNull PsiMember attrMember) {
        PsiClass memberClass;
        if (entityClass == null) {
            AttributeUtil.$$$reportNull$$$0(0);
        }
        if (attrMember == null) {
            AttributeUtil.$$$reportNull$$$0(1);
        }
        if ((memberClass = attrMember.getContainingClass()) == null || memberClass == entityClass) {
            PsiType memberType = AttributeUtil.getMemberType(attrMember);
            if (memberType != null) {
                return Datatypes.BasicDatatype.getInstanceStrict(memberType);
            }
            return null;
        }
        return AttributeUtil.getResolvedGenericAttrType(entityClass, attrMember);
    }

    @Nullable
    public static Datatype getResolvedGenericAttrType(@NotNull PsiClass entityClass, @NotNull PsiMember attrMember) {
        Project project;
        PsiSubstitutor attributeConverterSubstitutor;
        PsiSubstitutor mySubstitutor;
        PsiType attrType;
        PsiClass memberClass;
        if (entityClass == null) {
            AttributeUtil.$$$reportNull$$$0(2);
        }
        if (attrMember == null) {
            AttributeUtil.$$$reportNull$$$0(3);
        }
        if ((memberClass = attrMember.getContainingClass()) == null || memberClass == entityClass) {
            return null;
        }
        PsiType memberType = AttributeUtil.getMemberType(attrMember);
        if (memberType instanceof PsiClassType && ((PsiClassType)memberType).getParameters().length == 1) {
            PsiClassReferenceType psiClassReferenceType;
            PsiType targetType = ((PsiClassType)memberType).getParameters()[0];
            if (targetType instanceof PsiWildcardType) {
                memberType = ((PsiWildcardType)targetType).getBound();
            } else if (targetType instanceof PsiClassReferenceType && (psiClassReferenceType = (PsiClassReferenceType)targetType).resolve() instanceof PsiTypeParameter) {
                memberType = targetType;
            }
        }
        if ((attrType = (mySubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)memberClass, (PsiClass)entityClass, (PsiSubstitutor)(attributeConverterSubstitutor = PsiElementFactory.getInstance((Project)(project = attrMember.getProject())).createType(memberClass).resolveGenerics().getSubstitutor()))).substitute(memberType)) == null) {
            return null;
        }
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.getInstanceStrict(attrType);
        if (basicDatatype != null) {
            return basicDatatype;
        }
        PsiClass referencedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)attrType);
        return EntityUtil.isEntity(referencedClass) ? EntityPsi.getInstance(referencedClass) : null;
    }

    @Nullable
    public static PsiClass getReferencedClass(PsiMember member) {
        return AttributeUtil.getReferencedClass(member, null);
    }

    @Nullable
    public static PsiClass getReferencedClass(PsiMember member, PsiClass owner) {
        PsiType type = AttributeUtil.getMemberType(member);
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType refType = (PsiClassType)type;
        PsiClass resolvedRefType = refType.resolve();
        if (resolvedRefType == null) {
            resolvedRefType = Fqn.Companion.ofType(type, (PsiElement)member, owner).toPsiClass(member.getProject());
        }
        if (EntityUtil.isEntity(resolvedRefType)) {
            return resolvedRefType;
        }
        if (refType.getParameters().length == 1) {
            PsiClass resolvedClass;
            PsiType targetType = refType.getParameters()[0];
            if (owner != null && (resolvedClass = Fqn.Companion.ofType(targetType, (PsiElement)member, owner).toPsiClass(member.getProject())) != null) {
                return resolvedClass;
            }
            if (targetType instanceof PsiWildcardType) {
                targetType = ((PsiWildcardType)targetType).getBound();
            }
            if (targetType != null && targetType.isValid()) {
                resolvedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
                if (resolvedClass instanceof PsiTypeParameter && member.getContainingClass() != null) {
                    for (PsiTypeParameter typeParameter : member.getContainingClass().getTypeParameters()) {
                        PsiType boundType;
                        PsiClass boundClass;
                        JvmReferenceType jvmReferenceType;
                        if (!Objects.equals(resolvedClass.getName(), typeParameter.getName()) || typeParameter.getBounds().length <= 0 || !((jvmReferenceType = typeParameter.getBounds()[0]) instanceof PsiType) || (boundClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(boundType = (PsiType)jvmReferenceType))) == null) continue;
                        return boundClass;
                    }
                }
                if (resolvedClass != null && resolvedClass.isValid()) {
                    return resolvedClass;
                }
            } else if (resolvedRefType != null && Datatypes.BasicDatatype.Class.isSame(resolvedRefType.getQualifiedName())) {
                return resolvedRefType;
            }
        } else if (refType.getParameters().length == 2) {
            PsiClass valueTypeClass;
            PsiClass resolvedRefClass = refType.resolve();
            if (InheritanceUtil.isInheritor((PsiClass)resolvedRefClass, (boolean)false, (String)"java.util.Map") && (valueTypeClass = AttributeUtil.resolveTypeParameter(refType.getParameters()[1])) != null) {
                return valueTypeClass;
            }
        } else {
            PsiClass returnedTypeResolved;
            PsiType returnType;
            PsiMethod typeGetter;
            List<PsiMethod> getters;
            if (member instanceof PsiField && member.getContainingClass() != null && (getters = StudioPropertyUtil.getGetters(member.getContainingClass(), member.getName())).size() == 1 && (typeGetter = getters.get(0)).getReturnType() != null && !(returnType = typeGetter.getReturnType()).equals(type) && returnType instanceof PsiClassType && (returnedTypeResolved = ((PsiClassType)returnType).resolve()) != null && returnedTypeResolved.isEnum()) {
                return returnedTypeResolved;
            }
            return resolvedRefType;
        }
        return null;
    }

    public static boolean isEmbedded(PsiMember field) {
        EntityAttribute.MappingType mappingType = AttributeUtil.getMappingType(field);
        return mappingType == EntityAttribute.MappingType.EMBEDDED;
    }

    public static boolean isCompKeyType(PsiField field) {
        PsiClass referencedClass = AttributeUtil.getReferencedClass((PsiMember)field);
        if (!EntityUtil.isEntity(referencedClass)) {
            return false;
        }
        PsiMember idField = EntityUtil.getIdMember(referencedClass);
        return idField != null && AttributeUtil.isEmbedded(idField);
    }

    public static String getColumnName(PsiField psiField) {
        return (String)EntityUtil.ra(() -> {
            String fieldName;
            PsiAnnotation annotation;
            Map<String, String> attributeOverrides;
            String overriddenColumnName;
            PsiClass containingClass = psiField.getContainingClass();
            Project project = psiField.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiField);
            if (containingClass != null && StringUtils.isNotBlank((CharSequence)(overriddenColumnName = (attributeOverrides = EntityUtil.getAttributeOverrides(annotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)containingClass, JpaAttributeAnnotation.AttributeOverrides), false)).get(fieldName = psiField.getName())))) {
                return overriddenColumnName;
            }
            String columnName = EntityUtil.getAnnotationAttribute((PsiModifierListOwner)psiField, JpaAttributeAnnotation.Column.getFqn(project, module), "name");
            if (columnName == null) {
                columnName = EntityUtil.getAnnotationAttribute((PsiModifierListOwner)psiField, JpaAttributeAnnotation.JoinColumn.getFqn(project, module), "name");
            }
            return columnName;
        });
    }

    public static Map<String, String> getJoinColumns(PsiField field) {
        PsiAnnotation joinColumnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.JoinColumns);
        return joinColumnAnn == null ? Collections.emptyMap() : AttributeUtil.getJoinColumns(joinColumnAnn, "value");
    }

    public static List<JoinColumn> getJoinColumnModels(PsiAnnotation annotation, @Nullable String attrName) {
        JoinColumn joinColumnModel;
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
        PsiAnnotationMemberValue joinColumnValue = annotation.findDeclaredAttributeValue(attrName);
        if (joinColumnValue == null) {
            return joinColumns;
        }
        if (joinColumnValue instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] members;
            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)joinColumnValue;
            for (PsiAnnotationMemberValue member : members = array.getInitializers()) {
                JoinColumn joinColumnModel2;
                if (!(member instanceof PsiAnnotation) || (joinColumnModel2 = AttributeUtil.createJoinColumnModel((PsiAnnotation)member)) == null) continue;
                joinColumns.add(joinColumnModel2);
            }
        } else if (joinColumnValue instanceof PsiAnnotation && (joinColumnModel = AttributeUtil.createJoinColumnModel((PsiAnnotation)joinColumnValue)) != null) {
            joinColumns.add(joinColumnModel);
        }
        return joinColumns;
    }

    public static Map<String, String> getJoinColumns(@NotNull PsiAnnotation annotation, @Nullable String attrName) {
        if (annotation == null) {
            AttributeUtil.$$$reportNull$$$0(4);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (JoinColumn joinColumnModel : AttributeUtil.getJoinColumnModels(annotation, attrName)) {
            result.put(joinColumnModel.getName(), joinColumnModel.getReferencedColumnName());
        }
        return result;
    }

    public static boolean isIdField(PsiMember psiMember) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)psiMember, JpaAttributeAnnotation.Id, JpaAttributeAnnotation.EmbeddedId);
    }

    public static boolean isVersionField(PsiMember psiMember) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)psiMember, JpaAttributeAnnotation.Version);
    }

    public static boolean isCreatedDateField(PsiMember psiMember) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)psiMember, SpringAnnotation.CreatedDate);
    }

    public static boolean isCreatedByField(PsiMember psiMember) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)psiMember, SpringAnnotation.CreatedBy);
    }

    public static boolean isLastModifiedDateField(PsiMember psiMember) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)psiMember, SpringAnnotation.LastModifiedDate);
    }

    public static boolean isLastModifiedByField(PsiMember psiMember) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)psiMember, SpringAnnotation.LastModifiedBy);
    }

    public static boolean isPersistent(PsiField field) {
        return AttributeUtil.isPersistent_(field);
    }

    private static boolean isPersistent_(PsiField field) {
        if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.Transient)) {
            return false;
        }
        PsiClass entity = field.getContainingClass();
        return entity != null;
    }

    public static boolean isTransient(PsiField field) {
        return StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.Transient);
    }

    @Nullable
    public static String generateAttributeColumnName(PsiField attr) {
        return AttributeUtil.generateAttributeColumnName(attr.getName(), AttributeUtil.getMappingType((PsiMember)attr), AttributeUtil.getCardinality(attr), AttributeUtil.getReferencedClass((PsiMember)attr), AttributeUtil.isOwner(attr));
    }

    @Nullable
    public static String generateAttributeColumnName(String attributeName, EntityAttribute.MappingType mappingType, EntityAttribute.Cardinality cardinality, PsiClass attrType, boolean isOwner) {
        if (attributeName == null || mappingType == null) {
            return null;
        }
        return AttributeUtil.generateAttributeColumnName_(attributeName, mappingType, cardinality, attrType, isOwner);
    }

    private static String generateAttributeColumnName_(@NotNull String attributeName, @NotNull EntityAttribute.MappingType mappingType, @Nullable EntityAttribute.Cardinality cardinality, @NotNull PsiClass attrType, boolean isOwner) {
        if (attributeName == null) {
            AttributeUtil.$$$reportNull$$$0(5);
        }
        if (mappingType == null) {
            AttributeUtil.$$$reportNull$$$0(6);
        }
        if (attrType == null) {
            AttributeUtil.$$$reportNull$$$0(7);
        }
        String column = null;
        String underscored = AttributeUtil.toUnderscore(attributeName);
        if (mappingType == EntityAttribute.MappingType.DATATYPE || mappingType == EntityAttribute.MappingType.ENUM) {
            column = underscored;
        } else if (mappingType == EntityAttribute.MappingType.ASSOCIATION && cardinality != null && !cardinality.isMany() && (cardinality != EntityAttribute.Cardinality.ONE_TO_ONE || isOwner)) {
            String postfix = "ID";
            if (attrType instanceof Entity) {
                Entity typeEntity = (Entity)attrType;
                EntityAttribute idAttr = typeEntity.getIdAttributeOrNull();
                if (idAttr != null && idAttr.getType() == Datatypes.BasicDatatype.String) {
                    postfix = idAttr.getName().toUpperCase(Locale.ROOT);
                } else if (idAttr != null && idAttr.getType() instanceof Entity) {
                    return null;
                }
            }
            String string = column = !Strings.isNullOrEmpty((String)underscored) ? underscored + "_" + postfix : "";
        }
        if (column != null) {
            return column;
        }
        return null;
    }

    public static boolean isOwner(PsiField field) {
        if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.JoinTable)) {
            return true;
        }
        PsiAnnotation one2OneAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.OneToOne);
        if (one2OneAnn != null) {
            String mappedByValue = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)one2OneAnn, (String)"mappedBy");
            return StringUtils.isBlank((CharSequence)mappedByValue);
        }
        return false;
    }

    @Nullable
    public static EntityAttribute.Cardinality getCardinality(PsiField field) {
        PsiAnnotation cardinalityAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.ManyToOne, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany);
        if (cardinalityAnnotation == null) {
            return null;
        }
        String className = cardinalityAnnotation.getQualifiedName();
        Project project = field.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)field);
        for (EntityAttribute.Cardinality cardinality : EntityAttribute.Cardinality.values()) {
            if (!Objects.equals(cardinality.getFqn(project, module), className)) continue;
            return cardinality;
        }
        return null;
    }

    public static String toUnderscore(String str) {
        char[] chars = str.toCharArray();
        int length = chars.length;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char currChar = chars[i];
            if (Character.isUpperCase(currChar)) {
                AttributeUtil.appendUnderscore(chars, length, result, i);
                result.append(currChar);
                continue;
            }
            result.append(Character.toUpperCase(currChar));
        }
        return result.toString();
    }

    private static void appendUnderscore(char[] chars, int length, StringBuilder result, int i) {
        if (i == 0) {
            return;
        }
        char prevChar = chars[i - 1];
        if (prevChar == '_') {
            return;
        }
        if (Character.isLowerCase(prevChar) || i != length - 1 && Character.isLowerCase(chars[i + 1])) {
            result.append("_");
        }
    }

    public static boolean isUnique(PsiField field) {
        PsiAnnotation columnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.Column, JpaAttributeAnnotation.JoinColumn);
        if (columnAnn == null) {
            return false;
        }
        Boolean uniqueValue = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"unique");
        return uniqueValue != null && uniqueValue != false;
    }

    @Nullable
    public static String getLength(PsiField field) {
        PsiAnnotation columnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.Column);
        if (columnAnn == null) {
            return null;
        }
        Long lengthValue = StudioAnnotationUtil.getDeclaredLongAttributeValue(columnAnn, "length");
        if (lengthValue != null) {
            return lengthValue.toString();
        }
        if (!StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)field, JpaAttributeAnnotation.Lob)) {
            return String.valueOf(255);
        }
        return null;
    }

    public static boolean isClass(PsiField field) {
        EntityAttribute.MappingType mappingType = AttributeUtil.getMappingType((PsiMember)field);
        return mappingType == EntityAttribute.MappingType.ASSOCIATION;
    }

    @Nullable
    public static CollectionTable getCollectionTable(@Nullable Entity ownerEntity, PsiMember member) {
        PsiAnnotation collectionTableAnn = AttributeUtil.getCollectionTableAnnotation(member);
        if (collectionTableAnn != null) {
            return AttributeUtil.createCollectionTable(ownerEntity, member, collectionTableAnn);
        }
        return !StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection) ? null : AttributeUtil.createCollectionTable(ownerEntity, member, null);
    }

    @Nullable
    public static PsiAnnotation getCollectionTableAnnotation(@NotNull PsiMember member) {
        PsiAnnotation collectionTableAnn;
        if (member == null) {
            AttributeUtil.$$$reportNull$$$0(8);
        }
        if ((collectionTableAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.CollectionTable)) != null) {
            return collectionTableAnn;
        }
        return !StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection) ? null : StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinTable);
    }

    @NotNull
    public static JoinTable getJoinTable(@Nullable Entity ownerEntity, PsiMember member) {
        Project project = member.getProject();
        PsiAnnotation joinTableAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinTable);
        if (joinTableAnn != null) {
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection)) {
                JoinTable joinTable = JoinTable.NULL_ANNOTATION;
                if (joinTable == null) {
                    AttributeUtil.$$$reportNull$$$0(9);
                }
                return joinTable;
            }
            return AttributeUtil.createJoinTable(ownerEntity, member, joinTableAnn);
        }
        PsiAnnotation anyToManyAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ManyToMany, JpaAttributeAnnotation.OneToMany);
        if (anyToManyAnn == null) {
            JoinTable joinTable = JoinTable.NULL_ANNOTATION;
            if (joinTable == null) {
                AttributeUtil.$$$reportNull$$$0(10);
            }
            return joinTable;
        }
        String mappedByValue = AnnotationUtil.getStringAttributeValue((PsiAnnotation)anyToManyAnn, (String)"mappedBy");
        if (StringUtil.isNotEmpty((String)mappedByValue)) {
            JoinTable joinTable = JoinTable.NULL_ANNOTATION;
            if (joinTable == null) {
                AttributeUtil.$$$reportNull$$$0(11);
            }
            return joinTable;
        }
        if (anyToManyAnn.hasQualifiedName(JpaAttributeAnnotation.OneToMany.getFqn(project, ModuleUtilCore.findModuleForPsiElement((PsiElement)member))) && StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumn)) {
            JoinTable joinTable = JoinTable.NULL_ANNOTATION;
            if (joinTable == null) {
                AttributeUtil.$$$reportNull$$$0(12);
            }
            return joinTable;
        }
        JoinTable joinTable = AttributeUtil.createJoinTable(ownerEntity, member);
        if (joinTable == null) {
            AttributeUtil.$$$reportNull$$$0(13);
        }
        return joinTable;
    }

    @NotNull
    public static JoinTable getJoinTable(PsiMember member) {
        return AttributeUtil.getJoinTable(null, member);
    }

    private static JoinTable createJoinTable(@Nullable Entity ownerEntity, PsiMember member) {
        SpringImplicitNamingStrategy implicitNameStrategy = SpringImplicitNamingStrategy.getInstance(member.getProject());
        EntityAttributePsi attribute = EntityAttributePsi.getInstance(member);
        Entity entity = ownerEntity != null ? ownerEntity : attribute.getEntity();
        JoinTable joinTable = new JoinTable();
        joinTable.setName(implicitNameStrategy.determineJoinTableName(entity, attribute));
        joinTable.setJoinColumns(implicitNameStrategy.determineJoinColumnName(entity, attribute));
        List<JoinColumn> inverseJoinColumn = implicitNameStrategy.determineInverseJoinColumn(entity, attribute);
        if (inverseJoinColumn.isEmpty()) {
            return JoinTable.NULL_ANNOTATION;
        }
        joinTable.setInverseJoinColumns(inverseJoinColumn);
        return joinTable;
    }

    private static CollectionTable createCollectionTable(@Nullable Entity ownerEntity, @NotNull PsiMember member, @Nullable PsiAnnotation collectionTableAnn) {
        if (member == null) {
            AttributeUtil.$$$reportNull$$$0(14);
        }
        SpringImplicitNamingStrategy implicitNameStrategy = SpringImplicitNamingStrategy.getInstance(member.getProject());
        String collectionTableName = AttributeUtil.getCollectionTableName(ownerEntity, member, collectionTableAnn, implicitNameStrategy);
        List<JoinColumn> joinColumns = AttributeUtil.getCollectionTableJoinColumns(ownerEntity, member, collectionTableAnn, implicitNameStrategy);
        List<Index> indexes = Collections.emptyList();
        List<Index> uniqueConstraints = Collections.emptyList();
        if (collectionTableAnn != null) {
            indexes = EntityUtil.getIndexes(collectionTableAnn);
            uniqueConstraints = EntityUtil.getUniqueConstraints(collectionTableAnn);
        }
        return new CollectionTable(collectionTableName, joinColumns, indexes, uniqueConstraints);
    }

    private static List<JoinColumn> getCollectionTableJoinColumns(@Nullable Entity ownerEntity, @NotNull PsiMember member, @Nullable PsiAnnotation collectionTableAnn, ImplicitNamingStrategy implicitNameStrategy) {
        if (member == null) {
            AttributeUtil.$$$reportNull$$$0(15);
        }
        if (collectionTableAnn != null) {
            Map<String, String> joinColumns = AttributeUtil.getJoinColumns(collectionTableAnn, "joinColumns");
            EntityAttributePsi attribute = EntityAttributePsi.getInstance(member);
            Entity entity = ownerEntity != null ? ownerEntity : attribute.getEntity();
            return AttributeUtil.createJoinColumns(entity, attribute, joinColumns, implicitNameStrategy, false);
        }
        EntityAttributePsi attribute = EntityAttributePsi.getInstance(member);
        Entity entity = ownerEntity != null ? ownerEntity : attribute.getEntity();
        return implicitNameStrategy.determineJoinColumnName(entity, attribute);
    }

    @NotNull
    private static String getCollectionTableName(@Nullable Entity ownerEntity, @NotNull PsiMember member, @Nullable PsiAnnotation collectionTableAnn, ImplicitNamingStrategy implicitNameStrategy) {
        String collectionTableName;
        if (member == null) {
            AttributeUtil.$$$reportNull$$$0(16);
        }
        String string = collectionTableName = collectionTableAnn == null ? null : StudioAnnotationUtil.getStringAttributeValue(collectionTableAnn, "name", "");
        if (StringUtil.isNotEmpty((String)collectionTableName)) {
            String string2 = collectionTableName;
            if (string2 == null) {
                AttributeUtil.$$$reportNull$$$0(17);
            }
            return string2;
        }
        EntityAttributePsi attribute = EntityAttributePsi.getInstance(member);
        Entity entity = ownerEntity != null ? ownerEntity : attribute.getEntity();
        String string3 = implicitNameStrategy.determineCollectionTableName(entity, attribute);
        if (string3 == null) {
            AttributeUtil.$$$reportNull$$$0(18);
        }
        return string3;
    }

    @NotNull
    private static JoinTable createJoinTable(@Nullable Entity ownerEntity, PsiMember member, PsiAnnotation annotation) {
        Entity entity;
        SpringImplicitNamingStrategy implicitNameStrategy = SpringImplicitNamingStrategy.getInstance(member.getProject());
        JoinTable joinTable = new JoinTable();
        String joinTableName = StudioAnnotationUtil.getStringAttributeValue(annotation, "name", "");
        EntityAttributePsi attribute = EntityAttributePsi.getInstance(member);
        Entity entity2 = entity = ownerEntity != null ? ownerEntity : attribute.getEntity();
        if (StringUtil.isEmpty((String)joinTableName)) {
            joinTable.setName(implicitNameStrategy.determineJoinTableName(entity, attribute));
        } else {
            joinTable.setName(joinTableName);
        }
        Map<String, String> joinColumns = AttributeUtil.getJoinColumns(annotation, "joinColumns");
        joinTable.setJoinColumns(AttributeUtil.createJoinColumns(entity, attribute, joinColumns, implicitNameStrategy, false));
        joinColumns = AttributeUtil.getJoinColumns(annotation, "inverseJoinColumns");
        Datatype attributeType = attribute.getType(ownerEntity, false);
        if (!(attributeType instanceof Entity)) {
            log.warn("Incorrect java type of attribute '" + entity.getFqn() + "#" + attribute.getName() + "' for JoinTable! Expected: JPA Entity; Actual: " + attributeType.getFqn());
            JoinTable joinTable2 = JoinTable.NULL_ANNOTATION;
            if (joinTable2 == null) {
                AttributeUtil.$$$reportNull$$$0(19);
            }
            return joinTable2;
        }
        joinTable.setInverseJoinColumns(AttributeUtil.createJoinColumns((Entity)attributeType, attribute, joinColumns, implicitNameStrategy, true));
        joinTable.setUniqueConstraints(EntityUtil.getUniqueConstraints(annotation));
        joinTable.setForeignKey(ForeignKeyModel.Companion.getInstance(member.getProject(), annotation, "foreignKey"));
        joinTable.setInverseForeignKey(ForeignKeyModel.Companion.getInstance(member.getProject(), annotation, "inverseForeignKey"));
        JoinTable joinTable3 = joinTable;
        if (joinTable3 == null) {
            AttributeUtil.$$$reportNull$$$0(20);
        }
        return joinTable3;
    }

    public static List<JoinColumn> createJoinColumns(Entity ownerEntity, EntityAttribute attribute, Map<String, String> joinColumns, ImplicitNamingStrategy implicitNameStrategy, boolean inverseJoinColumn) {
        Entity compKeyTypeEntity = ownerEntity.getCompKeyType();
        List<JoinColumn> implicitJoinColumns = inverseJoinColumn ? implicitNameStrategy.determineInverseJoinColumn(ownerEntity, attribute) : implicitNameStrategy.determineJoinColumnName(ownerEntity, attribute);
        EntityAttribute ownerIdAttr = ownerEntity.getIdAttributeOrNull();
        if (compKeyTypeEntity == null) {
            if (joinColumns.isEmpty() || ownerIdAttr == null) {
                return implicitJoinColumns;
            }
            Map.Entry<String, String> joinColumnEntry = joinColumns.entrySet().iterator().next();
            String referencedColumnName = joinColumnEntry.getValue();
            if (StringUtil.isEmpty((String)referencedColumnName) && !implicitJoinColumns.isEmpty()) {
                referencedColumnName = implicitJoinColumns.get(0).getReferencedColumnName();
            }
            JoinColumn joinColumn = new JoinColumn(joinColumnEntry.getKey(), referencedColumnName);
            return Collections.singletonList(joinColumn);
        }
        ArrayList<JoinColumn> result = new ArrayList<JoinColumn>();
        if (implicitJoinColumns.size() > 1 && joinColumns.size() == implicitJoinColumns.size() && ContainerUtil.and(joinColumns.values(), StringUtil::isEmpty)) {
            ArrayList<String> joinColumnNames = new ArrayList<String>(joinColumns.keySet());
            for (int i = 0; i < joinColumnNames.size(); ++i) {
                result.add(new JoinColumn((String)joinColumnNames.get(i), implicitJoinColumns.get(i).getReferencedColumnName()));
            }
        } else {
            for (EntityAttribute embAttr : compKeyTypeEntity.getAttributes()) {
                String embAttrColumnName = embAttr.getEmbeddedColumnName(ownerIdAttr);
                if (StringUtils.isBlank((CharSequence)embAttrColumnName)) continue;
                String columnName = AttributeUtil.getJoinColumnName(joinColumns, implicitJoinColumns, embAttrColumnName);
                result.add(new JoinColumn(StringUtils.isBlank((CharSequence)columnName) ? embAttrColumnName : columnName, embAttrColumnName));
            }
        }
        return result;
    }

    private static String getJoinColumnName(Map<String, String> joinColumns, List<JoinColumn> implicitJoinColumns, String embAttrColumnName) {
        String columnName = StreamEx.of(joinColumns.entrySet()).findFirst(entry -> DbIdentifierHelper.compareIdentifier((String)entry.getValue(), embAttrColumnName)).map(Map.Entry::getKey).orElse(null);
        if (StringUtil.isEmpty((String)columnName)) {
            columnName = StreamEx.of(implicitJoinColumns).findFirst(joinColumn -> DbIdentifierHelper.compareIdentifier(joinColumn.getReferencedColumnName(), embAttrColumnName)).map(JoinColumn::getName).orElse(null);
        }
        return columnName;
    }

    @Nullable
    public static PsiType getMemberType(@NotNull PsiMember member) {
        if (member == null) {
            AttributeUtil.$$$reportNull$$$0(21);
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getReturnType();
        }
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        return null;
    }

    @Nullable
    public static JoinColumn createJoinColumnModel(PsiAnnotation joinColumnAnnotation) {
        String name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)joinColumnAnnotation, (String)"name");
        String referencedColumnName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)joinColumnAnnotation, (String)"referencedColumnName");
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (referencedColumnName == null) {
            referencedColumnName = "";
        }
        JoinColumn joinColumn = new JoinColumn(name, referencedColumnName);
        Boolean isNullable = StudioAnnotationUtil.getDeclaredBooleanAttributeValue(joinColumnAnnotation, "nullable");
        joinColumn.setNullable(isNullable == null || isNullable != false);
        return joinColumn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrMember";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrType";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/AttributeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/AttributeUtil";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinTable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionTableName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createJoinTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttrType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedGenericAttrType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJoinColumns";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateAttributeColumnName_";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionTableAnnotation";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionTable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionTableJoinColumns";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionTableName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMemberType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

