/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class Edition2024Annotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        PbElement pbElement;
        if (element == null) {
            Edition2024Annotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            Edition2024Annotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PbElement) || !((pbElement = (PbElement)element).getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition) || pbElement.getPbFile().getSyntaxLevel().getVersion().compareTo("2024") < 0) {
            return;
        }
        element.accept((PsiElementVisitor)new PbVisitor(this){

            @Override
            public void visitImportStatement(@NotNull PbImportStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                Edition2024Annotator.annotateImportStatement(statement, holder);
            }

            @Override
            public void visitOptionName(@NotNull PbOptionName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                Edition2024Annotator.annotateOptionName(name, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/Edition2024Annotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitImportStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOptionName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void annotateImportStatement(PbImportStatement statement, AnnotationHolder holder) {
        PsiElement label = statement.getImportLabel();
        if (label != null && statement.isWeak()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.2024.weak.imports", new Object[0])).range(label).create();
        }
    }

    private static void annotateOptionName(PbOptionName optionName, AnnotationHolder holder) {
        PbOptionExpression optionExpression = (PbOptionExpression)PsiTreeUtil.getParentOfType((PsiElement)optionName, PbOptionExpression.class);
        if (optionExpression == null) {
            return;
        }
        if (PbPsiUtil.isDescriptorOption(optionExpression, "weak").booleanValue()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.2024.weak", new Object[0])).range((PsiElement)optionName).create();
        } else if (PbPsiUtil.isDescriptorOption(optionExpression, "ctype").booleanValue()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.2024.ctype", new Object[0])).range((PsiElement)optionName).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/annotation/Edition2024Annotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

