/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.ProtoNumberValue;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.impl.PbElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

abstract class PbNumberValueMixin
extends PbElementBase
implements PbNumberValue {
    private static final TokenSet NUMBER_TOKENS = TokenSet.create((IElementType[])new IElementType[]{ProtoTokenTypes.INTEGER_LITERAL, ProtoTokenTypes.FLOAT_LITERAL, ProtoTokenTypes.IDENTIFIER_LITERAL});

    PbNumberValueMixin(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public ProtoNumberValue.SourceType getSourceType() {
        ASTNode childNode;
        PsiElement childElement = this.getNumberElement();
        ASTNode aSTNode = childNode = childElement != null ? childElement.getNode() : null;
        if (childNode != null) {
            IElementType numberType = childNode.getElementType();
            if (numberType == ProtoTokenTypes.INTEGER_LITERAL) {
                return ProtoNumberValue.SourceType.INTEGER;
            }
            if (numberType == ProtoTokenTypes.FLOAT_LITERAL) {
                return ProtoNumberValue.SourceType.FLOAT;
            }
            if (numberType == ProtoTokenTypes.IDENTIFIER_LITERAL) {
                if (PbNumberValueMixin.isInf(childNode)) {
                    return ProtoNumberValue.SourceType.INF;
                }
                if (PbNumberValueMixin.isNan(childNode)) {
                    return ProtoNumberValue.SourceType.NAN;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getNumberElement() {
        return this.findChildByType(NUMBER_TOKENS);
    }

    @Override
    public boolean isNegative() {
        return this.findChildByType(ProtoTokenTypes.MINUS) != null;
    }

    private static boolean isInf(ASTNode node) {
        return Objects.equals(node.getElementType(), ProtoTokenTypes.IDENTIFIER_LITERAL) && "inf".equals(node.getText());
    }

    private static boolean isNan(ASTNode node) {
        return Objects.equals(node.getElementType(), ProtoTokenTypes.IDENTIFIER_LITERAL) && "nan".equals(node.getText());
    }
}

