/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.util.xml.NamedEnum;
import org.jetbrains.annotations.Nullable;

public enum Autowire implements NamedEnum
{
    AUTODETECT("autodetect"),
    BY_NAME("byName"),
    BY_TYPE("byType"),
    CONSTRUCTOR("constructor"),
    DEFAULT("default"),
    NO("no");

    private final String value;

    private Autowire(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAutowired() {
        return !this.equals((Object)DEFAULT) && !this.equals((Object)NO);
    }

    public static Autowire fromDefault(@Nullable Autowire defaultAutowire) {
        if (defaultAutowire == null) {
            return DEFAULT;
        }
        return switch (defaultAutowire.ordinal()) {
            case 1 -> BY_NAME;
            case 2 -> BY_TYPE;
            case 3 -> CONSTRUCTOR;
            case 5 -> NO;
            default -> DEFAULT;
        };
    }
}

