/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider,
HighlightedReference {
    @Nullable
    private final PsiClass myRequiredClass;
    private final boolean myFactoryBeanRef;

    public SpringBeanReference(PsiElement element) {
        this(element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public SpringBeanReference(PsiElement element, TextRange range) {
        this(element, range, null, false);
    }

    public SpringBeanReference(PsiElement element, TextRange range, @Nullable PsiClass requiredClass, boolean isFactoryBeanRef) {
        super(element, range);
        this.myRequiredClass = requiredClass;
        this.myFactoryBeanRef = isFactoryBeanRef;
    }

    public boolean isFactoryBeanRef() {
        return this.myFactoryBeanRef;
    }

    @NotNull
    protected CommonSpringModel getSpringModel() {
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(this.getElement());
        if (commonSpringModel == null) {
            SpringBeanReference.$$$reportNull$$$0(0);
        }
        return commonSpringModel;
    }

    public PsiElement resolve() {
        SpringBeanPointer<?> pointer = this.resolveToBean();
        return pointer == null || !pointer.isValid() ? null : pointer.getPsiElement();
    }

    @Nullable
    public SpringBeanPointer<?> resolveToBean() {
        return SpringModelSearchers.findBean(this.getSpringModel(), this.getValue());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SpringBeanReference.$$$reportNull$$$0(1);
        }
        return this.getElement();
    }

    public Object @NotNull [] getVariants() {
        CommonSpringModel model = this.getSpringModel();
        Collection<SpringBeanPointer<?>> beans2 = this.getBeanPointers(model);
        ArrayList lookups = new ArrayList(beans2.size());
        for (SpringBeanPointer<?> bean : beans2) {
            ContainerUtil.addIfNotNull(lookups, (Object)SpringConverterUtil.createCompletionVariant(bean));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(lookups);
        if (objectArray == null) {
            SpringBeanReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    protected Collection<SpringBeanPointer<?>> getBeanPointers(CommonSpringModel model) {
        Collection<SpringBeanPointer<?>> beans2;
        if (this.myRequiredClass != null && !"java.lang.Object".equals(this.myRequiredClass.getQualifiedName())) {
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(this.myRequiredClass).withInheritors().effectiveBeanTypes();
            beans2 = SpringModelSearchers.findBeans(model, searchParameters);
        } else {
            beans2 = model.getAllCommonBeans();
        }
        Collection<SpringBeanPointer<?>> collection = beans2;
        if (collection == null) {
            SpringBeanReference.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringApiBundle.message("model.bean.error.message", this.getValue());
        if (string == null) {
            SpringBeanReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/references/SpringBeanReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/references/SpringBeanReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanPointers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

