/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.maven;

import com.intellij.javaee.maven.JavaeeArtifactProperties;
import com.intellij.javaee.maven.JavaeeMavenBundle;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class JavaeeArtifactConfigurable
extends ArtifactPropertiesEditor {
    private final JComponent myPanel = new JPanel(new FlowLayout(0));
    private final ArtifactEditorContext myContext;
    private final JavaeeArtifactProperties myProperties;
    private final JBCheckBox myUnpackModuleJarsCB;

    public JavaeeArtifactConfigurable(JavaeeArtifactProperties properties, ArtifactEditorContext context) {
        this.myContext = context;
        this.myProperties = properties;
        this.myUnpackModuleJarsCB = new JBCheckBox(JavaeeMavenBundle.message("maven.jee.unpack.nested.archives", new Object[0]), this.myProperties.getUnpackNestedArchives());
        if (properties.getExploded()) {
            this.myPanel.add((Component)this.myUnpackModuleJarsCB);
        }
    }

    public String getTabName() {
        return "Maven";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myProperties.getUnpackNestedArchives() != this.myUnpackModuleJarsCB.isSelected();
    }

    public void apply() {
        Artifact artifact;
        this.myProperties.setUnpackNestedArchives(this.myUnpackModuleJarsCB.isSelected());
        String moduleName = this.myProperties.getModuleName();
        Module module = this.myContext.getModulesProvider().getModule(moduleName);
        if (module != null) {
            ExternalProjectsManager.getInstance((Project)module.getProject()).getExternalProjectsWatcher().markDirty(module);
        }
        if ((artifact = this.myContext.getArtifact()) != null) {
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{artifact.getOutputFile()});
        }
    }
}

