/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.buildSystems.gradle;

import com.intellij.kotlin.jupyter.core.projectModel.ExternalBuildSystemSetting;
import com.intellij.kotlin.jupyter.core.projectModel.NotebookExternalBuildSystemConfigurationExtractor;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/buildSystems/gradle/GradleConfigurationExtractor;", "Lcom/intellij/kotlin/jupyter/core/projectModel/NotebookExternalBuildSystemConfigurationExtractor;", "<init>", "()V", "getRecognizedBuildSettings", "Lcom/intellij/kotlin/jupyter/core/projectModel/ExternalBuildSystemSetting;", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "intellij.kotlin.jupyter.buildSystems.gradle"})
public final class GradleConfigurationExtractor
implements NotebookExternalBuildSystemConfigurationExtractor {
    @Nullable
    public ExternalBuildSystemSetting getRecognizedBuildSettings(@NotNull Project project, @NotNull ExternalProjectSettings projectSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectSettings, (String)"projectSettings");
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        if (!(projectSettings instanceof GradleProjectSettings)) {
            return null;
        }
        String string = ((GradleProjectSettings)projectSettings).getGradleJvm();
        if (string == null) {
            return null;
        }
        String jdkName = string;
        Sdk sdk = jdkTable.findJdk(jdkName);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        Set set = ((GradleProjectSettings)projectSettings).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getModules(...)");
        return new ExternalBuildSystemSetting(jdkName, sdk2, CollectionsKt.toSet((Iterable)set));
    }
}

