/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.AffineTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010!\u001a\u00020\u0007J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgTransformParser;", "", "()V", "FIRST_PARAM_INDEX", "", "NAME_INDEX", "OPTIONAL_PARAM", "", "ROTATE_ANGLE", "ROTATE_X", "ROTATE_Y", "SCALE_X", "SCALE_Y", "SKEW_X_ANGLE", "SKEW_Y_ANGLE", "TRANSFORM", "TRANSFORM_EXP", "Lkotlin/text/Regex;", "TRANSLATE_X", "TRANSLATE_Y", "getName", "matcher", "Lkotlin/text/MatchResult;", "getParam", "i", "getParamCount", "parse", "", "Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgTransformParser$TransformData;", "input", "regExp", "parseSvgTransform", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "svgTransform", "parseTransform", "toRadians", "", "degrees", "MyPatternBuilder", "TransformData", "plot-raster"})
public final class SvgTransformParser {
    @NotNull
    public static final SvgTransformParser INSTANCE = new SvgTransformParser();
    private static final int SCALE_X = 0;
    private static final int SCALE_Y = 1;
    private static final int SKEW_X_ANGLE = 0;
    private static final int SKEW_Y_ANGLE = 0;
    private static final int ROTATE_ANGLE = 0;
    private static final int ROTATE_X = 1;
    private static final int ROTATE_Y = 2;
    private static final int TRANSLATE_X = 0;
    private static final int TRANSLATE_Y = 1;
    @NotNull
    private static final String OPTIONAL_PARAM = "(-?\\d+\\.?\\d*)?,? ?";
    @NotNull
    private static final String TRANSFORM;
    @NotNull
    private static final Regex TRANSFORM_EXP;
    private static final int NAME_INDEX = 1;
    private static final int FIRST_PARAM_INDEX = 2;

    private SvgTransformParser() {
    }

    private final double toRadians(double degrees) {
        return degrees * Math.PI / (double)180;
    }

    @NotNull
    public final List<AffineTransform> parseSvgTransform(@NotNull String svgTransform) {
        Intrinsics.checkNotNullParameter((Object)svgTransform, (String)"svgTransform");
        List<TransformData> transformData = this.parseTransform(svgTransform);
        ArrayList<AffineTransform> transforms = new ArrayList<AffineTransform>();
        for (TransformData res : transformData) {
            AffineTransform affineTransform;
            switch (res.getName()) {
                case "scale": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double scaleX = d;
                    Double d2 = res.getParam(1);
                    double scaleY = d2 != null ? d2 : scaleX;
                    affineTransform = AffineTransform.Companion.makeScale((Number)scaleX, (Number)scaleY);
                    break;
                }
                case "skewX": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double angle = d;
                    double factor = Math.sin(this.toRadians(angle));
                    affineTransform = AffineTransform.Companion.makeShear((Number)factor, (Number)0.0);
                    break;
                }
                case "skewY": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double angle = d;
                    double factor = Math.sin(this.toRadians(angle));
                    affineTransform = AffineTransform.Companion.makeShear((Number)0.0, (Number)factor);
                    break;
                }
                case "rotate": {
                    double d;
                    double pivotX;
                    double d3;
                    Double d4 = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d4);
                    double angle = this.toRadians(d4);
                    if (res.getParamCount() == 3) {
                        Double d5 = res.getParam(1);
                        Intrinsics.checkNotNull((Object)d5);
                        d3 = d5;
                    } else {
                        d3 = pivotX = 0.0;
                    }
                    if (res.getParamCount() == 3) {
                        Double d6 = res.getParam(2);
                        Intrinsics.checkNotNull((Object)d6);
                        d = d6;
                    } else {
                        d = 0.0;
                    }
                    double pivotY = d;
                    affineTransform = AffineTransform.Companion.makeRotation((Number)angle, (Number)pivotX, (Number)pivotY);
                    break;
                }
                case "translate": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double dX = d;
                    Double d7 = res.getParam(1);
                    double dY = d7 != null ? d7 : 0.0;
                    affineTransform = AffineTransform.Companion.makeTranslation((Number)dX, (Number)dY);
                    break;
                }
                case "matrix": {
                    throw new IllegalStateException("UNSUPPORTED: We don't use MATRIX".toString());
                }
                default: {
                    throw new IllegalArgumentException("Unknown transform: " + res.getName());
                }
            }
            AffineTransform transform = affineTransform;
            transforms.add(transform);
        }
        return transforms;
    }

    private final List<TransformData> parseTransform(String input) {
        return this.parse(input, TRANSFORM_EXP);
    }

    private final String getName(MatchResult matcher) {
        return (String)matcher.getGroupValues().get(1);
    }

    private final String getParam(MatchResult matcher, int i) {
        return (String)matcher.getGroupValues().get(i + 2);
    }

    private final int getParamCount(MatchResult matcher) {
        return matcher.getGroupValues().size() - 2;
    }

    private final List<TransformData> parse(String input, Regex regExp) {
        if (input == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<TransformData> transformData = new ArrayList<TransformData>();
        for (MatchResult matcher = Regex.find$default((Regex)regExp, (CharSequence)input, (int)0, (int)2, null); matcher != null; matcher = matcher.next()) {
            String g;
            int paramCount = this.getParamCount(matcher);
            TransformData r = new TransformData(this.getName(matcher), paramCount);
            for (int i = 0; i < paramCount && this.getParam(matcher, i) != null && !Intrinsics.areEqual((Object)g, (Object)""); ++i) {
                r.addParam(g);
            }
            transformData.add(r);
        }
        return transformData;
    }

    static {
        String[] stringArray = new String[]{"translate", "rotate", "scale", "skewX", "skewY", "matrix"};
        TRANSFORM = new MyPatternBuilder("(").or(stringArray).append(")\\( ?(-?\\d+\\.?\\d*),? ?").pluralAppend(OPTIONAL_PARAM, 5).append("\\)").toString();
        TRANSFORM_EXP = new Regex(TRANSFORM);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000b\"\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgTransformParser$MyPatternBuilder;", "", "s", "", "(Ljava/lang/String;)V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "or", "ss", "", "([Ljava/lang/String;)Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgTransformParser$MyPatternBuilder;", "pluralAppend", "count", "", "toString", "plot-raster"})
    private static final class MyPatternBuilder {
        @NotNull
        private final StringBuilder sb;

        public MyPatternBuilder(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.sb = new StringBuilder(s);
        }

        @NotNull
        public final MyPatternBuilder append(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.sb.append(s);
            return this;
        }

        @NotNull
        public final MyPatternBuilder pluralAppend(@NotNull String s, int count) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            for (int i = 0; i < count; ++i) {
                this.sb.append(s);
            }
            return this;
        }

        @NotNull
        public final MyPatternBuilder or(String ... ss) {
            Intrinsics.checkNotNullParameter((Object)ss, (String)"ss");
            int ssLastIndex = ss.length - 1;
            int n = ss.length;
            for (int i = 0; i < n; ++i) {
                int index = i;
                String s = ss[i];
                this.sb.append(s);
                if (index >= ssLastIndex) continue;
                this.sb.append('|');
            }
            return this;
        }

        @NotNull
        public String toString() {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0015\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0019R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgTransformParser$TransformData;", "", "name", "", "paramCount", "", "(Ljava/lang/String;I)V", "args", "", "", "getArgs", "()Ljava/util/List;", "myParams", "", "getName", "()Ljava/lang/String;", "getParamCount", "()I", "addParam", "", "p", "containsParam", "", "i", "getParam", "(I)Ljava/lang/Double;", "plot-raster"})
    public static final class TransformData {
        @NotNull
        private final String name;
        @NotNull
        private final List<Double> myParams;

        public TransformData(@NotNull String name, int paramCount) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.myParams = new ArrayList(paramCount);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<Double> getArgs() {
            return this.myParams;
        }

        public final int getParamCount() {
            return this.myParams.size();
        }

        public final void addParam(@Nullable String p) {
            Double d;
            if (Intrinsics.areEqual((Object)p, (Object)"")) {
                d = null;
            } else {
                String string = p;
                d = string != null ? Double.valueOf(Double.parseDouble(string)) : null;
            }
            this.myParams.add(d);
        }

        @Nullable
        public final Double getParam(int i) {
            if (!this.containsParam(i)) {
                return null;
            }
            return this.myParams.get(i);
        }

        public final boolean containsParam(int i) {
            return i < this.getParamCount();
        }
    }
}

