/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Property;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;

public class MavenImportingSettings
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(MavenImportingSettings.class);
    private static final String PROCESS_RESOURCES_PHASE = "process-resources";
    public static final String[] UPDATE_FOLDERS_PHASES = new String[]{"generate-sources", "process-sources", "generate-resources", "process-resources", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources"};
    public static final String UPDATE_FOLDERS_DEFAULT_PHASE = "process-resources";
    public static final String DEFAULT_DEPENDENCY_TYPES = "jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle";
    @NotNull
    @NlsSafe
    private String dedicatedModuleDir = "";
    private boolean lookForNested = false;
    private boolean importAutomatically = false;
    private boolean excludeTargetFolder = true;
    private boolean useMavenOutput = true;
    @NlsSafe
    private String updateFoldersOnImportPhase = "process-resources";
    private boolean downloadSourcesAutomatically = false;
    private boolean downloadDocsAutomatically = false;
    private boolean downloadAnnotationsAutomatically = false;
    private boolean autoDetectCompiler = true;
    private GeneratedSourcesFolder generatedSourcesFolder = GeneratedSourcesFolder.AUTODETECT;
    private String dependencyTypes = "jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle";
    private Set<String> myDependencyTypesAsSet;
    @NotNull
    @NlsSafe
    private String vmOptionsForImporter = "";
    @NotNull
    @NlsSafe
    private String jdkForImporter = "#USE_PROJECT_JDK";
    private boolean runPluginsCompatibilityOnSyncAndBuild;

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    @NlsSafe
    public String getDedicatedModuleDir() {
        String string = this.dedicatedModuleDir;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Deprecated
    @ApiStatus.Internal
    public void setDedicatedModuleDir(@NotNull String dedicatedModuleDir) {
        if (dedicatedModuleDir == null) {
            MavenImportingSettings.$$$reportNull$$$0(1);
        }
        this.dedicatedModuleDir = dedicatedModuleDir;
    }

    public boolean isLookForNested() {
        return this.lookForNested;
    }

    public void setLookForNested(boolean lookForNested) {
        this.lookForNested = lookForNested;
    }

    @Deprecated(forRemoval=true)
    public boolean isImportAutomatically() {
        return this.importAutomatically;
    }

    @Deprecated(forRemoval=true)
    public void setImportAutomatically(boolean importAutomatically) {
        this.importAutomatically = importAutomatically;
    }

    @NotNull
    public String getDependencyTypes() {
        String string = this.dependencyTypes;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setDependencyTypes(@NotNull String dependencyTypes) {
        if (dependencyTypes == null) {
            MavenImportingSettings.$$$reportNull$$$0(3);
        }
        this.dependencyTypes = dependencyTypes;
        this.myDependencyTypesAsSet = null;
    }

    @NotNull
    public Set<String> getDependencyTypesAsSet() {
        if (this.myDependencyTypesAsSet == null) {
            LinkedHashSet<String> res = new LinkedHashSet<String>();
            for (String type : StringUtil.tokenize((String)this.dependencyTypes, (String)" \n\r\t,;")) {
                res.add(type);
            }
            this.myDependencyTypesAsSet = res;
        }
        Set<String> set = this.myDependencyTypesAsSet;
        if (set == null) {
            MavenImportingSettings.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isExcludeTargetFolder() {
        return this.excludeTargetFolder;
    }

    public void setExcludeTargetFolder(boolean excludeTargetFolder) {
        this.excludeTargetFolder = excludeTargetFolder;
    }

    public boolean isUseMavenOutput() {
        return this.useMavenOutput;
    }

    public void setUseMavenOutput(boolean useMavenOutput) {
        this.useMavenOutput = useMavenOutput;
    }

    @NlsSafe
    public String getUpdateFoldersOnImportPhase() {
        return this.updateFoldersOnImportPhase;
    }

    public void setUpdateFoldersOnImportPhase(String updateFoldersOnImportPhase) {
        this.updateFoldersOnImportPhase = updateFoldersOnImportPhase;
    }

    public boolean isDownloadSourcesAutomatically() {
        return this.downloadSourcesAutomatically;
    }

    public void setDownloadSourcesAutomatically(boolean Value) {
        this.downloadSourcesAutomatically = Value;
    }

    public boolean isDownloadDocsAutomatically() {
        return this.downloadDocsAutomatically;
    }

    public void setDownloadDocsAutomatically(boolean value) {
        this.downloadDocsAutomatically = value;
    }

    public boolean isDownloadAnnotationsAutomatically() {
        return this.downloadAnnotationsAutomatically;
    }

    public void setDownloadAnnotationsAutomatically(boolean value) {
        this.downloadAnnotationsAutomatically = value;
    }

    public boolean isAutoDetectCompiler() {
        return this.autoDetectCompiler;
    }

    public void setAutoDetectCompiler(boolean autoDetectCompiler) {
        this.autoDetectCompiler = autoDetectCompiler;
    }

    @Property
    @NotNull
    public GeneratedSourcesFolder getGeneratedSourcesFolder() {
        GeneratedSourcesFolder generatedSourcesFolder = this.generatedSourcesFolder;
        if (generatedSourcesFolder == null) {
            MavenImportingSettings.$$$reportNull$$$0(5);
        }
        return generatedSourcesFolder;
    }

    public void setGeneratedSourcesFolder(GeneratedSourcesFolder generatedSourcesFolder) {
        if (generatedSourcesFolder == null) {
            return;
        }
        this.generatedSourcesFolder = generatedSourcesFolder;
    }

    @NotNull
    public String getVmOptionsForImporter() {
        String string = this.vmOptionsForImporter;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setVmOptionsForImporter(String vmOptionsForImporter) {
        this.vmOptionsForImporter = StringUtil.notNullize((String)vmOptionsForImporter);
    }

    @NotNull
    public String getJdkForImporter() {
        String string = this.jdkForImporter;
        if (string == null) {
            MavenImportingSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setJdkForImporter(@NotNull String jdkForImporter) {
        if (jdkForImporter == null) {
            MavenImportingSettings.$$$reportNull$$$0(8);
        }
        this.jdkForImporter = jdkForImporter;
    }

    public void setRunPluginsCompatibilityOnSyncAndBuild(boolean runPluginsCompatibilityOnSyncAndBuild) {
        this.runPluginsCompatibilityOnSyncAndBuild = runPluginsCompatibilityOnSyncAndBuild;
    }

    public boolean isRunPluginsCompatibilityOnSyncAndBuild() {
        return this.runPluginsCompatibilityOnSyncAndBuild;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenImportingSettings that = (MavenImportingSettings)o;
        if (!this.dependencyTypes.equals(that.dependencyTypes)) {
            return false;
        }
        if (this.downloadDocsAutomatically != that.downloadDocsAutomatically) {
            return false;
        }
        if (this.downloadSourcesAutomatically != that.downloadSourcesAutomatically) {
            return false;
        }
        if (this.downloadAnnotationsAutomatically != that.downloadAnnotationsAutomatically) {
            return false;
        }
        if (this.autoDetectCompiler != that.autoDetectCompiler) {
            return false;
        }
        if (this.excludeTargetFolder != that.excludeTargetFolder) {
            return false;
        }
        if (this.useMavenOutput != that.useMavenOutput) {
            return false;
        }
        if (this.generatedSourcesFolder != that.generatedSourcesFolder) {
            return false;
        }
        if (!this.jdkForImporter.equals(that.jdkForImporter)) {
            return false;
        }
        if (!this.vmOptionsForImporter.equals(that.vmOptionsForImporter)) {
            return false;
        }
        if (this.runPluginsCompatibilityOnSyncAndBuild != that.runPluginsCompatibilityOnSyncAndBuild) {
            return false;
        }
        return !(this.updateFoldersOnImportPhase != null ? !this.updateFoldersOnImportPhase.equals(that.updateFoldersOnImportPhase) : that.updateFoldersOnImportPhase != null);
    }

    public int hashCode() {
        int result2 = 0;
        if (this.useMavenOutput) {
            ++result2;
        }
        result2 <<= 1;
        if (this.downloadSourcesAutomatically) {
            ++result2;
        }
        result2 <<= 1;
        if (this.downloadDocsAutomatically) {
            ++result2;
        }
        result2 <<= 1;
        if (this.downloadAnnotationsAutomatically) {
            ++result2;
        }
        result2 <<= 1;
        if (this.autoDetectCompiler) {
            ++result2;
        }
        result2 <<= 1;
        if (this.runPluginsCompatibilityOnSyncAndBuild) {
            ++result2;
        }
        result2 <<= 1;
        result2 = 31 * result2 + (this.updateFoldersOnImportPhase != null ? this.updateFoldersOnImportPhase.hashCode() : 0);
        result2 = 31 * result2 + this.generatedSourcesFolder.hashCode();
        result2 = 31 * result2 + this.dependencyTypes.hashCode();
        return result2;
    }

    public MavenImportingSettings clone() {
        try {
            MavenImportingSettings result2 = (MavenImportingSettings)super.clone();
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenImportingSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dedicatedModuleDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkForImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDedicatedModuleDir";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyTypesAsSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptionsForImporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkForImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDedicatedModuleDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDependencyTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setJdkForImporter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 8 -> new IllegalArgumentException(string);
        };
    }

    public static enum GeneratedSourcesFolder {
        IGNORE("maven.settings.generated.folder.ignore"),
        AUTODETECT("maven.settings.generated.folder.autodetect"),
        GENERATED_SOURCE_FOLDER("maven.settings.generated.folder.targerdir"),
        SUBFOLDER("maven.settings.generated.folder.targersubdir");

        public final String myMessageKey;

        private GeneratedSourcesFolder(String messageKey) {
            this.myMessageKey = messageKey;
        }

        @NlsContexts.ListItem
        public String getTitle() {
            return MavenConfigurableBundle.message(this.myMessageKey, new Object[0]);
        }
    }
}

